/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.UUID;
import java.util.function.Function;

public abstract class VncFunction
extends VncVal
implements Function<VncList, VncVal>,
Cloneable {
    private static final long serialVersionUID = -1848883965231344442L;
    public VncVal ast;
    public Env env;
    public VncList params;
    public boolean macro = false;
    public final String name;

    public VncFunction() {
        this(null, null, null, null);
    }

    public VncFunction(String name) {
        this(name, null, null, null);
    }

    public VncFunction(VncVal ast, Env env, VncList params) {
        this(null, ast, env, params);
    }

    public VncFunction(String name, VncVal ast, Env env, VncList params) {
        this.name = name == null ? VncFunction.createAnonymousFuncName() : name;
        this.ast = ast;
        this.env = env;
        this.params = params;
    }

    @Override
    public VncFunction copy() {
        try {
            VncFunction v = (VncFunction)this.clone();
            v.ast = this.ast;
            v.env = this.env;
            v.params = this.params;
            v.macro = this.macro;
            v.setMeta(this.getMeta());
            return v;
        }
        catch (Exception ex) {
            throw new VncException("Could not copy VncFunction: " + this, ex);
        }
    }

    public VncVal getAst() {
        return this.ast;
    }

    public Env getEnv() {
        return this.env;
    }

    public VncList getParams() {
        return this.params;
    }

    public Env genEnv(VncList args) {
        Env localEnv = new Env(this.env);
        Destructuring.destructure(this.params, args).forEach(b -> localEnv.set(b.sym, b.val));
        return localEnv;
    }

    public boolean isMacro() {
        return this.macro;
    }

    public void setMacro() {
        this.macro = true;
    }

    public String getName() {
        return this.name;
    }

    public static String createAnonymousFuncName() {
        return "anonymous-" + UUID.randomUUID().toString();
    }

    public VncList getArgLists() {
        return (VncList)this.getMetaVal(MetaUtil.ARGLIST, new VncList(new VncVal[0]));
    }

    public void setArgLists(String ... arglists) {
        MetaUtil.setArgList(this, arglists);
    }

    public VncVal getDoc() {
        return this.getMetaVal(MetaUtil.DOC);
    }

    public void setDoc(String doc) {
        MetaUtil.setDoc(this, doc);
    }

    public VncList getExamples() {
        return (VncList)this.getMetaVal(MetaUtil.EXAMPLES, new VncList(new VncVal[0]));
    }

    public void setExamples(String ... examples) {
        MetaUtil.setExamples(this, examples);
    }

    public String toString() {
        return this.name;
    }
}

