/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import java.util.Map;

public class VncThreadLocal
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;

    public VncThreadLocal() {
    }

    public VncThreadLocal(Map<VncVal, VncVal> val) {
        val.entrySet().forEach(e -> this.set(Coerce.toVncKeyword((VncVal)e.getKey()), (VncVal)e.getValue()));
    }

    public VncThreadLocal(VncList lst) {
        this.assoc(lst);
    }

    @Override
    public VncThreadLocal copy() {
        return this;
    }

    public VncVal get(VncKeyword key) {
        return ThreadLocalMap.get(key);
    }

    public VncVal get(VncKeyword key, VncVal defaultValue) {
        return ThreadLocalMap.get(key, defaultValue);
    }

    public VncVal get(String key) {
        return this.get(new VncKeyword(key));
    }

    public VncVal get(String key, VncVal defaultValue) {
        return this.get(new VncKeyword(key), defaultValue);
    }

    public void set(VncKeyword key, VncVal val) {
        ThreadLocalMap.set(key, val);
    }

    public void remove(VncKeyword key) {
        ThreadLocalMap.remove(key);
    }

    public VncVal containsKey(VncKeyword key) {
        return key != null && ThreadLocalMap.containsKey(key) ? Constants.True : Constants.False;
    }

    public VncThreadLocal assoc(VncVal ... kvs) {
        for (int ii = 0; ii < kvs.length; ii += 2) {
            this.set(Coerce.toVncKeyword(kvs[ii]), kvs[ii + 1]);
        }
        return this;
    }

    public VncThreadLocal assoc(VncList lst) {
        for (int i = 0; i < lst.getList().size(); i += 2) {
            this.set(Coerce.toVncKeyword(lst.nth(i)), lst.nth(i + 1));
        }
        return this;
    }

    public VncThreadLocal dissoc(VncList lst) {
        for (int i = 0; i < lst.getList().size(); ++i) {
            this.remove(Coerce.toVncKeyword(lst.nth(i)));
        }
        return this;
    }

    public VncThreadLocal dissoc(VncKeyword ... ks) {
        for (int ii = 0; ii < ks.length; ++ii) {
            this.remove(ks[ii]);
        }
        return this;
    }

    public VncThreadLocal clear() {
        ThreadLocalMap.clear();
        return this;
    }

    public String toString() {
        return "ThreadLocal";
    }
}

