/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VncSet
extends VncCollection {
    private static final long serialVersionUID = -1848883965231344442L;
    private final HashSet<VncVal> value;

    public VncSet(Set<VncVal> val) {
        this.value = val instanceof HashSet ? (HashSet<Object>)val : new HashSet<VncVal>(val);
    }

    public VncSet(VncList lst) {
        this.value = new HashSet();
        this.value.addAll(lst.getList());
    }

    public VncSet(VncVal ... mvs) {
        this.value = new HashSet();
        if (mvs != null) {
            for (VncVal v : mvs) {
                this.value.add(v);
            }
        }
    }

    @Override
    public VncSet empty() {
        return new VncSet(new VncVal[0]);
    }

    public void add(VncVal val) {
        this.value.add(val);
    }

    public void remove(VncVal val) {
        this.value.remove(val);
    }

    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public VncSet copy() {
        return new VncSet((HashSet)this.value.clone());
    }

    public Set<VncVal> getSet() {
        return this.value;
    }

    public List<VncVal> getList() {
        return new ArrayList<VncVal>(this.value);
    }

    public VncVector toVncVector() {
        return new VncVector(this.getList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSet other = (VncSet)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getList(), " ", print_readably) + "}";
    }
}

