/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Destructuring {
    private static final VncKeyword KW_AS = new VncKeyword(":as");
    private static final VncKeyword KW_OR = new VncKeyword(":or");
    private static final VncKeyword KW_KEYS = new VncKeyword(":keys");
    private static final VncKeyword KW_SYMS = new VncKeyword(":syms");
    private static final VncKeyword KW_STRS = new VncKeyword(":strs");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Binding> destructure(VncVal symVal, VncVal bindVal) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (Types.isVncSymbol(symVal)) {
            bindings.add(new Binding((VncSymbol)symVal, bindVal));
            return bindings;
        } else if (Types.isVncList(symVal)) {
            if (bindVal == Constants.Nil) {
                Destructuring.sequential_list_destructure((VncList)symVal, new VncList(new VncVal[0]), bindings);
            }
            if (Types.isVncList(bindVal)) {
                Destructuring.sequential_list_destructure((VncList)symVal, bindVal, bindings);
                return bindings;
            } else {
                if (!Types.isVncString(bindVal)) throw new VncException(String.format("Invalid sequential destructuring bind value type %s. Expected list, vector, or string. %s", Types.getClassName(bindVal), ErrorMessage.buildErrLocation(bindVal)));
                Destructuring.sequential_string_destructure((VncList)symVal, bindVal, bindings);
            }
            return bindings;
        } else {
            if (!Types.isVncMap(symVal)) throw new VncException(String.format("Invalid destructuring sym value type %s. Expected symbol. %s", Types.getClassName(symVal), ErrorMessage.buildErrLocation(symVal)));
            if (bindVal == Constants.Nil) {
                Destructuring.associative_map_destructure((VncMap)symVal, new VncHashMap(new VncVal[0]), bindings);
                return bindings;
            } else if (Types.isVncMap(bindVal)) {
                Destructuring.associative_map_destructure((VncMap)symVal, bindVal, bindings);
                return bindings;
            } else {
                if (!Types.isVncVector(bindVal)) throw new VncException(String.format("Invalid associative destructuring bind value type %s. Expected map. %s", Types.getClassName(bindVal), ErrorMessage.buildErrLocation(bindVal)));
                throw new VncException(String.format("Associative destructuring on vector is not yet implemented", Types.getClassName(bindVal), ErrorMessage.buildErrLocation(bindVal)));
            }
        }
    }

    private static void sequential_list_destructure(VncList symVal, VncVal bindVal, List<Binding> bindings) {
        List<VncVal> symbols = symVal.getList();
        List<VncVal> values = ((VncList)bindVal).getList();
        int symIdx = 0;
        int valIdx = 0;
        while (symIdx < symbols.size()) {
            VncVal syms;
            VncVal val;
            VncSymbol sym;
            if (Destructuring.isIgnoreBindingSymbol(symbols.get(symIdx))) {
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (Destructuring.isElisionSymbol(symbols.get(symIdx))) {
                sym = (VncSymbol)symbols.get(symIdx + 1);
                val = valIdx < values.size() ? ((VncList)bindVal).slice(valIdx) : new VncList(new VncVal[0]);
                bindings.add(new Binding(sym, val));
                symIdx += 2;
                valIdx = values.size();
                continue;
            }
            if (Destructuring.isAsKeyword(symbols.get(symIdx))) {
                sym = (VncSymbol)symbols.get(symIdx + 1);
                bindings.add(new Binding(sym, bindVal));
                symIdx += 2;
                continue;
            }
            if (Types.isVncSymbol(symbols.get(symIdx))) {
                sym = (VncSymbol)symbols.get(symIdx);
                val = valIdx < values.size() ? values.get(valIdx) : Constants.Nil;
                bindings.add(new Binding(sym, val));
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (Types.isVncList(symbols.get(symIdx))) {
                syms = symbols.get(symIdx);
                val = valIdx < values.size() ? values.get(valIdx) : Constants.Nil;
                bindings.addAll(Destructuring.destructure(syms, val));
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (!Types.isVncMap(symbols.get(symIdx))) continue;
            syms = (VncMap)symbols.get(symIdx);
            val = valIdx < values.size() ? values.get(valIdx) : Constants.Nil;
            Destructuring.associative_map_destructure((VncMap)syms, val == Constants.Nil ? new VncHashMap(new VncVal[0]) : val, bindings);
            ++symIdx;
            ++valIdx;
        }
    }

    private static void sequential_string_destructure(VncList symVal, VncVal bindVal, List<Binding> bindings) {
        List<VncVal> symbols = symVal.getList();
        List<Object> values = bindVal == Constants.Nil ? new ArrayList() : ((VncString)bindVal).toVncList().getList();
        int symIdx = 0;
        int valIdx = 0;
        while (symIdx < symbols.size()) {
            VncVal val;
            VncSymbol sym;
            if (Destructuring.isIgnoreBindingSymbol(symbols.get(symIdx))) {
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (Destructuring.isElisionSymbol(symbols.get(symIdx))) {
                sym = (VncSymbol)symbols.get(symIdx + 1);
                val = valIdx < values.size() ? ((VncString)bindVal).toVncList().slice(valIdx) : new VncList(new VncVal[0]);
                bindings.add(new Binding(sym, val));
                symIdx += 2;
                valIdx = values.size();
                continue;
            }
            if (Destructuring.isAsKeyword(symbols.get(symIdx))) {
                sym = (VncSymbol)symbols.get(symIdx + 1);
                bindings.add(new Binding(sym, bindVal));
                symIdx += 2;
                continue;
            }
            sym = (VncSymbol)symbols.get(symIdx);
            val = valIdx < values.size() ? (VncVal)values.get(valIdx) : Constants.Nil;
            bindings.add(new Binding(sym, val));
            ++symIdx;
            ++valIdx;
        }
    }

    private static void associative_map_destructure(VncMap symVal, VncVal bindVal, List<Binding> bindings) {
        ArrayList<Binding> local_bindings = new ArrayList<Binding>();
        List<VncVal> symbols = Destructuring.sortAssociativeNames(symVal.keys().getList());
        for (int ii = 0; ii < symbols.size(); ++ii) {
            VncVal symbol;
            VncVal symValName = symbols.get(ii);
            if (symValName.equals(KW_KEYS)) {
                symbol = symVal.get(KW_KEYS);
                if (Types.isVncVector(symbol)) {
                    ((VncVector)symbol).forEach(sym -> {
                        VncSymbol s = (VncSymbol)sym;
                        VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(new VncKeyword(s.getName()));
                        local_bindings.add(new Binding(s, v));
                    });
                    continue;
                }
                throw new VncException(String.format("Invalid associative destructuring with :keys symbol type %s. Expected vector. %s", Types.getClassName(symbol), ErrorMessage.buildErrLocation(symbol)));
            }
            if (symValName.equals(KW_SYMS)) {
                symbol = symVal.get(KW_SYMS);
                if (Types.isVncVector(symbol)) {
                    ((VncVector)symbol).forEach(sym -> {
                        VncSymbol s = (VncSymbol)sym;
                        VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(s);
                        local_bindings.add(new Binding(s, v));
                    });
                    continue;
                }
                throw new VncException(String.format("Invalid associative destructuring with :syms symbol type %s. Expected vector. %s", Types.getClassName(symbol), ErrorMessage.buildErrLocation(symbol)));
            }
            if (symValName.equals(KW_STRS)) {
                symbol = symVal.get(KW_STRS);
                if (Types.isVncVector(symbol)) {
                    ((VncVector)symbol).forEach(sym -> {
                        VncSymbol s = (VncSymbol)sym;
                        VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(new VncString(s.getName()));
                        local_bindings.add(new Binding(s, v));
                    });
                    continue;
                }
                throw new VncException(String.format("Invalid associative destructuring with :strs symbol type %s. Expected vector. %s", Types.getClassName(symbol), ErrorMessage.buildErrLocation(symbol)));
            }
            if (symValName.equals(KW_OR)) {
                symbol = symVal.get(KW_OR);
                if (symbol == Constants.Nil || !Types.isVncMap(symbol)) continue;
                ((VncMap)symbol).entries().forEach(e -> {
                    int bIdx = Binding.getBindingIndex((VncSymbol)e.getKey(), local_bindings);
                    if (bIdx == -1) {
                        local_bindings.add(new Binding((VncSymbol)e.getKey(), (VncVal)e.getValue()));
                    } else {
                        Binding b = (Binding)local_bindings.get(bIdx);
                        if (b.val == Constants.Nil) {
                            local_bindings.set(bIdx, new Binding((VncSymbol)e.getKey(), (VncVal)e.getValue()));
                        }
                    }
                });
                continue;
            }
            if (symValName.equals(KW_AS)) {
                symbol = symVal.get(KW_AS);
                if (symbol == Constants.Nil || !Types.isVncSymbol(symbol)) continue;
                local_bindings.add(new Binding((VncSymbol)symbol, bindVal));
                continue;
            }
            if (Types.isVncMap(symValName)) {
                Destructuring.associative_map_destructure((VncMap)symValName, ((VncMap)bindVal).get(symVal.get(symValName)), local_bindings);
                continue;
            }
            if (Types.isVncList(symValName)) {
                Destructuring.sequential_list_destructure((VncList)symValName, ((VncMap)bindVal).get(symVal.get(symValName)), local_bindings);
                continue;
            }
            if (Types.isVncSymbol(symValName)) {
                VncVal s = symVal.get(symValName);
                VncConstant v = bindVal == Constants.Nil ? Constants.Nil : ((VncMap)bindVal).get(s);
                local_bindings.add(new Binding((VncSymbol)symValName, v));
                continue;
            }
            throw new VncException(String.format("Invalid associative destructuring name type %s. %s", Types.getClassName(symValName), ErrorMessage.buildErrLocation(symValName)));
        }
        bindings.addAll(local_bindings);
    }

    private static boolean isAsKeyword(VncVal val) {
        return Types.isVncKeyword(val) && ((VncKeyword)val).equals(KW_AS);
    }

    private static boolean isElisionSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("&");
    }

    private static boolean isIgnoreBindingSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("_");
    }

    private static List<VncVal> sortAssociativeNames(List<VncVal> names) {
        ArrayList<VncVal> sorted = new ArrayList<VncVal>();
        sorted.addAll(names.stream().filter(n -> n.equals(KW_KEYS) || n.equals(KW_SYMS) || n.equals(KW_STRS)).collect(Collectors.toList()));
        sorted.addAll(names.stream().filter(n -> n != Constants.Nil).filter(n -> !n.equals(KW_KEYS) && !n.equals(KW_SYMS) && !n.equals(KW_STRS) && !n.equals(KW_AS) && !n.equals(KW_OR)).collect(Collectors.toList()));
        sorted.addAll(names.stream().filter(n -> n.equals(KW_AS) || n.equals(KW_OR)).collect(Collectors.toList()));
        return sorted;
    }
}

