/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.Token;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import java.util.Arrays;
import java.util.stream.Collectors;

public class MetaUtil {
    public static final VncKeyword ARGLIST = new VncKeyword(":arglists");
    public static final VncKeyword DOC = new VncKeyword(":doc");
    public static final VncKeyword EXAMPLES = new VncKeyword(":examples");
    public static final VncKeyword FILE = new VncKeyword(":file");
    public static final VncKeyword LINE = new VncKeyword(":line");
    public static final VncKeyword COLUMN = new VncKeyword(":column");

    public static VncVal addDefMeta(VncVal val, VncMap meta) {
        VncVal examples;
        VncVal doc;
        VncVal argslist = meta.get(ARGLIST);
        if (argslist != Constants.Nil) {
            val.setMetaVal(ARGLIST, argslist);
        }
        if ((doc = meta.get(DOC)) != Constants.Nil) {
            val.setMetaVal(DOC, doc);
        }
        if ((examples = meta.get(EXAMPLES)) != Constants.Nil) {
            val.setMetaVal(EXAMPLES, examples);
        }
        return val;
    }

    public static VncVal setArgList(VncVal val, String ... argList) {
        val.setMetaVal(ARGLIST, new VncList(Arrays.stream(argList).map(s -> new VncString((String)s)).collect(Collectors.toList())));
        return val;
    }

    public static VncVal setDoc(VncVal val, String doc) {
        val.setMetaVal(DOC, new VncString(doc));
        return val;
    }

    public static VncVal setExamples(VncVal val, String ... examples) {
        val.setMetaVal(EXAMPLES, new VncList(Arrays.stream(examples).map(s -> new VncString((String)s)).collect(Collectors.toList())));
        return val;
    }

    public static VncVal withTokenPos(VncVal val, Token token) {
        val.setMetaVal(FILE, new VncString(token.getFile()));
        val.setMetaVal(LINE, new VncLong(token.getLine()));
        val.setMetaVal(COLUMN, new VncLong(token.getColumn()));
        return val;
    }

    public static void copyTokenPos(VncVal from, VncVal to) {
        to.setMetaVal(FILE, from.getMetaVal(FILE));
        to.setMetaVal(LINE, from.getMetaVal(LINE));
        to.setMetaVal(COLUMN, from.getMetaVal(COLUMN));
    }
}

