/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.SpecialForms;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInteropFn;
import com.github.jlangch.venice.impl.javainterop.JavaInteropProxifyFn;
import com.github.jlangch.venice.impl.javainterop.SandboxMaxExecutionTimeChecker;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.util.CallFrameBuilder;
import com.github.jlangch.venice.impl.util.CatchBlock;
import com.github.jlangch.venice.impl.util.Doc;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.util.CallFrame;
import com.github.jlangch.venice.util.ScriptElapsedTime;
import java.io.Closeable;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private final JavaImports javaImports = new JavaImports();
    private final SandboxMaxExecutionTimeChecker sandboxMaxExecutionTimeChecker = new SandboxMaxExecutionTimeChecker();

    public VncVal READ(String script, String filename) {
        return Reader.read_str(script, filename);
    }

    private static boolean is_pair(VncVal x) {
        return x instanceof VncList && !((VncList)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        VncVal a00;
        if (!VeniceInterpreter.is_pair(ast)) {
            return new VncList(new VncSymbol("quote"), ast);
        }
        VncVal a0 = Coerce.toVncList(ast).nth(0);
        if (a0 instanceof VncSymbol && Coerce.toVncSymbol(a0).getName().equals("unquote")) {
            return ((VncList)ast).nth(1);
        }
        if (VeniceInterpreter.is_pair(a0) && (a00 = Coerce.toVncList(a0).nth(0)) instanceof VncSymbol && ((VncSymbol)a00).getName().equals("splice-unquote")) {
            return new VncList(new VncSymbol("concat"), Coerce.toVncList(a0).nth(1), VeniceInterpreter.quasiquote(((VncList)ast).rest()));
        }
        return new VncList(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncList)ast).rest()));
    }

    private boolean is_macro_call(VncVal ast, Env env) {
        VncVal fn;
        VncSymbol macroName;
        VncVal a0;
        return Types.isVncList(ast) && !((VncList)ast).isEmpty() && Types.isVncSymbol(a0 = Coerce.toVncList(ast).nth(0)) && env.findEnv(macroName = (VncSymbol)a0) != null && Types.isVncMacro(fn = env.get(macroName));
    }

    private VncVal macroexpand(VncVal ast, Env env) {
        while (this.is_macro_call(ast, env)) {
            VncSymbol macroName = Coerce.toVncSymbol(Coerce.toVncList(ast).nth(0));
            VncFunction macroFn = Coerce.toVncFunction(env.get(macroName));
            VncList macroFnArgs = Coerce.toVncList(ast).rest();
            ast = (VncVal)macroFn.apply(macroFnArgs);
        }
        return ast;
    }

    private VncVal eval_ast(VncVal ast, Env env) {
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncList) {
            VncList old_lst = (VncList)ast;
            VncList new_lst = old_lst.empty();
            new_lst.setMeta(old_lst.getMeta().copy());
            old_lst.forEach(mv -> new_lst.addAtEnd(this.EVAL((VncVal)mv, env)));
            return new_lst;
        }
        if (ast instanceof VncMap) {
            VncMap old_map = (VncMap)ast;
            VncMap new_map = (VncMap)old_map.empty();
            new_map.setMeta(old_map.getMeta().copy());
            ((VncMap)ast).getMap().entrySet().forEach(entry -> new_map.assoc((VncVal)entry.getKey(), this.EVAL((VncVal)entry.getValue(), env)));
            return new_map;
        }
        return ast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VncVal EVAL(VncVal orig_ast, Env env) {
        VncList ast;
        RecursionPoint recursionPoint = null;
        block45: while (true) {
            String a0sym;
            if (!orig_ast.isList()) {
                return this.eval_ast(orig_ast, env);
            }
            VncVal expanded = this.macroexpand(orig_ast, env);
            if (!expanded.isList()) {
                return this.eval_ast(expanded, env);
            }
            ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            VncVal a0 = ast.nth(0);
            switch (a0sym = a0 instanceof VncSymbol ? ((VncSymbol)a0).getName() : "__<*fn*>__") {
                case "def": {
                    boolean hasMeta = ast.size() > 3;
                    VncHashMap defMeta = hasMeta ? (VncHashMap)this.EVAL(ast.nth(1), env) : new VncHashMap(new VncVal[0]);
                    VncSymbol defName = Coerce.toVncSymbol(ast.nth(hasMeta ? 2 : 1));
                    VncVal defVal = ast.nth(hasMeta ? 3 : 2);
                    VncVal res = this.EVAL(defVal, env);
                    env.setGlobal(new Var(defName, MetaUtil.addDefMeta(res, defMeta), true));
                    return res;
                }
                case "defonce": {
                    boolean hasMeta = ast.size() > 3;
                    VncHashMap defMeta = hasMeta ? (VncHashMap)this.EVAL(ast.nth(1), env) : new VncHashMap(new VncVal[0]);
                    VncSymbol defName = Coerce.toVncSymbol(ast.nth(hasMeta ? 2 : 1));
                    VncVal defVal = ast.nth(hasMeta ? 3 : 2);
                    VncVal res = this.EVAL(defVal, env);
                    env.setGlobal(new Var(defName, MetaUtil.addDefMeta(res, defMeta), false));
                    return res;
                }
                case "def-dynamic": {
                    boolean hasMeta = ast.size() > 3;
                    VncHashMap defMeta = hasMeta ? (VncHashMap)this.EVAL(ast.nth(1), env) : new VncHashMap(new VncVal[0]);
                    VncSymbol defName = Coerce.toVncSymbol(ast.nth(hasMeta ? 2 : 1));
                    VncVal defVal = ast.nth(hasMeta ? 3 : 2);
                    VncVal res = this.EVAL(defVal, env);
                    env.setGlobal(new DynamicVar(defName, MetaUtil.addDefMeta(res, defMeta)));
                    return res;
                }
                case "doc": {
                    String name = ((VncString)CoreFunctions.name.apply(ast.slice(1))).getValue();
                    VncVal docVal = SpecialForms.ns.get(new VncSymbol(name));
                    if (docVal == null) {
                        docVal = env.get(new VncSymbol(name));
                    }
                    orig_ast = new VncList(new VncSymbol("println"), Doc.getDoc(docVal));
                    continue block45;
                }
                case "eval": {
                    orig_ast = Coerce.toVncList(this.eval_ast(ast.slice(1), env)).last();
                    continue block45;
                }
                case "let": {
                    env = new Env(env);
                    VncList bindings = Coerce.toVncList(ast.nth(1));
                    VncVal expressions = ast.slice(2);
                    for (int i = 0; i < bindings.size(); i += 2) {
                        VncVal sym = bindings.nth(i);
                        VncVal val = this.EVAL(bindings.nth(i + 1), env);
                        Env _env = env;
                        Destructuring.destructure(sym, val).forEach(b -> _env.set(b.sym, b.val));
                    }
                    if (((VncList)expressions).isEmpty()) {
                        orig_ast = Constants.Nil;
                        continue block45;
                    }
                    this.eval_ast(((VncList)expressions).slice(0, ((VncList)expressions).size() - 1), env);
                    orig_ast = ((VncList)expressions).last();
                    continue block45;
                }
                case "binding": {
                    return this.binding_(ast, new Env(env));
                }
                case "loop": {
                    env = new Env(env);
                    VncList bindings = Coerce.toVncList(ast.nth(1));
                    VncVal expressions = ast.nth(2);
                    VncList bindingNames = new VncList(new VncVal[0]);
                    for (int i = 0; i < bindings.size(); i += 2) {
                        VncVal sym = bindings.nth(i);
                        VncVal val = this.EVAL(bindings.nth(i + 1), env);
                        Env _env = env;
                        Destructuring.destructure(sym, val).forEach(b -> {
                            _env.set(b.sym, b.val);
                            bindingNames.addAtEnd(b.sym);
                        });
                    }
                    recursionPoint = new RecursionPoint(bindingNames, expressions, env);
                    orig_ast = expressions;
                    continue block45;
                }
                case "recur": {
                    VncList recur_values = new VncList(new VncVal[0]);
                    for (int i = 1; i < ast.size(); ++i) {
                        recur_values.addAtEnd(this.EVAL(ast.nth(i), env));
                    }
                    VncList recur_bindingNames = recursionPoint.getLoopBindingNames();
                    Env recur_env = recursionPoint.getLoopEnv();
                    for (int i = 0; i < recur_bindingNames.size(); ++i) {
                        VncSymbol key = Coerce.toVncSymbol(recur_bindingNames.nth(i));
                        recur_env.set(key, recur_values.nth(i));
                    }
                    orig_ast = recursionPoint.getLoopExpressions();
                    env = recur_env;
                    continue block45;
                }
                case "quote": {
                    return ast.nth(1);
                }
                case "quasiquote": {
                    orig_ast = VeniceInterpreter.quasiquote(ast.nth(1));
                    continue block45;
                }
                case "defmacro": {
                    return this.runWithCallStack("defmacro", ast, env, (a, e) -> this.defmacro_((VncList)a, (Env)e));
                }
                case "macroexpand": {
                    return this.runWithCallStack("macroexpand", ast, env, (a, e) -> this.macroexpand(a.nth(1), (Env)e));
                }
                case "try": {
                    return this.runWithCallStack("try", ast, env, (a, e) -> this.try_((VncList)a, new Env((Env)e)));
                }
                case "try-with": {
                    return this.runWithCallStack("try-with", ast, env, (a, e) -> this.try_with_((VncList)a, new Env((Env)e)));
                }
                case "import": {
                    return this.runWithCallStack("import", ast, env, (a, e) -> {
                        a.slice(1).stream().map(clazzName -> Coerce.toVncString(clazzName).getValue()).forEach(clazzName -> this.javaImports.add((String)clazzName));
                        return Constants.Nil;
                    });
                }
                case "do": {
                    if (ast.size() < 2) {
                        orig_ast = Constants.Nil;
                        continue block45;
                    }
                    VncList head_exprs = ast.slice(1, ast.size() - 1);
                    this.eval_ast(head_exprs, env);
                    orig_ast = ast.last();
                    continue block45;
                }
                case "if": {
                    VncVal condArg = ast.nth(1);
                    VncVal cond = this.EVAL(condArg, env);
                    if (cond == Constants.Nil || cond == Constants.False) {
                        if (ast.size() > 3) {
                            orig_ast = ast.nth(3);
                            continue block45;
                        }
                        return Constants.Nil;
                    }
                    orig_ast = ast.nth(2);
                    continue block45;
                }
                case "fn": {
                    return this.fn_(ast, env);
                }
            }
            break;
        }
        VncList el = Coerce.toVncList(this.eval_ast(ast, env));
        if (Types.isVncFunction(el.nth(0))) {
            this.sandboxMaxExecutionTimeChecker.check();
            VncFunction f = (VncFunction)el.nth(0);
            VncList fnArgs = el.rest();
            MetaUtil.copyTokenPos(el, fnArgs);
            CallFrame frame = CallFrameBuilder.fromFunction(f, ast.nth(0));
            try {
                ThreadLocalMap.getCallStack().push(frame);
                VncVal vncVal = (VncVal)f.apply(fnArgs);
                return vncVal;
            }
            finally {
                ThreadLocalMap.getCallStack().pop();
                this.sandboxMaxExecutionTimeChecker.check();
            }
        }
        if (Types.isVncKeyword(el.nth(0))) {
            VncKeyword k = (VncKeyword)el.nth(0);
            VncList fnArgs = el.rest();
            MetaUtil.copyTokenPos(el, fnArgs);
            return k.apply(fnArgs);
        }
        ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(ast));
        throw new VncException(String.format("Not a function or keyword: '%s'", this.PRINT(el.nth(0))));
    }

    public String PRINT(VncVal exp) {
        return Printer._pr_str(exp, true);
    }

    public VncVal RE(String script, String filename, Env env, ScriptElapsedTime elapsedTime) {
        VncVal ast = this.READ(script, filename);
        if (elapsedTime != null) {
            elapsedTime.readDone();
        }
        VncVal result = this.EVAL(ast, env);
        if (elapsedTime != null) {
            elapsedTime.evalDone();
        }
        return result;
    }

    public Env createEnv() {
        return this.createEnv(null);
    }

    public Env createEnv(List<String> preloadedExtensionModules) {
        Env env = new Env(null);
        Functions.functions.keySet().forEach(key -> env.set((VncSymbol)key, Functions.functions.get(key)));
        env.set(new VncSymbol("."), JavaInteropFn.create(this.javaImports));
        env.set(new VncSymbol("proxify"), new JavaInteropProxifyFn(this.javaImports));
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString("1.2.2-snapshot")));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator())));
        env.setGlobal(new DynamicVar(new VncSymbol("*out*"), new VncJavaObject(new PrintStream(System.out, true))));
        this.RE("(eval " + ModuleLoader.load("core") + ")", "core.venice", env, null);
        if (preloadedExtensionModules != null) {
            preloadedExtensionModules.forEach(m -> this.RE("(eval " + ModuleLoader.load(m) + ")", m + ".venice", env, null));
        }
        return env;
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        String sMacroName;
        int argPos = 1;
        boolean hasMeta = Types.isVncMap(ast.nth(argPos));
        VncHashMap defMeta = hasMeta ? (VncMap)this.EVAL(ast.nth(argPos++), env) : new VncHashMap(new VncVal[0]);
        VncVal macroName = ast.nth(argPos++);
        VncList paramsOrSig = Coerce.toVncList(ast.nth(argPos));
        String string = sMacroName = Types.isVncSymbol(macroName) ? ((VncSymbol)macroName).getName() : ((VncString)macroName).getValue();
        if (Types.isVncVector(paramsOrSig)) {
            VncList macroParams = paramsOrSig;
            int n = ++argPos;
            ++argPos;
            VncVal body = ast.nth(n);
            VncFunction macroFn = this.buildFunction(sMacroName, macroParams, new VncList(body), null, env);
            macroFn.setMacro();
            env.set((VncSymbol)macroName, MetaUtil.addDefMeta(macroFn, defMeta));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncList params = Coerce.toVncList(sig.nth(pos++));
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(sMacroName, params, body, null, env));
        });
        VncMultiArityFunction macro = new VncMultiArityFunction(sMacroName, fns);
        macro.setMacro();
        env.set((VncSymbol)macroName, MetaUtil.addDefMeta(macro, defMeta));
        return macro;
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncList paramsOrSig;
        int argPos = 1;
        String name = this.getFnName(ast.nth(argPos));
        if (name != null) {
            ++argPos;
        }
        if (Types.isVncVector(paramsOrSig = Coerce.toVncList(ast.nth(argPos)))) {
            VncList preConditions;
            VncList params = paramsOrSig;
            if ((preConditions = this.getFnPreconditions(ast.nth(++argPos))) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(name, params, body, preConditions, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncList params = Coerce.toVncList(sig.nth(pos++));
            VncList preConditions = this.getFnPreconditions(sig.nth(pos));
            if (preConditions != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(name, params, body, preConditions, env));
        });
        return new VncMultiArityFunction(name, fns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncList bindings = Coerce.toVncList(ast.nth(1));
        VncList expressions = ast.slice(2);
        ArrayList vars = new ArrayList();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.EVAL(bindings.nth(i + 1), env);
            Destructuring.destructure(sym, val).forEach(b -> vars.add(new DynamicVar(b.sym, b.val)));
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic((Var)v));
            if (expressions.isEmpty()) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            this.eval_ast(expressions.slice(0, expressions.size() - 1), env);
            VncVal vncVal = ((VncList)this.eval_ast(new VncList(expressions.last()), env)).first();
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_(VncList ast, Env env) {
        VncVal result = Constants.Nil;
        try {
            result = this.EVAL(ast.nth(1), env);
        }
        catch (Throwable th) {
            CatchBlock catchBlock = null;
            if (ast.size() > 2 && (catchBlock = this.findCatchBlockMatchingThrowable(ast.slice(2), th)) != null) {
                env.set(catchBlock.getExSym(), new VncJavaObject(th));
                VncVal blocks = this.eval_ast(catchBlock.getBody(), env);
                result = Coerce.toVncList(blocks).first();
            }
            if (catchBlock == null) {
                throw th;
            }
        }
        finally {
            VncList finallyBlock;
            if (ast.size() > 2 && (finallyBlock = this.findFirstFinallyBlock(ast.slice(2))) != null) {
                this.eval_ast(finallyBlock.slice(1), env);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_with_(VncList ast, Env env) {
        VncVal result;
        block13: {
            VncList bindings = Coerce.toVncList(ast.nth(1));
            ArrayList<Binding> boundResources = new ArrayList<Binding>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.EVAL(bindings.nth(i + 1), env);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getClassName(sym)));
                }
                env.set((VncSymbol)sym, val);
                boundResources.add(new Binding((VncSymbol)sym, val));
            }
            result = Constants.Nil;
            try {
                try {
                    VncList finallyBlock;
                    result = this.EVAL(ast.nth(2), env);
                    if (ast.size() <= 3 || (finallyBlock = this.findFirstFinallyBlock(ast.slice(3))) == null) break block13;
                    this.eval_ast(finallyBlock.slice(1), env);
                }
                catch (Throwable th) {
                    try {
                        CatchBlock catchBlock = null;
                        if (ast.size() > 3 && (catchBlock = this.findCatchBlockMatchingThrowable(ast.slice(3), th)) != null) {
                            env.set(catchBlock.getExSym(), new VncJavaObject(th));
                            VncVal blocks = this.eval_ast(catchBlock.getBody(), env);
                            result = Coerce.toVncList(blocks).first();
                        }
                        if (catchBlock == null) {
                            throw th;
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        VncList finallyBlock;
                        if (ast.size() > 3 && (finallyBlock = this.findFirstFinallyBlock(ast.slice(3))) != null) {
                            this.eval_ast(finallyBlock.slice(1), env);
                        }
                    }
                }
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    VncVal resource = b.val;
                    if (Types.isVncJavaObject(resource)) {
                        Object r = ((VncJavaObject)resource).getDelegate();
                        if (r instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                        if (r instanceof Closeable) {
                            try {
                                ((Closeable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        VncList block = blocks.stream().map(b -> (VncList)b).filter(b -> ((VncSymbol)b.first()).getName().equals("catch")).filter(b -> this.isCatchBlockMatchingThrowable((VncList)b, th)).findFirst().orElse(null);
        if (block != null) {
            VncSymbol sym = Coerce.toVncSymbol(block.nth(2));
            return new CatchBlock(sym, block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.nth(1)).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (int ii = 0; ii < blocks.size(); ++ii) {
            VncList block = Coerce.toVncList(blocks.nth(ii));
            VncSymbol sym = Coerce.toVncSymbol(block.nth(0));
            if (!sym.getName().equals("finally")) continue;
            return block;
        }
        return null;
    }

    private VncFunction buildFunction(String name, VncList params, final VncList body, final VncList preConditions, Env env) {
        return new VncFunction(name, body, env, params){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                Env localEnv = new Env(this.env);
                Destructuring.destructure(this.params, args).forEach(b -> localEnv.set(b.sym, b.val));
                VeniceInterpreter.this.validateFnPreconditions(this.name, preConditions, localEnv);
                if (body.isEmpty()) {
                    return Constants.Nil;
                }
                if (body.size() == 1) {
                    return VeniceInterpreter.this.EVAL(body.first(), localEnv);
                }
                VeniceInterpreter.this.eval_ast(body.slice(0, body.size() - 1), localEnv);
                return VeniceInterpreter.this.EVAL(body.last(), localEnv);
            }
        };
    }

    private String getFnName(VncVal name) {
        if (name == Constants.Nil) {
            return null;
        }
        return Types.isVncSymbol(name) ? ((VncSymbol)name).getName() : null;
    }

    private VncList getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncList(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncList)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncList(result) ? ((VncList)result).first() == Constants.True : result == Constants.True;
    }

    private void validateFnPreconditions(String fnName, VncList preConditions, Env env) {
        if (preConditions != null) {
            Env local = new Env(env);
            preConditions.forEach(v -> {
                if (!this.isFnConditionTrue(this.EVAL((VncVal)v, local))) {
                    ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(fnName, v));
                    throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(new VncList((VncVal)v))).getValue()));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal runWithCallStack(String fnName, VncList ast, Env env, BiFunction<VncList, Env, VncVal> fn) {
        try {
            ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(fnName, ast));
            VncVal vncVal = fn.apply(ast, env);
            return vncVal;
        }
        finally {
            ThreadLocalMap.getCallStack().pop();
        }
    }

    private String resolveClassName(String className) {
        return this.javaImports.resolveClassName(className);
    }
}

