/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class VncJavaMap
extends VncMap
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Map<Object, Object> value;

    public VncJavaMap(Map<Object, Object> map) {
        this.value = map;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncHashMap empty() {
        return new VncHashMap(new VncVal[0]);
    }

    @Override
    public Map<VncVal, VncVal> getMap() {
        return this.value.entrySet().stream().collect(Collectors.toMap(e -> JavaInteropUtil.convertToVncVal(e.getKey()), e -> JavaInteropUtil.convertToVncVal(e.getValue())));
    }

    @Override
    public VncVal get(VncVal key) {
        return JavaInteropUtil.convertToVncVal(this.value.get(JavaInteropUtil.convertToJavaObject(key)));
    }

    public VncMap toVncHashMap() {
        return new VncHashMap(this.getMap());
    }

    public VncMap toVncOrderedMap() {
        return new VncOrderedMap(this.getMap());
    }

    public VncMap toVncSortedMap() {
        return new VncSortedMap(this.getMap());
    }

    @Override
    public VncHashMap copy() {
        VncHashMap v = new VncHashMap(this.getMap());
        v.setMeta(this.getMeta());
        return v;
    }

    @Override
    public VncList keys() {
        return new VncList(this.value.keySet().stream().map(k -> JavaInteropUtil.convertToVncVal(k)).collect(Collectors.toList()));
    }

    @Override
    public Set<Map.Entry<VncVal, VncVal>> entries() {
        return this.getMap().entrySet();
    }

    @Override
    public VncMap putAll(VncMap map) {
        this.getMap().entrySet().forEach(e -> this.value.put(JavaInteropUtil.convertToJavaObject((VncVal)e.getKey()), JavaInteropUtil.convertToJavaObject((VncVal)e.getValue())));
        return this;
    }

    @Override
    public VncJavaMap assoc(VncVal ... mvs) {
        for (int i = 0; i < mvs.length; i += 2) {
            this.value.put(JavaInteropUtil.convertToJavaObject(mvs[i]), JavaInteropUtil.convertToJavaObject(mvs[i + 1]));
        }
        return this;
    }

    @Override
    public VncJavaMap assoc(VncList mvs) {
        for (int i = 0; i < mvs.getList().size(); i += 2) {
            this.value.put(JavaInteropUtil.convertToJavaObject(mvs.nth(i)), JavaInteropUtil.convertToJavaObject(mvs.nth(i)));
        }
        return this;
    }

    @Override
    public VncMap dissoc(VncVal ... keys) {
        for (VncVal key : keys) {
            this.value.remove(key);
        }
        return this;
    }

    @Override
    public VncJavaMap dissoc(VncList keys) {
        for (int i = 0; i < keys.getList().size(); ++i) {
            this.value.remove(JavaInteropUtil.convertToJavaObject(keys.nth(i)));
        }
        return this;
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value.entrySet().stream().map(e -> new VncVector(JavaInteropUtil.convertToVncVal(e.getKey()), JavaInteropUtil.convertToVncVal(e.getValue()))).collect(Collectors.toList()));
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value.entrySet().stream().map(e -> new VncVector(JavaInteropUtil.convertToVncVal(e.getKey()), JavaInteropUtil.convertToVncVal(e.getValue()))).collect(Collectors.toList()));
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaMap other = (VncJavaMap)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        this.value.entrySet().forEach(e -> {
            list.add(JavaInteropUtil.convertToVncVal(e.getKey()));
            list.add(JavaInteropUtil.convertToVncVal(e.getValue()));
        });
        return "{" + Printer.join(list, " ", print_readably) + "}";
    }
}

