/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class VncJavaSet
extends VncCollection
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Set<Object> value;

    public VncJavaSet(Set<Object> value) {
        this.value = value;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncSet empty() {
        return new VncSet();
    }

    public void add(VncVal val) {
        this.value.add(JavaInteropUtil.convertToVncVal(val));
    }

    public boolean contains(VncVal val) {
        return this.value.contains(JavaInteropUtil.convertToVncVal(val));
    }

    @Override
    public VncSet copy() {
        return new VncSet(this.toList());
    }

    public VncList toList() {
        return new VncList(this.getVncValueList());
    }

    public VncSet toVncSet() {
        return new VncSet(this.toList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.toList());
    }

    public VncVector toVncVector() {
        return new VncVector(this.toList());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaSet other = (VncJavaSet)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getVncValueList(), " ", print_readably) + "}";
    }

    private List<VncVal> getVncValueList() {
        return this.value.stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
    }
}

