/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.repackage.io.vavr.collection.HashSet;

public class VncSet
extends VncCollection {
    private static final long serialVersionUID = -1848883965231344442L;
    private final HashSet<VncVal> value;

    public VncSet() {
        this.value = HashSet.of(new VncVal[0]);
    }

    public VncSet(HashSet<VncVal> val) {
        this.value = val;
    }

    public VncSet(Set<VncVal> val) {
        this.value = HashSet.ofAll(val);
    }

    public VncSet(VncList val) {
        this.value = HashSet.ofAll(val.getList());
    }

    public VncSet(VncVal ... mvs) {
        this.value = HashSet.of(mvs);
    }

    @Override
    public VncSet empty() {
        return new VncSet();
    }

    public VncSet add(VncVal val) {
        return new VncSet((HashSet<VncVal>)this.value.add((Object)val));
    }

    public VncSet addAll(VncSet val) {
        return new VncSet((HashSet<VncVal>)this.value.addAll(val.value));
    }

    public VncSet addAll(VncList val) {
        return new VncSet((HashSet<VncVal>)this.value.addAll(val.getList()));
    }

    public VncSet remove(VncVal val) {
        return new VncSet((HashSet<VncVal>)this.value.remove((Object)val));
    }

    public VncSet removeAll(VncSet val) {
        return new VncSet((HashSet<VncVal>)this.value.removeAll(val.value));
    }

    public VncSet removeAll(VncList val) {
        return new VncSet((HashSet<VncVal>)this.value.removeAll(val.getList()));
    }

    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public VncSet copy() {
        VncSet s = new VncSet(this.value);
        s.setMeta(this.getMeta());
        return s;
    }

    public Set<VncVal> getSet() {
        return Collections.unmodifiableSet(this.value.toJavaSet());
    }

    public List<VncVal> getList() {
        return Collections.unmodifiableList(this.value.toJavaList());
    }

    public VncVector toVncVector() {
        return new VncVector(this.getList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSet other = (VncSet)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getList(), " ", print_readably) + "}";
    }
}

