/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.javainterop.CompiledSandboxRules;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.SandboxRules;
import com.github.jlangch.venice.javainterop.ValueFilterInterceptor;

public class SandboxInterceptor
extends ValueFilterInterceptor {
    private final CompiledSandboxRules sandboxRules;

    public SandboxInterceptor(SandboxRules rules) {
        this.sandboxRules = CompiledSandboxRules.compile(rules);
    }

    @Override
    public Object onInvokeInstanceMethod(IInvoker invoker, Object receiver, String method, Object ... args) throws SecurityException {
        this.validateAccessor(receiver, method);
        return super.onInvokeInstanceMethod(invoker, receiver, method, args);
    }

    @Override
    public Object onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        this.validateAccessor(receiver, method);
        return super.onInvokeStaticMethod(invoker, receiver, method, args);
    }

    @Override
    public Object onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        return super.onInvokeConstructor(invoker, receiver, args);
    }

    @Override
    public Object onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        this.validateAccessor(receiver, property);
        return super.onGetBeanProperty(invoker, receiver, property);
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        this.validateAccessor(receiver, property);
        super.onSetBeanProperty(invoker, receiver, property, value);
    }

    @Override
    public Object onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        this.validateAccessor(receiver, fieldName);
        return super.onGetStaticField(invoker, receiver, fieldName);
    }

    @Override
    public Object onGetInstanceField(IInvoker invoker, Object receiver, String fieldName) throws SecurityException {
        this.validateAccessor(receiver, fieldName);
        return super.onGetInstanceField(invoker, receiver, fieldName);
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        this.validateClasspathResource(resourceName);
        return super.onLoadClassPathResource(resourceName);
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        this.validateSystemProperty(propertyName);
        return super.onReadSystemProperty(propertyName);
    }

    @Override
    public void validateBlackListedVeniceFunction(String funcName) throws SecurityException {
        if (this.sandboxRules.isBlackListedVeniceFunction(funcName)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to function %s", funcName));
        }
    }

    @Override
    public Integer getMaxExecutionTimeSeconds() {
        return this.sandboxRules.getMaxExecTimeSeconds();
    }

    @Override
    protected Object filter(Object obj) {
        this.validateClass(obj);
        return obj;
    }

    @Override
    protected Object filterAccessor(Object o, String accessor) {
        this.validateAccessor(o, accessor);
        return o;
    }

    private void validateClass(Object obj) {
        Class<?> clazz;
        if (obj != null && !this.sandboxRules.isWhiteListed(clazz = this.getClass(obj))) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to class %s", clazz.getName()));
        }
    }

    private void validateAccessor(Object receiver, String accessor) {
        Class<?> clazz;
        if (receiver != null && !this.sandboxRules.isWhiteListed(clazz = this.getClass(receiver), accessor)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to accessor %s::%s", clazz.getName(), accessor));
        }
    }

    private void validateClasspathResource(String resourceName) {
        if (!StringUtil.isBlank(resourceName) && !this.sandboxRules.isWhiteListedClasspathResource(resourceName)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to classpath resource '%s'", resourceName));
        }
    }

    private void validateSystemProperty(String propertyName) {
        if (!StringUtil.isBlank(propertyName) && !this.sandboxRules.isWhiteListedSystemProperty(propertyName)) {
            throw new SecurityException(String.format("Venice Sandbox: Access denied to system property '%s'", propertyName));
        }
    }

    private Class<?> getClass(Object obj) {
        if (obj != null) {
            return obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        return null;
    }
}

