/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.jsr223;

import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.jsr223.VeniceBindings;
import com.github.jlangch.venice.jsr223.VeniceScriptEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class VeniceScriptEngineFactory
implements ScriptEngineFactory {
    private final ScriptEngine scriptEngine;
    private final Properties properties = new Properties();

    public VeniceScriptEngineFactory() {
        this.properties.setProperty("javax.script.name", this.getEngineName());
        this.properties.setProperty("javax.script.language", this.getLanguageName());
        this.properties.setProperty("javax.script.language_version", this.getLanguageVersion());
        this.scriptEngine = new VeniceScriptEngine(this, new VeniceBindings());
    }

    @Override
    public String getEngineName() {
        return "venice";
    }

    @Override
    public String getEngineVersion() {
        return Venice.getVersion();
    }

    @Override
    public List<String> getExtensions() {
        return new ArrayList<String>(ModuleLoader.VALID_MODULES);
    }

    @Override
    public List<String> getMimeTypes() {
        return Arrays.asList("application/venice");
    }

    @Override
    public List<String> getNames() {
        return Arrays.asList("venice");
    }

    @Override
    public String getLanguageName() {
        return "venice";
    }

    @Override
    public String getLanguageVersion() {
        return "1.0";
    }

    @Override
    public Object getParameter(String key) {
        if ("javax.script.engine".equals(key)) {
            return this.getScriptEngine();
        }
        return this.properties.getProperty(key);
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("(. ");
        sb.append(obj);
        sb.append(" :");
        sb.append(method);
        for (String arg : args) {
            sb.append(" ");
            sb.append(arg);
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "(println " + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        sb.append("(do \n");
        for (String statement : statements) {
            sb.append("    ");
            sb.append(statement);
            sb.append("\n");
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }
}

