/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.io.vavr.concurrent;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.repackage.io.vavr.concurrent.Future;
import org.repackage.io.vavr.concurrent.FutureImpl;
import org.repackage.io.vavr.concurrent.PromiseImpl;
import org.repackage.io.vavr.control.Try;

public interface Promise<T> {
    public static <T> Promise<T> failed(Throwable exception) {
        Objects.requireNonNull(exception, "exception is null");
        return Promise.failed(Future.DEFAULT_EXECUTOR_SERVICE, exception);
    }

    public static <T> Promise<T> failed(ExecutorService executorService, Throwable exception) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(exception, "exception is null");
        return Promise.make(executorService).failure(exception);
    }

    public static <T> Promise<T> fromTry(Try<? extends T> result) {
        return Promise.fromTry(Future.DEFAULT_EXECUTOR_SERVICE, result);
    }

    public static <T> Promise<T> fromTry(ExecutorService executorService, Try<? extends T> result) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(result, "result is null");
        return Promise.make(executorService).complete(result);
    }

    public static <T> Promise<T> make() {
        return Promise.make(Future.DEFAULT_EXECUTOR_SERVICE);
    }

    public static <T> Promise<T> make(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService is null");
        return new PromiseImpl(new FutureImpl(executorService));
    }

    public static <T> Promise<T> narrow(Promise<? extends T> promise) {
        return promise;
    }

    public static <T> Promise<T> successful(T result) {
        return Promise.successful(Future.DEFAULT_EXECUTOR_SERVICE, result);
    }

    public static <T> Promise<T> successful(ExecutorService executorService, T result) {
        Objects.requireNonNull(executorService, "executorService is null");
        return Promise.make(executorService).success(result);
    }

    public ExecutorService executorService();

    public Future<T> future();

    default public boolean isCompleted() {
        return this.future().isCompleted();
    }

    default public Promise<T> complete(Try<? extends T> value) {
        if (this.tryComplete(value)) {
            return this;
        }
        throw new IllegalStateException("Promise already completed.");
    }

    public boolean tryComplete(Try<? extends T> var1);

    default public Promise<T> completeWith(Future<? extends T> other) {
        return this.tryCompleteWith(other);
    }

    default public Promise<T> tryCompleteWith(Future<? extends T> other) {
        other.onComplete(this::tryComplete);
        return this;
    }

    default public Promise<T> success(T value) {
        return this.complete(Try.success(value));
    }

    default public boolean trySuccess(T value) {
        return this.tryComplete(Try.success(value));
    }

    default public Promise<T> failure(Throwable exception) {
        return this.complete(Try.failure(exception));
    }

    default public boolean tryFailure(Throwable exception) {
        return this.tryComplete(Try.failure(exception));
    }
}

