/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Env
implements Serializable {
    private static final long serialVersionUID = 9002640180394221858L;
    private final Env outer;
    private final int level;
    private final Map<VncSymbol, Var> coreGlobalSymbols;
    private final Map<VncSymbol, Var> globalSymbols;
    private final Map<VncSymbol, Var> localSymbols;

    public Env() {
        this((Env)null);
    }

    public Env(Env outer) {
        this.outer = outer;
        this.level = outer == null ? 0 : outer.level() + 1;
        this.coreGlobalSymbols = outer == null ? null : outer.coreGlobalSymbols;
        this.globalSymbols = outer == null ? new ConcurrentHashMap() : outer.globalSymbols;
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>();
    }

    private Env(Map<VncSymbol, Var> coreGlobalSymbols) {
        this.outer = null;
        this.level = 0;
        this.coreGlobalSymbols = coreGlobalSymbols;
        this.globalSymbols = new ConcurrentHashMap<VncSymbol, Var>();
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>();
    }

    public Env makeCoreOnlyGlobalEnv() {
        return new Env(this.globalSymbols);
    }

    public VncVal get(VncSymbol key) {
        VncVal val = this.getOrNull(key);
        if (val != null) {
            return val;
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal(key));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Symbol '%s' not found.", key.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public VncVal getOrNil(VncSymbol key) {
        VncVal val = this.getOrNull(key);
        return val == null ? Constants.Nil : val;
    }

    public VncVal getGlobalOrNil(VncSymbol key) {
        Var glob = this.getGlobalVar(key);
        return glob == null ? Constants.Nil : glob.getVal();
    }

    public VncVal getGlobalOrNull(VncSymbol key) {
        Var glob = this.getGlobalVar(key);
        return glob == null ? null : glob.getVal();
    }

    public Var getGlobalVarOrNull(VncSymbol key) {
        return this.getGlobalVar(key);
    }

    public int level() {
        return this.level;
    }

    public Env set(VncSymbol name, VncVal val) {
        Var v = this.getGlobalVar(name);
        if (v != null && !v.isOverwritable() && Types.isVncFunction(v.getVal())) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(name));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The global function '%s' must not be shadowed by a local var!", name));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        this.setLocalVar(name, new Var(name, val));
        return this;
    }

    public Env addAll(List<Binding> bindings) {
        for (Binding b : bindings) {
            this.set(b.sym, b.val);
        }
        return this;
    }

    public Env setGlobal(Var val) {
        Var v = this.getGlobalVar(val.getName());
        if (v != null && !v.isOverwritable()) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(val.getName()));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The existing global var '%s' must not be overwritten!", val.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        this.setGlobalVar(val.getName(), val);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Env pushGlobalDynamic(VncSymbol sym, VncVal val) {
        Var dv = this.getGlobalVar(sym);
        if (dv == null) {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
            return this;
        }
        if (dv instanceof DynamicVar) {
            ((DynamicVar)dv).pushVal(val);
            return this;
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("The var '%s' is not defined as dynamic", sym));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs == null) throw throwable3;
            if (throwable == null) {
                cs.close();
                throw throwable3;
            }
            try {
                cs.close();
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throwable.addSuppressed(throwable4);
                throw throwable3;
            }
        }
    }

    public VncVal popGlobalDynamic(VncSymbol sym) {
        Var dv = this.getGlobalVar(sym);
        if (dv != null) {
            if (dv instanceof DynamicVar) {
                return ((DynamicVar)dv).popVal();
            }
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The var '%s' is not defined as dynamic", sym.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return Constants.Nil;
    }

    public VncVal peekGlobalDynamic(VncSymbol sym) {
        Var dv = this.getGlobalVar(sym);
        if (dv != null) {
            if (dv instanceof DynamicVar) {
                return ((DynamicVar)dv).peekVal();
            }
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The var '%s' is not defined as dynamic", sym.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return Constants.Nil;
    }

    public boolean hasGlobalSymbol(VncSymbol key) {
        return this.hasGlobalVar(key);
    }

    public Env getLevelEnv(int level) {
        Env env = this;
        if (env.level == level) {
            return env;
        }
        while (env.outer != null) {
            env = env.outer;
            if (env.level != level) continue;
            return env;
        }
        throw new VncException(String.format("No env level %d", level));
    }

    public String toString() {
        return "level " + this.level + ":" + "\n   [local]\n" + this.toString(this.localSymbols, "      ", null) + "\n   [global]\n" + this.toString(this.getAllGlobalSymbols(), "      ", null);
    }

    public String localsToString() {
        return "level " + this.level + ":" + "\n   [local]\n" + this.toString(this.localSymbols, "      ", null);
    }

    public String globalsToString() {
        return "[global]\n" + this.toString(this.getAllGlobalSymbols(), "   ", null);
    }

    public String globalsToString(String regexFilter) {
        return "[global]\n" + this.toString(this.getAllGlobalSymbols(), "   ", regexFilter);
    }

    public Env setStdoutPrintStream(PrintStream ps) {
        VncJavaObject psVal = new VncJavaObject(ps != null ? ps : this.nullPrintStream());
        DynamicVar var = new DynamicVar(new VncSymbol("*out*"), psVal);
        this.setGlobal(var);
        var.pushVal(psVal);
        return this;
    }

    private String toString(Map<VncSymbol, Var> vars, String indent, String regexFilter) {
        return vars.values().stream().sorted((a, b) -> a.getName().getName().compareTo(b.getName().getName())).filter(v -> regexFilter == null ? true : v.getName().getName().matches(regexFilter)).map(v -> String.format("%s%s: %s", indent, v.getName().getName(), Printer.pr_str(v.getVal(), true))).collect(Collectors.joining("\n"));
    }

    private VncVal getOrNull(VncSymbol key) {
        Env e = this.findEnv(key);
        if (e == null) {
            Var glob = this.getGlobalVar(key);
            if (glob != null) {
                return glob.getVal();
            }
        } else {
            Var loc = e.getLocalVar(key);
            if (loc != null) {
                return loc.getVal();
            }
        }
        return null;
    }

    private Env findEnv(VncSymbol key) {
        if (this.hasLocalVar(key)) {
            return this;
        }
        if (this.outer != null) {
            return this.outer.findEnv(key);
        }
        return null;
    }

    private Var getGlobalVar(VncSymbol key) {
        Var v;
        if (this.coreGlobalSymbols != null && (v = this.coreGlobalSymbols.get(key)) != null) {
            return v;
        }
        return this.globalSymbols.get(key);
    }

    private void setGlobalVar(VncSymbol key, Var value) {
        this.globalSymbols.put(key, value);
    }

    private boolean hasGlobalVar(VncSymbol key) {
        if (this.coreGlobalSymbols != null && this.coreGlobalSymbols.containsKey(key)) {
            return true;
        }
        return this.globalSymbols.containsKey(key);
    }

    private Var getLocalVar(VncSymbol key) {
        return this.localSymbols.get(key);
    }

    private void setLocalVar(VncSymbol key, Var value) {
        this.localSymbols.put(key, value);
    }

    private boolean hasLocalVar(VncSymbol key) {
        return this.localSymbols.containsKey(key);
    }

    private Map<VncSymbol, Var> getAllGlobalSymbols() {
        HashMap<VncSymbol, Var> all = new HashMap<VncSymbol, Var>();
        if (this.coreGlobalSymbols != null) {
            all.putAll(this.coreGlobalSymbols);
        }
        all.putAll(this.globalSymbols);
        return all;
    }

    public List<VncSymbol> getAllGlobalFunctionSymbols() {
        return this.getAllGlobalSymbols().entrySet().stream().filter(e -> ((Var)e.getValue()).getVal() instanceof VncFunction).map(e -> {
            VncFunction fn = (VncFunction)((Var)e.getValue()).getVal();
            return ((VncSymbol)e.getKey()).withMeta(VncHashMap.of(new VncKeyword("group"), new VncString(fn.getModule()), new VncKeyword("arglists"), fn.getArgLists(), new VncKeyword("doc"), fn.getDoc()));
        }).collect(Collectors.toList());
    }

    private PrintStream nullPrintStream() {
        return new PrintStream(new NullOutputStream(), true);
    }
}

