/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.Token;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.HashMap;

public class MetaUtil {
    public static final VncKeyword ARGLIST = new VncKeyword(":arglists");
    public static final VncKeyword DOC = new VncKeyword(":doc");
    public static final VncKeyword EXAMPLES = new VncKeyword(":examples");
    public static final VncKeyword FILE = new VncKeyword(":file");
    public static final VncKeyword LINE = new VncKeyword(":line");
    public static final VncKeyword COLUMN = new VncKeyword(":column");
    public static final VncKeyword MODULE = new VncKeyword(":module");
    public static final VncKeyword PRIVATE = new VncKeyword(":private");

    public static VncVal addDefMeta(VncVal val, VncMap meta) {
        VncVal valMeta = val.getMeta();
        if (valMeta == Constants.Nil) {
            valMeta = meta;
        } else if (Types.isVncMap(valMeta)) {
            valMeta = ((VncMap)valMeta).assoc(meta.toVncList());
        }
        return val.withMeta(valMeta);
    }

    public static VncVal toMeta(Token token) {
        return VncHashMap.of(MODULE, new VncString(Modules.fileNameToModule(token.getFile())), FILE, new VncString(token.getFile()), LINE, new VncLong(token.getLine()), COLUMN, new VncLong(token.getColumn()));
    }

    public static VncVal addMetaVal(VncVal meta, VncString key, VncVal val) {
        if (meta == Constants.Nil) {
            return new VncHashMap().assoc(key, val);
        }
        if (Types.isVncMap(meta)) {
            return ((VncMap)meta).assoc(key, val);
        }
        return meta;
    }

    public static VncVal mergeMeta(VncVal meta1, VncVal meta2) {
        if (meta1 == Constants.Nil) {
            return meta2;
        }
        if (meta2 == Constants.Nil) {
            return meta1;
        }
        if (Types.isVncMap(meta1) && Types.isVncMap(meta2)) {
            HashMap<VncVal, VncVal> m = new HashMap<VncVal, VncVal>(((VncMap)meta1).getMap());
            m.putAll(((VncMap)meta2).getMap());
            return new VncHashMap(m);
        }
        throw new VncException(String.format("Failed to merge meta data on incompatible old (%s) and new (%s) meta data types", Types.getType(meta1), Types.getType(meta2)));
    }

    public static boolean isPrivate(VncVal meta) {
        if (meta == Constants.Nil) {
            return false;
        }
        if (meta instanceof VncHashMap) {
            return ((VncHashMap)meta).get(PRIVATE) == Constants.True;
        }
        return false;
    }

    public static String getModule(VncVal meta) {
        if (meta == Constants.Nil) {
            return null;
        }
        if (meta instanceof VncHashMap) {
            VncVal file = ((VncHashMap)meta).get(MODULE);
            return file == Constants.Nil ? null : ((VncString)file).getValue();
        }
        return null;
    }
}

