/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleLoader {
    private static final Map<String, String> modules = new HashMap<String, String>();
    public static final Set<String> VALID_MODULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("core", "http", "jackson", "logger", "math", "webdav", "xchart", "test", "tomcat", "ring", "maven", "kira", "xml", "crypt")));

    public static String load(String module) {
        if (!VALID_MODULES.contains(module)) {
            throw new VncException(String.format("The Venice core module '%s' does not exist", module));
        }
        String name = module + ".venice";
        try {
            return modules.computeIfAbsent(name, k -> new ClassPathResource(VeniceClasspath.getVeniceBasePath() + k).getResourceAsString("UTF-8"));
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice core module '%s'", name), ex);
        }
    }

    public static boolean loaded(String module) {
        return modules.containsKey(module);
    }

    public static String loadVeniceResource(String resource) {
        if (!resource.endsWith(".venice")) {
            throw new VncException(String.format("Must not load other than Venice (*.venice) resources from classpath. Resource: '%s'", new Object[0]));
        }
        try {
            return modules.computeIfAbsent(resource, k -> new ClassPathResource(resource).getResourceAsString("UTF-8"));
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice resource '%s'", resource), ex);
        }
    }
}

