/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Modules {
    private static final Set<String> reserved = new HashSet<String>(Arrays.asList("core", "time", "str", "io", "shell", "system", "venice"));

    public static boolean isReserved(String moduleName) {
        return moduleName != null && reserved.contains(moduleName);
    }

    public static void validateReservedModuleName(String moduleName) {
        if (Modules.isReserved(moduleName)) {
            throw new VncException(String.format("Reserved module name '%s'", moduleName));
        }
    }

    public static void validateFileName(String fileName) {
        Modules.validateReservedModuleName(Modules.fileNameToModule(fileName));
    }

    public static String fileNameToModule(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName == "unknown") {
            return "user";
        }
        return fileName.endsWith(".venice") ? fileName.substring(0, fileName.length() - 7) : fileName;
    }
}

