/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncSymbol;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ReservedSymbols {
    private static final Set<String> reserved = new HashSet<String>(Arrays.asList("def", "defonce", "def-dynamic", "doc", "eval", "let", "binding", "loop", "recur", "quote", "quasiquote", "defmacro", "macroexpand", "try", "try-with", "import", "do", "if", "fn", "prof", "perf", "resolve", "defmulti", "defmethod", "deftype", "defrecord", ".", "proxify", "*version*", "*newline*"));

    public static boolean isReserved(VncSymbol symbol) {
        return symbol != null && reserved.contains(symbol.getName());
    }

    public static void validate(VncSymbol symbol) {
        if (symbol != null && reserved.contains(symbol.getName())) {
            throw new VncException(String.format("Reserved symbol '%s'", symbol.getName()));
        }
    }
}

