/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.ReservedSymbols;
import com.github.jlangch.venice.impl.SpecialForms;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInteropFn;
import com.github.jlangch.venice.impl.javainterop.JavaInteropProxifyFn;
import com.github.jlangch.venice.impl.javainterop.SandboxMaxExecutionTimeChecker;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.CatchBlock;
import com.github.jlangch.venice.impl.util.Doc;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private final JavaImports javaImports = new JavaImports();
    private final IInterceptor interceptor;
    private final SandboxMaxExecutionTimeChecker sandboxMaxExecutionTimeChecker = new SandboxMaxExecutionTimeChecker();
    private final MeterRegistry meterRegistry;

    public VeniceInterpreter() {
        this(new MeterRegistry(false), new AcceptAllInterceptor());
    }

    public VeniceInterpreter(IInterceptor interceptor) {
        this(new MeterRegistry(false), interceptor);
    }

    public VeniceInterpreter(MeterRegistry perfmeter, IInterceptor interceptor) {
        this.meterRegistry = perfmeter;
        this.interceptor = interceptor;
    }

    public VncVal READ(String script, String filename) {
        long nanos = System.nanoTime();
        VncVal val = Reader.read_str(script, filename);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
        }
        return val;
    }

    public VncVal EVAL(VncVal ast, Env env) {
        long nanos = System.nanoTime();
        VncVal val = this.evaluate(ast, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
        }
        return val;
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public VncVal RE(String script, String filename, Env env) {
        VncVal ast = this.READ(script, filename);
        VncVal result = this.EVAL(ast, env);
        return result;
    }

    public Env createEnv() {
        return this.createEnv(null);
    }

    public Env createEnv(List<String> preloadedExtensionModules) {
        Env env = new Env(null);
        Functions.functions.keySet().forEach(key -> env.setGlobal(new Var((VncSymbol)key, Functions.functions.get(key), true)));
        env.setGlobal(new Var(new VncSymbol("."), JavaInteropFn.create(this.javaImports), false));
        env.setGlobal(new Var(new VncSymbol("proxify"), new JavaInteropProxifyFn(this.javaImports), false));
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString("1.5.11"), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        ArrayList<String> modules = new ArrayList<String>();
        modules.add("core");
        modules.addAll(VeniceInterpreter.toEmpty(preloadedExtensionModules));
        modules.forEach(m -> {
            long nanos = System.nanoTime();
            this.RE("(eval " + ModuleLoader.load(m) + ")", (String)m, env);
            this.meterRegistry.record("venice.module." + m + ".load", System.nanoTime() - nanos);
        });
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(ModuleLoader.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson", "logger"));
        Collections.sort(modules);
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal evaluate(VncVal orig_ast, Env env) {
        VncVal a0;
        VncList ast;
        RecursionPoint recursionPoint = null;
        block126: while (true) {
            String a0sym;
            if (!Types.isVncList(orig_ast)) {
                return this.eval_ast(orig_ast, env);
            }
            VncVal expanded = this.macroexpand(orig_ast, env);
            if (!Types.isVncList(expanded)) {
                return this.eval_ast(expanded, env);
            }
            ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            switch (a0sym = Types.isVncSymbol(a0) ? ((VncSymbol)a0).getName() : "__<*fn*>__") {
                case "do": {
                    if (ast.size() < 2) {
                        orig_ast = Constants.Nil;
                        continue block126;
                    }
                    VncList head_exprs = ast.slice(1, ast.size() - 1);
                    this.eval_ast(head_exprs, env);
                    orig_ast = ast.last();
                    continue block126;
                }
                case "def": {
                    VncSymbol defName = Coerce.toVncSymbol(ast.second());
                    defName = defName.withMeta(this.evaluate(defName.getMeta(), env));
                    ReservedSymbols.validate(defName);
                    Serializable defVal = ast.third();
                    VncVal res22 = this.evaluate((VncVal)defVal, env).withMeta(defName.getMeta());
                    env.setGlobal(new Var(defName, res22, true));
                    return res22;
                }
                case "defonce": {
                    VncSymbol defName = Coerce.toVncSymbol(ast.second());
                    defName = defName.withMeta(this.evaluate(defName.getMeta(), env));
                    ReservedSymbols.validate(defName);
                    Serializable defVal = ast.third();
                    VncVal res22 = this.evaluate((VncVal)defVal, env).withMeta(defName.getMeta());
                    env.setGlobal(new Var(defName, res22, false));
                    return res22;
                }
                case "defmulti": {
                    VncSymbol multiFnName = Coerce.toVncSymbol(ast.second());
                    multiFnName = multiFnName.withMeta(this.evaluate(multiFnName.getMeta(), env));
                    ReservedSymbols.validate(multiFnName);
                    VncFunction dispatchFn = this.fn_(Coerce.toVncList(ast.third()), env);
                    VncMultiFunction multiFn = new VncMultiFunction(multiFnName.getName(), dispatchFn);
                    env.setGlobal(new Var(multiFnName, multiFn, false));
                    return multiFn;
                }
                case "defmethod": {
                    WithCallStack cs;
                    VncSymbol multiFnName = Coerce.toVncSymbol(ast.nth(1));
                    VncVal multiFnVal = env.getGlobalOrNull(multiFnName);
                    if (multiFnVal == null) {
                        cs = new WithCallStack(CallFrame.fromVal(ast));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (cs != null) {
                                if (throwable != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    VncMultiFunction multiFn = Coerce.toVncMultiFunction(multiFnVal);
                    VncVal dispatchVal = ast.nth(2);
                    VncVector params = Coerce.toVncVector(ast.nth(3));
                    if (params.size() != multiFn.getParams().size()) {
                        WithCallStack cs2 = new WithCallStack(CallFrame.fromVal(ast));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), multiFn.getParams().size()));
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (cs2 != null) {
                                if (throwable != null) {
                                    try {
                                        cs2.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    cs2.close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                    VncVector preConditions = this.getFnPreconditions(ast.nth(4));
                    VncList body = ast.slice(preConditions == null ? 4 : 5);
                    VncFunction fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, env);
                    return multiFn.addFn(dispatchVal, fn);
                }
                case "def-dynamic": {
                    VncSymbol defName = Coerce.toVncSymbol(ast.second());
                    defName = defName.withMeta(this.evaluate(defName.getMeta(), env));
                    ReservedSymbols.validate(defName);
                    Serializable defVal = ast.third();
                    VncVal res22 = this.evaluate((VncVal)defVal, env).withMeta(defName.getMeta());
                    env.setGlobal(new DynamicVar(defName, res22));
                    return res22;
                }
                case "resolve": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case "defmacro": {
                    VncVal res22;
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal("defmacro", ast));
                    Serializable defVal = null;
                    try {
                        res22 = this.defmacro_(ast, env);
                        return res22;
                    }
                    catch (Throwable res22) {
                        defVal = res22;
                        throw res22;
                    }
                    finally {
                        if (cs != null) {
                            if (defVal != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    ((Throwable)defVal).addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case "macroexpand": {
                    VncVal res22;
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal("macroexpand", ast));
                    Serializable defVal = null;
                    try {
                        res22 = this.macroexpand(ast.second(), env);
                        return res22;
                    }
                    catch (Throwable res22) {
                        defVal = res22;
                        throw res22;
                    }
                    finally {
                        if (cs != null) {
                            if (defVal != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    ((Throwable)defVal).addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case "quote": {
                    return ast.second();
                }
                case "quasiquote": {
                    orig_ast = VeniceInterpreter.quasiquote(ast.second());
                    continue block126;
                }
                case "doc": {
                    String name = ((VncString)CoreFunctions.name.apply(ast.rest())).getValue();
                    VncVal docVal = SpecialForms.ns.get(new VncSymbol(name));
                    if (docVal == null) {
                        docVal = env.get(new VncSymbol(name));
                    }
                    orig_ast = VncList.of(new VncSymbol("println"), Doc.getDoc(docVal));
                    continue block126;
                }
                case "eval": {
                    orig_ast = Coerce.toVncSequence(this.eval_ast(ast.rest(), env)).last();
                    continue block126;
                }
                case "let": {
                    env = new Env(env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    VncVal expressions = ast.slice(2);
                    for (int i2 = 0; i2 < bindings.size(); i2 += 2) {
                        VncVal sym = bindings.nth(i2);
                        VncVal val = this.evaluate(bindings.nth(i2 + 1), env);
                        for (Binding b : Destructuring.destructure(sym, val)) {
                            env.set(b.sym, b.val);
                        }
                    }
                    if (((VncList)expressions).isEmpty()) {
                        orig_ast = Constants.Nil;
                        continue block126;
                    }
                    this.eval_ast(((VncList)expressions).slice(0, ((VncList)expressions).size() - 1), env);
                    orig_ast = ((VncList)expressions).last();
                    continue block126;
                }
                case "binding": {
                    return this.binding_(ast, new Env(env));
                }
                case "loop": {
                    env = new Env(env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    VncVal expressions = ast.nth(2);
                    ArrayList<VncSymbol> bindingNames = new ArrayList<VncSymbol>();
                    for (int i3 = 0; i3 < bindings.size(); i3 += 2) {
                        VncVal sym = bindings.nth(i3);
                        VncVal val = this.evaluate(bindings.nth(i3 + 1), env);
                        env.set((VncSymbol)sym, val);
                        bindingNames.add((VncSymbol)sym);
                    }
                    recursionPoint = new RecursionPoint(bindingNames, expressions, env);
                    orig_ast = expressions;
                    continue block126;
                }
                case "recur": {
                    List<VncSymbol> bindingNames = recursionPoint.getLoopBindingNames();
                    Env recur_env = recursionPoint.getLoopEnv();
                    if (ast.size() == 2) {
                        recur_env.set(bindingNames.get(0), this.evaluate(ast.second(), env));
                    } else if (ast.size() == 3) {
                        VncVal v1 = this.evaluate(ast.second(), env);
                        VncVal v2 = this.evaluate(ast.third(), env);
                        recur_env.set(bindingNames.get(0), v1);
                        recur_env.set(bindingNames.get(1), v2);
                    } else {
                        VncList values = ast.rest();
                        VncVal[] newValues = new VncVal[values.size()];
                        int kk = 0;
                        for (VncVal v : values.getList()) {
                            newValues[kk++] = this.evaluate(v, env);
                        }
                        for (int ii = 0; ii < bindingNames.size(); ++ii) {
                            recur_env.set(bindingNames.get(ii), newValues[ii]);
                        }
                    }
                    orig_ast = recursionPoint.getLoopExpressions();
                    env = recur_env;
                    continue block126;
                }
                case "set!": {
                    VncSymbol sym = Coerce.toVncSymbol(ast.second());
                    sym = sym.withMeta(this.evaluate(sym.getMeta(), env));
                    Serializable globVar = env.getGlobalVarOrNull(sym);
                    if (globVar != null) {
                        VncVal expr = ast.third();
                        VncVal res = this.evaluate(expr, env).withMeta(sym.getMeta());
                        if (globVar instanceof DynamicVar) {
                            env.popGlobalDynamic(sym);
                            env.pushGlobalDynamic(sym, res);
                        } else {
                            env.setGlobal(new Var(sym, res));
                        }
                        return res;
                    }
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
                    Throwable res = null;
                    try {
                        try {
                            throw new VncException(String.format("The global var or thread-local '%s' does not exist!", sym.getName()));
                        }
                        catch (Throwable kk) {
                            res = kk;
                            throw kk;
                        }
                    }
                    catch (Throwable throwable) {
                        if (cs != null) {
                            if (res != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable8) {
                                    res.addSuppressed(throwable8);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw throwable;
                    }
                }
                case "try": {
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal("try", ast));
                    Serializable globVar = null;
                    try {
                        VncVal vncVal = this.try_(ast, new Env(env));
                        return vncVal;
                    }
                    catch (Throwable throwable) {
                        globVar = throwable;
                        throw throwable;
                    }
                    finally {
                        if (cs != null) {
                            if (globVar != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable res) {
                                    ((Throwable)globVar).addSuppressed(res);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case "try-with": {
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal("try-with", ast));
                    Serializable globVar = null;
                    try {
                        VncVal vncVal = this.try_with_(ast, new Env(env));
                        return vncVal;
                    }
                    catch (Throwable throwable) {
                        globVar = throwable;
                        throw throwable;
                    }
                    finally {
                        if (cs != null) {
                            if (globVar != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable res) {
                                    ((Throwable)globVar).addSuppressed(res);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case "import": {
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal("import", ast));
                    Serializable globVar = null;
                    try {
                        ast.rest().forEach(i -> this.javaImports.add(Coerce.toVncString(i).getValue()));
                        VncConstant vncConstant = Constants.Nil;
                        return vncConstant;
                    }
                    catch (Throwable throwable) {
                        globVar = throwable;
                        throw throwable;
                    }
                    finally {
                        if (cs != null) {
                            if (globVar != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable res) {
                                    ((Throwable)globVar).addSuppressed(res);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case "dorun": {
                    return this.dorun_(ast, env);
                }
                case "if": {
                    VncVal cond = this.evaluate(ast.second(), env);
                    if (cond == Constants.False || cond == Constants.Nil) {
                        if (ast.size() > 3) {
                            orig_ast = ast.nth(3);
                            continue block126;
                        }
                        return Constants.Nil;
                    }
                    orig_ast = ast.nth(2);
                    continue block126;
                }
                case "fn": {
                    return this.fn_(ast, env);
                }
                case "prof": {
                    return this.prof_(ast, env);
                }
            }
            break;
        }
        long nanos = System.nanoTime();
        VncList el = (VncList)this.eval_ast(ast, env);
        VncVal elFirst = el.first();
        if (Types.isVncFunction(elFirst)) {
            VncFunction fn = (VncFunction)elFirst;
            this.interceptor.validateVeniceFunction(fn.getName());
            CallStack callStack = ThreadLocalMap.getCallStack();
            if (fn.isPrivate()) {
                this.validatePrivateFnCall(fn, a0, callStack);
            }
            this.sandboxMaxExecutionTimeChecker.check();
            this.checkInterrupted();
            try {
                callStack.push(CallFrame.fromFunction(fn, a0));
                VncVal val = (VncVal)fn.apply(el.rest());
                if (this.meterRegistry.enabled) {
                    this.meterRegistry.record(fn.getName(), System.nanoTime() - nanos);
                }
                VncVal vncVal = val;
                return vncVal;
            }
            finally {
                callStack.pop();
                this.checkInterrupted();
                this.sandboxMaxExecutionTimeChecker.check();
            }
        }
        if (Types.isIVncFunction(elFirst)) {
            return (VncVal)((IVncFunction)((Object)elFirst)).apply(el.rest());
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal(ast));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Not a function or keyword/map used as function: '%s'", this.PRINT(elFirst)));
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
        }
        catch (Throwable throwable10) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable10;
        }
    }

    private VncVal eval_ast(VncVal ast, Env env) {
        if (Types.isVncSymbol(ast)) {
            return env.get((VncSymbol)ast);
        }
        if (Types.isVncSequence(ast)) {
            VncSequence seq = (VncSequence)ast;
            switch (seq.size()) {
                case 0: {
                    return seq;
                }
                case 1: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env));
                }
                case 2: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
                }
            }
            ArrayList<VncVal> vals = new ArrayList<VncVal>();
            for (VncVal v : seq.getList()) {
                vals.add(this.evaluate(v, env));
            }
            return seq.withValues(vals);
        }
        if (Types.isVncMap(ast)) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>();
            for (Map.Entry<VncVal, VncVal> e : map.getMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
            }
            return map.withValues(vals);
        }
        return ast;
    }

    private VncVal macroexpand(VncVal ast, Env env) {
        VncVal fn;
        VncVal a0;
        long nanos = System.nanoTime();
        VncVal ast_ = ast;
        boolean expanded = false;
        while (Types.isVncList(ast_) && Types.isVncSymbol(a0 = ((VncList)ast_).first()) && Types.isVncMacro(fn = env.getGlobalOrNull((VncSymbol)a0))) {
            this.interceptor.validateVeniceFunction(((VncFunction)fn).getName());
            expanded = true;
            ast_ = (VncVal)((VncFunction)fn).apply(((VncList)ast_).rest());
        }
        if (expanded && this.meterRegistry.enabled) {
            this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
        }
        return ast_;
    }

    private static boolean is_pair(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        VncVal a00;
        if (!VeniceInterpreter.is_pair(ast)) {
            return VncList.of(new VncSymbol("quote"), ast);
        }
        VncVal a0 = Coerce.toVncSequence(ast).first();
        if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
            return ((VncSequence)ast).second();
        }
        if (VeniceInterpreter.is_pair(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
            return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        String sMacroName;
        int argPos = 1;
        VncVal macroName = ast.nth(argPos++);
        macroName = macroName.withMeta(this.evaluate(macroName.getMeta(), env));
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        String string = sMacroName = Types.isVncSymbol(macroName) ? ((VncSymbol)macroName).getName() : ((VncString)macroName).getValue();
        if (Types.isVncVector(paramsOrSig)) {
            VncVector macroParams = (VncVector)paramsOrSig;
            int n = ++argPos;
            ++argPos;
            VncVal body = ast.nth(n);
            VncFunction macroFn = this.buildFunction(sMacroName, macroParams, VncList.of(body), null, env);
            macroFn.setMacro();
            env.setGlobal(new Var((VncSymbol)macroName, macroFn.withMeta(macroName.getMeta()), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(sMacroName, params, body, null, env));
        });
        VncMultiArityFunction macro = new VncMultiArityFunction(sMacroName, fns).withMeta(macroName.getMeta());
        macro.setMacro();
        env.setGlobal(new Var((VncSymbol)macroName, macro, false));
        return macro;
    }

    private VncVal dorun_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dorun", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dorun requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        long count = Coerce.toVncLong(ast.second()).getValue();
        VncList expr = VncList.of(ast.third());
        int ii = 0;
        while ((long)ii < count - 1L) {
            this.eval_ast(expr, env);
            ++ii;
        }
        return ((VncList)this.eval_ast(expr, env)).first();
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncSequence paramsOrSig;
        String name;
        int argPos = 1;
        VncSymbol sName = this.getFnName(ast.nth(argPos));
        ReservedSymbols.validate(sName);
        String string = name = sName == null ? null : sName.getName();
        if (name != null) {
            ++argPos;
        }
        if (Types.isVncVector(paramsOrSig = Coerce.toVncSequence(ast.nth(argPos)))) {
            VncVector preConditions;
            VncVector params = (VncVector)paramsOrSig;
            if ((preConditions = this.getFnPreconditions(ast.nth(++argPos))) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(name, params, body, preConditions, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncVector preConditions = this.getFnPreconditions(sig.nth(pos));
            if (preConditions != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(name, params, body, preConditions, env));
        });
        return new VncMultiArityFunction(name, fns);
    }

    private VncVal prof_(VncList ast, Env env) {
        if (Types.isVncKeyword(ast.second())) {
            VncKeyword cmd = (VncKeyword)ast.second();
            switch (cmd.getValue()) {
                case "on": 
                case "enable": {
                    this.meterRegistry.enable();
                    return new VncKeyword("on");
                }
                case "off": 
                case "disable": {
                    this.meterRegistry.disable();
                    return new VncKeyword("off");
                }
                case "status": {
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear": {
                    this.meterRegistry.reset();
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear-all-but": {
                    this.meterRegistry.resetAllBut(Coerce.toVncSequence(ast.third()));
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "data": {
                    return this.meterRegistry.getVncTimerData();
                }
                case "data-formatted": {
                    String title = ast.size() == 3 ? Coerce.toVncString(ast.third()).getValue() : "Metrics";
                    return new VncString(this.meterRegistry.getTimerDataFormatted(title));
                }
            }
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal("prof", ast));
        Object object = null;
        try {
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (cs != null) {
                if (object != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncSequence bindings = Coerce.toVncSequence(ast.second());
        VncList expressions = ast.slice(2);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            for (Binding b : Destructuring.destructure(sym, val)) {
                vars.add(new Var(b.sym, b.val));
            }
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            if (expressions.isEmpty()) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            this.eval_ast(expressions.slice(0, expressions.size() - 1), env);
            VncVal vncVal = ((VncList)this.eval_ast(VncList.of(expressions.last()), env)).first();
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_(VncList ast, Env env) {
        VncVal result = Constants.Nil;
        try {
            result = this.evaluateBody(this.getTryBody(ast), env);
        }
        catch (Throwable th) {
            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
            if (catchBlock == null) {
                throw th;
            }
            env.set(catchBlock.getExSym(), new VncJavaObject(th));
            VncVal vncVal = this.evaluateBody(catchBlock.getBody(), env);
            return vncVal;
        }
        finally {
            VncList finallyBlock = this.findFirstFinallyBlock(ast);
            if (finallyBlock != null) {
                this.eval_ast(finallyBlock.rest(), env);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_with_(VncList ast, Env env) {
        VncVal result;
        block12: {
            VncSequence bindings = Coerce.toVncSequence(ast.second());
            ArrayList<Binding> boundResources = new ArrayList<Binding>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluate(bindings.nth(i + 1), env);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                }
                env.set((VncSymbol)sym, val);
                boundResources.add(new Binding((VncSymbol)sym, val));
            }
            result = Constants.Nil;
            try {
                try {
                    result = this.evaluateBody(this.getTryBody(ast), env);
                    VncList finallyBlock = this.findFirstFinallyBlock(ast);
                    if (finallyBlock == null) break block12;
                    this.eval_ast(finallyBlock.rest(), env);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block13: {
                        try {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.set(catchBlock.getExSym(), new VncJavaObject(th));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env);
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock == null) break block13;
                            this.eval_ast(finallyBlock.rest(), env);
                        }
                        catch (Throwable throwable) {
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock != null) {
                                this.eval_ast(finallyBlock.rest(), env);
                            }
                            throw throwable;
                        }
                    }
                    Collections.reverse(boundResources);
                    boundResources.stream().forEach(b -> {
                        VncVal resource = b.val;
                        if (Types.isVncJavaObject(resource)) {
                            Object r = ((VncJavaObject)resource).getDelegate();
                            if (r instanceof AutoCloseable) {
                                try {
                                    ((AutoCloseable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                            if (r instanceof Closeable) {
                                try {
                                    ((Closeable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                        }
                    });
                    return vncVal;
                }
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    VncVal resource = b.val;
                    if (Types.isVncJavaObject(resource)) {
                        Object r = ((VncJavaObject)resource).getDelegate();
                        if (r instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                        if (r instanceof Closeable) {
                            try {
                                ((Closeable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    private VncList getTryBody(VncList ast) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = ast.rest().getList().iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return new VncList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block;
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, final Env env) {
        return new VncFunction(name, body, env, params){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                Env localEnv = new Env(env);
                localEnv.addAll(Destructuring.destructure(params, args));
                VeniceInterpreter.this.validateFnPreconditions(name, preConditions, localEnv);
                return VeniceInterpreter.this.evaluateBody(body, localEnv);
            }
        };
    }

    private VncSymbol getFnName(VncVal name) {
        return name == Constants.Nil ? null : (Types.isVncSymbol(name) ? (VncSymbol)name : null);
    }

    private VncVector getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? ((VncSequence)result).first() == Constants.True : result == Constants.True;
    }

    private void validateFnPreconditions(String fnName, VncVector preConditions, Env env) {
        if (preConditions != null && !preConditions.isEmpty()) {
            Env local = new Env(env);
            for (VncVal v : preConditions.getList()) {
                if (this.isFnConditionTrue(this.evaluate(v, local))) continue;
                WithCallStack cs = new WithCallStack(CallFrame.fromVal(fnName, v));
                Throwable throwable = null;
                try {
                    try {
                        throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncList.of(v))).getValue()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private VncVal evaluateBody(VncList body, Env env) {
        if (body.isEmpty()) {
            return Constants.Nil;
        }
        if (body.size() == 1) {
            return this.evaluate(body.first(), env);
        }
        if (body.size() == 2) {
            this.evaluate(body.first(), env);
            return this.evaluate(body.last(), env);
        }
        this.eval_ast(body.slice(0, body.size() - 1), env);
        return this.evaluate(body.last(), env);
    }

    private void validatePrivateFnCall(VncFunction fn, VncVal fnAst, CallStack callStack) {
        String callerModule = callStack.peekModule();
        if (callerModule == null || !callerModule.equals(fn.getModule())) {
            CallFrame callFrame = callStack.peek();
            String callerFnName = callFrame == null ? null : callFrame.getFnName();
            WithCallStack cs = new WithCallStack(CallFrame.fromFunction(fn, fnAst));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Illegal call of private function %s (module %s). Called by %s (module %s).\n%s", fn.getName(), fn.getModule(), callerFnName, callerModule, callStack.toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    private String resolveClassName(String className) {
        return this.javaImports.resolveClassName(className);
    }

    private void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("interrupted");
        }
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }
}

