/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.Readline;
import com.github.jlangch.venice.impl.ValueException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncTunnelAsJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncSortedSet;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.StreamUtil;
import com.github.jlangch.venice.impl.util.WithCallStack;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class CoreFunctions {
    public static VncFunction throw_ex = new VncFunction("throw", VncFunction.meta().module("core").arglists("(throw)", "(throw x)").doc("Throws exception with passed value x").examples("(do                                                     \n   (try                                                 \n     (+ 100 200)                                        \n     (catch :Exception ex (:message ex))))                ", "(do                                                     \n   (try                                                 \n     (throw 100)                                        \n     (catch :ValueException ex (:value ex))))             ", "(do                                                     \n   (try                                                 \n      (throw [100 {:a 3}])                              \n      (catch :ValueException ex (:value ex))            \n      (finally (println \"#finally\"))))                  ", "(do                                                     \n   (import :java.lang.RuntimeException)                 \n   (try                                                 \n      (throw (. :RuntimeException :new \"#test\"))      \n      (catch :RuntimeException ex (:message ex))))        ", ";; Venice wraps thrown checked exceptions with a RuntimeException! \n(do                                                                \n   (import :java.lang.RuntimeException)                            \n   (import :java.io.IOException)                                   \n   (try                                                            \n      (throw (. :IOException :new \"#test\"))                      \n      (catch :RuntimeException ex (:message (:cause ex)))))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ValueException("throw", Constants.Nil);
            }
            if (Types.isVncJavaObject(args.first())) {
                Object obj = ((VncJavaObject)args.first()).getDelegate();
                if (obj instanceof RuntimeException) {
                    throw (RuntimeException)obj;
                }
                if (obj instanceof Exception) {
                    throw new RuntimeException((Exception)obj);
                }
                throw new RuntimeException(obj.toString());
            }
            throw new ValueException("throw", args.first());
        }
    };
    public static VncFunction nil_Q = new VncFunction("nil?", VncFunction.meta().module("core").arglists("(nil? x)").doc("Returns true if x is nil, false otherwise").examples("(nil? nil)", "(nil? 0)", "(nil? false)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nil?", args, 1);
            return args.first() == Constants.Nil ? Constants.True : Constants.False;
        }
    };
    public static VncFunction some_Q = new VncFunction("some?", VncFunction.meta().module("core").arglists("(some? x)").doc("Returns true if x is not nil, false otherwise").examples("(some? nil)", "(some? 0)", "(some? 4.0)", "(some? false)", "(some? [])", "(some? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("some?", args, 1);
            return args.first() == Constants.Nil ? Constants.False : Constants.True;
        }
    };
    public static VncFunction true_Q = new VncFunction("true?", VncFunction.meta().module("core").arglists("(true? x)").doc("Returns true if x is true, false otherwise").examples("(true? true)", "(true? false)", "(true? nil)", "(true? 0)", "(true? (== 1 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("true?", args, 1);
            return args.first() == Constants.True ? Constants.True : Constants.False;
        }
    };
    public static VncFunction false_Q = new VncFunction("false?", VncFunction.meta().module("core").arglists("(false? x)").doc("Returns true if x is false, false otherwise").examples("(false? true)", "(false? false)", "(false? nil)", "(false? 0)", "(false? (== 1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("false?", args, 1);
            return args.first() == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction boolean_Q = new VncFunction("boolean?", VncFunction.meta().module("core").arglists("(boolean? n)").doc("Returns true if n is a boolean").examples("(boolean? true)", "(boolean? false)", "(boolean? nil)", "(boolean? 0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("boolean?", args, 1);
            return args.first() == Constants.True || args.first() == Constants.False ? Constants.True : Constants.False;
        }
    };
    public static VncFunction int_Q = new VncFunction("int?", VncFunction.meta().module("core").arglists("(int? n)").doc("Returns true if n is an int").examples("(int? 4I)", "(int? 4)", "(int? 3.1)", "(int? true)", "(int? nil)", "(int? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("int?", args, 1);
            return Types.isVncInteger(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction long_Q = new VncFunction("long?", VncFunction.meta().module("core").arglists("(long? n)").doc("Returns true if n is a long").examples("(long? 4)", "(long? 4I)", "(long? 3.1)", "(long? true)", "(long? nil)", "(long? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long?", args, 1);
            return Types.isVncLong(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction double_Q = new VncFunction("double?", VncFunction.meta().module("core").arglists("(double? n)").doc("Returns true if n is a double").examples("(double? 4.0)", "(double? 3)", "(double? 3I)", "(double? 3.0M)", "(double? true)", "(double? nil)", "(double? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double?", args, 1);
            return Types.isVncDouble(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction decimal_Q = new VncFunction("decimal?", VncFunction.meta().module("core").arglists("(decimal? n)").doc("Returns true if n is a decimal").examples("(decimal? 4.0M)", "(decimal? 4.0)", "(decimal? 3)", "(decimal? 3I)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("decimal?", args, 1);
            return Types.isVncBigDecimal(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction number_Q = new VncFunction("number?", VncFunction.meta().module("core").arglists("(number? n)").doc("Returns true if n is a number (int, long, double, or decimal)").examples("(number? 4I))", "(number? 4)", "(number? 4.0M)", "(number? 4.0)", "(number? true)", "(number? \"a\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("number?", args, 1);
            return Types.isVncLong(args.first()) || Types.isVncInteger(args.first()) || Types.isVncDouble(args.first()) || Types.isVncBigDecimal(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction string_Q = new VncFunction("string?", VncFunction.meta().module("core").arglists("(string? x)").doc("Returns true if x is a string").examples("(bytebuf? (bytebuf [1 2]))", "(bytebuf? [1 2])", "(bytebuf? nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("string?", args, 1);
            if (args.first() instanceof VncKeyword) {
                return Constants.False;
            }
            if (args.first() instanceof VncString) {
                return Constants.True;
            }
            return Constants.False;
        }
    };
    public static VncFunction symbol = new VncFunction("symbol", VncFunction.meta().module("core").arglists("(symbol name)").doc("Returns a symbol from the given name").examples("(symbol \"a\")", "(symbol 'a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("symbol", args, 1);
            if (Types.isVncSymbol(args.first())) {
                return args.first();
            }
            if (Types.isVncString(args.first())) {
                return new VncSymbol((VncString)args.first());
            }
            throw new VncException(String.format("Function 'symbol' does not allow %s name.", Types.getType(args.first())));
        }
    };
    public static VncFunction symbol_Q = new VncFunction("symbol?", VncFunction.meta().module("core").arglists("(symbol? x)").doc("Returns true if x is a symbol").examples("(symbol? (symbol \"a\"))", "(symbol? 'a)", "(symbol? nil)", "(symbol? :a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("symbol?", args, 1);
            return Types.isVncSymbol(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction keyword = new VncFunction("keyword", VncFunction.meta().module("core").arglists("(keyword name)").doc("Returns a keyword from the given name").examples("(keyword \"a\")", "(keyword :a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keyword", args, 1);
            if (Types.isVncKeyword(args.first())) {
                return args.first();
            }
            if (Types.isVncString(args.first())) {
                return new VncKeyword(((VncString)args.first()).getValue());
            }
            throw new VncException(String.format("Function 'keyword' does not allow %s name", Types.getType(args.first())));
        }
    };
    public static VncFunction keyword_Q = new VncFunction("keyword?", VncFunction.meta().module("core").arglists("(keyword? x)").doc("Returns true if x is a keyword").examples("(keyword? (keyword \"a\"))", "(keyword? :a)", "(keyword? nil)", "(keyword? 'a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keyword?", args, 1);
            return Types.isVncKeyword(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction fn_Q = new VncFunction("fn?", VncFunction.meta().module("core").arglists("(fn? x)").doc("Returns true if x is a function").examples("(do \n   (def sum (fn [x] (+ 1 x)))\n   (fn? sum))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("fn?", args, 1);
            if (!Types.isVncFunction(args.first())) {
                return Constants.False;
            }
            return ((VncFunction)args.first()).isMacro() ? Constants.False : Constants.True;
        }
    };
    public static VncFunction macro_Q = new VncFunction("macro?", VncFunction.meta().module("core").arglists("(macro? x)").doc("Returns true if x is a macro").examples("(macro? and)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("macro?", args, 1);
            if (!Types.isVncFunction(args.first())) {
                return Constants.False;
            }
            return ((VncFunction)args.first()).isMacro() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction pr_str = new VncFunction("pr-str", VncFunction.meta().module("core").arglists("(pr-str & xs)").doc("With no args, returns the empty string. With one arg x, returns x.toString(). With more than one arg, returns the concatenation of the str values of the args with delimiter ' '.").examples("(pr-str )", "(pr-str 1 2 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? new VncString("") : new VncString(args.getList().stream().map(v -> Printer.pr_str(v, true)).collect(Collectors.joining(" ")));
        }
    };
    public static VncFunction str = new VncFunction("str", VncFunction.meta().module("core").arglists("(str & xs)").doc("With no args, returns the empty string. With one arg x, returns x.toString(). (str nil) returns the empty string. With more than one arg, returns the concatenation of the str values of the args.").examples("(str )", "(str 1 2 3)", "(str +)", "(str [1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            StringBuilder sb = new StringBuilder();
            for (VncVal v : args.getList()) {
                if (v == Constants.Nil) continue;
                sb.append(Printer.pr_str(v, false));
            }
            return new VncString(sb.toString());
        }
    };
    public static VncFunction readline = new VncFunction("readline", VncFunction.meta().module("core").arglists("(readline prompt)").doc("Reads the next line from stdin. The function is sandboxed").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String prompt = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncString(Readline.readline(prompt));
            }
            catch (IOException ex) {
                WithCallStack cs = new WithCallStack(CallFrame.fromVal("readline", args));
                Throwable throwable = null;
                try {
                    try {
                        throw new ValueException(new VncString(ex.getMessage()), (Throwable)ex);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (EofException e) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction read_string = new VncFunction("read-string", VncFunction.meta().module("core").arglists("(read-string x)").doc("Reads from x").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("read-string", args, 1, 2);
                return Reader.read_str(Coerce.toVncString(args.first()).getValue(), args.size() == 2 ? Coerce.toVncString(args.second()).getValue() : "user");
            }
            catch (ContinueException c) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction equal_Q = new VncFunction("==", VncFunction.meta().module("core").arglists("(== x y)").doc("Returns true if both operands have the equivalent type").examples("(== 0 0)", "(== 0 1)", "(== 0 0.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("==", args, 2);
            return Types._equal_Q(args.first(), args.second()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_equal_Q = new VncFunction("!=", VncFunction.meta().module("core").arglists("(!= x y)").doc("Returns true if both operands do not have the equivalent type").examples("(!= 0 1)", "(!= 0 0)", "(!= 0 0.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("!=", args, 2);
            return Types._equal_Q(args.first(), args.second()) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction match_Q = new VncFunction("match?", VncFunction.meta().module("core").arglists("(match? s regex)").doc("Returns true if the string s matches the regular expression regex").examples("(match? \"1234\" \"[0-9]+\")", "(match? \"1234ss\" \"[0-9]+\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("match?", args, 2);
            if (!Types.isVncString(args.first())) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match?'", Types.getType(args.first())));
            }
            if (!Types.isVncString(args.second())) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'match?'", Types.getType(args.second())));
            }
            return Types._match_Q(args.first(), args.second()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_match_Q = new VncFunction("not-match?", VncFunction.meta().module("core").arglists("(not-match? s regex)").doc("Returns true if the string s does not match the regular expression regex").examples("(not-match? \"1234\" \"[0-9]+\")", "(not-match? \"1234ss\" \"[0-9]+\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-match?", args, 2);
            if (!Types.isVncString(args.first())) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'not-match?'", Types.getType(args.first())));
            }
            if (!Types.isVncString(args.second())) {
                throw new VncException(String.format("Invalid second argument type %s while calling function 'not-match?'", Types.getType(args.second())));
            }
            return Types._match_Q(args.first(), args.second()) ? Constants.False : Constants.True;
        }
    };
    public static VncFunction lt = new VncFunction("<", VncFunction.meta().module("core").arglists("(< x y)").doc("Returns true if x is smaller than y").examples("(< 2 3)", "(< 2 3.0)", "(< 2 3.0M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("<", args, 2);
            VncVal op1 = args.first();
            VncVal op2 = args.second();
            if (Types.isVncNumber(op1)) {
                return op1.compareTo(op2) < 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<' with operand 1 of type %s does not allow %s as operand 2", Types.getType(op1), Types.getType(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction lte = new VncFunction("<=", VncFunction.meta().module("core").arglists("(<= x y)").doc("Returns true if x is smaller or equal to y").examples("(<= 2 3)", "(<= 3 3)", "(<= 2 3.0)", "(<= 2 3.0M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("<=", args, 2);
            VncVal op1 = args.first();
            VncVal op2 = args.second();
            if (Types.isVncNumber(op1)) {
                return op1.compareTo(op2) <= 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '<=' with operand 1 of type %s does not allow %s as operand 2", Types.getType(op1), Types.getType(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) <= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '<=' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction gt = new VncFunction(">", VncFunction.meta().module("core").arglists("(> x y)").doc("Returns true if x is greater than y").examples("(> 3 2)", "(> 3 3)", "(> 3.0 2)", "(> 3.0M 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity(">", args, 2);
            VncVal op1 = args.first();
            VncVal op2 = args.second();
            if (Types.isVncNumber(op1)) {
                return op1.compareTo(op2) > 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>' with operand 1 of type %s does not allow %s as operand 2", Types.getType(op1), Types.getType(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction gte = new VncFunction(">=", VncFunction.meta().module("core").arglists("(>= x y)").doc("Returns true if x is greater or equal to y").examples("(>= 3 2)", "(>= 3 3)", "(>= 3.0 2)", "(>= 3.0M 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity(">=", args, 2);
            VncVal op1 = args.first();
            VncVal op2 = args.second();
            if (Types.isVncNumber(op1)) {
                return op1.compareTo(op2) >= 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncString(op1)) {
                String s2;
                if (!Types.isVncString(op2)) {
                    throw new VncException(String.format("Function '>=' with operand 1 of type %s does not allow %s as operand 2", Types.getType(op1), Types.getType(op2)));
                }
                String s1 = ((VncString)op1).getValue();
                return s1.compareTo(s2 = ((VncString)op2).getValue()) >= 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function '>=' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction boolean_cast = new VncFunction("boolean", VncFunction.meta().module("core").arglists("(boolean x)").doc("Converts to boolean. Everything except 'false' and 'nil' is true in boolean context.").examples("(boolean false)", "(boolean true)", "(boolean nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("boolean", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.False;
            }
            if (arg == Constants.False) {
                return Constants.False;
            }
            return Constants.True;
        }
    };
    public static VncFunction long_cast = new VncFunction("long", VncFunction.meta().module("core").arglists("(long x)").doc("Converts to long").examples("(long 1)", "(long nil)", "(long false)", "(long true)", "(long 1.2)", "(long 1.2M)", "(long \"1\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long", args, 1);
            VncVal op1 = args.first();
            if (op1 == Constants.Nil) {
                return new VncLong(0);
            }
            if (op1 == Constants.False) {
                return new VncLong(0);
            }
            if (op1 == Constants.True) {
                return new VncLong(1);
            }
            if (Types.isVncLong(op1)) {
                return op1;
            }
            if (Types.isVncInteger(op1)) {
                return Numeric.intToLong((VncInteger)op1);
            }
            if (Types.isVncDouble(op1)) {
                return Numeric.doubleToLong((VncDouble)op1);
            }
            if (Types.isVncBigDecimal(op1)) {
                return Numeric.decimalToLong((VncBigDecimal)op1);
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncLong(Long.parseLong(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'long': the string %s can not be converted to a long", s));
                }
            }
            throw new VncException(String.format("Function 'long' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction int_cast = new VncFunction("int", VncFunction.meta().arglists("(int x)").doc("Converts to int").examples("(int 1)", "(int nil)", "(int false)", "(int true)", "(int 1.2)", "(int 1.2M)", "(int \"1\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("int", args, 1);
            VncVal op1 = args.first();
            if (op1 == Constants.Nil) {
                return new VncInteger(0);
            }
            if (op1 == Constants.False) {
                return new VncInteger(0);
            }
            if (op1 == Constants.True) {
                return new VncInteger(1);
            }
            if (Types.isVncInteger(op1)) {
                return op1;
            }
            if (Types.isVncLong(op1)) {
                return Numeric.longToInt((VncLong)op1);
            }
            if (Types.isVncDouble(op1)) {
                return Numeric.doubleToInt((VncDouble)op1);
            }
            if (Types.isVncBigDecimal(op1)) {
                return Numeric.decimalToInt((VncBigDecimal)op1);
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncInteger(Integer.parseInt(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'long': the string %s can not be converted to an int", s));
                }
            }
            throw new VncException(String.format("Function 'int' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction double_cast = new VncFunction("double", VncFunction.meta().module("core").arglists("(double x)").doc("Converts to double").examples("(double 1)", "(double nil)", "(double false)", "(double true)", "(double 1.2)", "(double 1.2M)", "(double \"1.2\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double", args, 1);
            VncVal op1 = args.first();
            if (op1 == Constants.Nil) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.False) {
                return new VncDouble(0.0);
            }
            if (op1 == Constants.True) {
                return new VncDouble(1.0);
            }
            if (Types.isVncInteger(op1)) {
                return Numeric.intToDouble((VncInteger)op1);
            }
            if (Types.isVncLong(op1)) {
                return Numeric.longToDouble((VncLong)op1);
            }
            if (Types.isVncDouble(op1)) {
                return op1;
            }
            if (Types.isVncBigDecimal(op1)) {
                return Numeric.decimalToDouble((VncBigDecimal)op1);
            }
            if (Types.isVncString(op1)) {
                String s = ((VncString)op1).getValue();
                try {
                    return new VncDouble(Double.parseDouble(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'double': the string %s can not be converted to a double", s));
                }
            }
            throw new VncException(String.format("Function 'double' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction decimal_cast = new VncFunction("decimal", VncFunction.meta().module("core").arglists("(decimal x) (decimal x scale rounding-mode)").doc("Converts to decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(decimal 2)", "(decimal 2 3 :HALF_UP)", "(decimal 2.5787 3 :HALF_UP)", "(decimal 2.5787M 3 :HALF_UP)", "(decimal \"2.5787\" 3 :HALF_UP)", "(decimal nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            RoundingMode roundingMode;
            FunctionsUtil.assertArity("decimal", args, 1, 3);
            if (args.isEmpty()) {
                return new VncBigDecimal(BigDecimal.ZERO);
            }
            VncVal arg = args.first();
            VncLong scale = args.size() < 3 ? null : Coerce.toVncLong(args.second());
            RoundingMode roundingMode2 = roundingMode = args.size() < 3 ? null : VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (arg == Constants.Nil) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.False) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (arg == Constants.True) {
                BigDecimal dec = BigDecimal.ONE;
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncString(arg)) {
                BigDecimal dec = new BigDecimal(((VncString)arg).getValue());
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            if (Types.isVncNumber(arg)) {
                BigDecimal dec = Numeric.toDecimal(arg).getValue();
                return new VncBigDecimal(args.size() < 3 ? dec : dec.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'decimal' does not allow %s as operand 1", Types.getType(arg)));
        }
    };
    public static VncFunction new_list = new VncFunction("list", VncFunction.meta().module("core").arglists("(list & items)").doc("Creates a new list containing the items.").examples("(list )", "(list 1 2 3)", "(list 1 2 3 [:a :b])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return new VncList(args.getList());
        }
    };
    public static VncFunction new_list_ASTERISK = new VncFunction("list*", VncFunction.meta().module("core").arglists("(list* args)", "(list* a args)", "(list* a b args)", "(list* a b c args)", "(list* a b c d & more)").doc("Creates a new list containing the items prepended to the rest, the\nlast of which will be treated as a collection.").examples("(list* 1 [2 3])", "(list* 1 2 3 [4])", "(list* '(1 2) 3 [4])", "(list* nil)", "(list* nil [2 3])", "(list* 1 2 nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("list*", args, 1);
            if (args.size() == 1 && args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            if (args.last() == Constants.Nil) {
                return new VncList(args.slice(0, args.size() - 1).getList());
            }
            if (!Types.isVncSequence(args.last())) {
                throw new VncException(String.format("Function 'list*' does not allow %s as last argument", Types.getType(args.last())));
            }
            return new VncList().addAllAtEnd(args.slice(0, args.size() - 1)).addAllAtEnd((VncSequence)args.last());
        }
    };
    public static VncFunction list_Q = new VncFunction("list?", VncFunction.meta().module("core").arglists("(list? obj)").doc("Returns true if obj is a list").examples("(list? (list 1 2))", "(list? '(1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("list?", args, 1);
            return CoreFunctions.list_Q(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction new_vector = new VncFunction("vector", VncFunction.meta().module("core").arglists("(vector & items)").doc("Creates a new vector containing the items.").examples("(vector )", "(vector 1 2 3)", "(vector 1 2 3 [:a :b])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return new VncVector(args.getList());
        }
    };
    public static VncFunction vector_Q = new VncFunction("vector?", VncFunction.meta().module("core").arglists("(vector? obj)").doc("Returns true if obj is a vector").examples("(vector? (vector 1 2))", "(vector? [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("vector?", args, 1);
            return CoreFunctions.vector_Q(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction subvec = new VncFunction("subvec", VncFunction.meta().module("core").arglists("(subvec v start) (subvec v start end)").doc("Returns a vector of the items in vector from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count vector)").examples("(subvec [1 2 3 4 5 6] 2)", "(subvec [1 2 3 4 5 6] 4)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("subvec", args, 2, 3);
            VncVector vec = Coerce.toVncVector(args.first());
            VncLong from = Coerce.toVncLong(args.second());
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncVector(to == null ? vec.getList().subList(from.getValue().intValue(), vec.size()) : vec.getList().subList(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction replace = new VncFunction("replace", VncFunction.meta().module("core").arglists("(replace smap coll)").doc("Given a map of replacement pairs and a collection, returns a\ncollection with any elements that are a key in smap replaced with the\ncorresponding value in smap.").examples("(replace {2 :two, 4 :four} [4 2 3 4 5 6 2])", "(replace {2 :two, 4 :four} #{1 2 3 4 5})", "(replace {[:a 10] [:c 30]} {:a 10 :b 20})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("replace", args, 2);
            VncMap map = Coerce.toVncMap(args.first());
            VncVal coll = args.second();
            if (Types.isVncSequence(coll)) {
                VncSequence seq = (VncSequence)coll;
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : seq.getList()) {
                    VncVal r = map.get(v);
                    vals.add(r == Constants.Nil ? v : r);
                }
                return seq.withValues(vals, coll.getMeta());
            }
            if (Types.isVncSet(coll)) {
                VncSet set = (VncSet)coll;
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : set.getList()) {
                    VncVal r = map.get(v);
                    vals.add(r == Constants.Nil ? v : r);
                }
                return set.withValues(vals, coll.getMeta());
            }
            if (Types.isVncMap(coll)) {
                VncMap mapc = (VncMap)coll;
                for (VncMapEntry e : map.entries()) {
                    VncVal k = Coerce.toVncVector(e.getKey()).first();
                    VncVal v = Coerce.toVncVector(e.getKey()).second();
                    if (!v.equals(mapc.get(k))) continue;
                    mapc = mapc.dissoc(k);
                    mapc = mapc.assoc(Coerce.toVncVector(e.getValue()).first(), Coerce.toVncVector(e.getValue()).second());
                }
                return mapc;
            }
            throw new VncException("Function 'repeat' requires a list, vector, set, or map as coll argument");
        }
    };
    public static VncFunction bytebuf_Q = new VncFunction("bytebuf?", VncFunction.meta().module("core").arglists("(bytebuf? x)").doc("Returns true if x is a bytebuf").examples("(bytebuf? (bytebuf [1 2]))", "(bytebuf? [1 2])", "(bytebuf? nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf?", args, 1);
            return Types.isVncByteBuffer(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction bytebuf_cast = new VncFunction("bytebuf", VncFunction.meta().module("core").arglists("(bytebuf x)").doc("Converts to bytebuf. x can be a bytebuf, a list/vector of longs, or a string").examples("(bytebuf [0 1 2])", "(bytebuf '(0 1 2))", "(bytebuf \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf", args, 0, 1);
            if (args.isEmpty()) {
                return new VncByteBuffer(ByteBuffer.wrap(new byte[0]));
            }
            VncVal arg = args.first();
            if (Types.isVncString(arg)) {
                try {
                    return new VncByteBuffer(ByteBuffer.wrap(((VncString)arg).getValue().getBytes("UTF-8")));
                }
                catch (Exception ex) {
                    throw new VncException("Failed to coerce string to bytebuf", ex);
                }
            }
            if (Types.isVncJavaObject(arg)) {
                Object delegate = ((VncJavaObject)arg).getDelegate();
                if (delegate.getClass() == byte[].class) {
                    return new VncByteBuffer(ByteBuffer.wrap((byte[])delegate));
                }
                if (delegate instanceof ByteBuffer) {
                    return new VncByteBuffer((ByteBuffer)delegate);
                }
            } else {
                if (Types.isVncByteBuffer(arg)) {
                    return arg;
                }
                if (Types.isVncSequence(arg)) {
                    if (!((VncSequence)arg).getList().stream().allMatch(v -> Types.isVncLong(v))) {
                        throw new VncException(String.format("Function 'bytebuf' a list as argument must contains long values", new Object[0]));
                    }
                    List<VncVal> list = ((VncSequence)arg).getList();
                    byte[] buf = new byte[list.size()];
                    for (int ii = 0; ii < list.size(); ++ii) {
                        buf[ii] = (byte)((VncLong)list.get(ii)).getValue().longValue();
                    }
                    return new VncByteBuffer(ByteBuffer.wrap(buf));
                }
            }
            throw new VncException(String.format("Function 'bytebuf' does not allow %s as argument", Types.getType(arg)));
        }
    };
    public static VncFunction bytebuf_from_string = new VncFunction("bytebuf-from-string", VncFunction.meta().module("core").arglists("(bytebuf-from-string s encoding)").doc("Converts a string to a bytebuf using an optional encoding. The encoding defaults to :UTF-8").examples("(bytebuf-from-string \"abcdef\" :UTF-8)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf-from-string", args, 1, 2);
            String s = Coerce.toVncString(args.first()).getValue();
            VncVal encVal = args.size() == 2 ? args.second() : Constants.Nil;
            String encoding = CoreFunctions.encoding(encVal);
            try {
                return new VncByteBuffer(ByteBuffer.wrap(s.getBytes(encoding)));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to convert string to bytebuffer", new Object[0]));
            }
        }
    };
    public static VncFunction bytebuf_to_string = new VncFunction("bytebuf-to-string", VncFunction.meta().module("core").arglists("(bytebuf-to-string buf encoding)").doc("Converts a bytebuf to a string using an optional encoding. The encoding defaults to :UTF-8").examples("(bytebuf-to-string (bytebuf [97 98 99]) :UTF-8)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf-to-string", args, 1, 2);
            ByteBuffer buf = Coerce.toVncByteBuffer(args.first()).getValue();
            VncVal encVal = args.size() == 2 ? args.second() : Constants.Nil;
            String encoding = CoreFunctions.encoding(encVal);
            try {
                return new VncString(new String(buf.array(), encoding));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to convert bytebuf to string", new Object[0]));
            }
        }
    };
    public static VncFunction bytebuf_sub = new VncFunction("bytebuf-sub", VncFunction.meta().module("core").arglists("(bytebuf-sub x start) (bytebuf-sub x start end)").doc("Returns a byte buffer of the items in buffer from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count bytebuffer)").examples("(bytebuf-sub (bytebuf [1 2 3 4 5 6]) 2)", "(bytebuf-sub (bytebuf [1 2 3 4 5 6]) 4)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bytebuf-sub", args, 2, 3);
            byte[] buf = Coerce.toVncByteBuffer(args.first()).getValue().array();
            VncLong from = Coerce.toVncLong(args.second());
            VncLong to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)) : null;
            return new VncByteBuffer(to == null ? ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), buf.length)) : ByteBuffer.wrap(Arrays.copyOfRange(buf, from.getValue().intValue(), to.getValue().intValue())));
        }
    };
    public static VncFunction new_set = new VncFunction("set", VncFunction.meta().module("core").arglists("(set & items)").doc("Creates a new set containing the items.").examples("(set )", "(set nil)", "(set 1)", "(set 1 2 3)", "(set [1 2] 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncHashSet.ofAll(args);
        }
    };
    public static VncFunction new_sorted_set = new VncFunction("sorted-set", VncFunction.meta().module("core").arglists("(sorted-set & items)").doc("Creates a new sorted-set containing the items.").examples("(sorted-set )", "(sorted-set nil)", "(sorted-set 1)", "(sorted-set 6 2 4)", "(str (sorted-set [2 3] [1 2]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncSortedSet.ofAll(args);
        }
    };
    public static VncFunction set_Q = new VncFunction("set?", VncFunction.meta().module("core").arglists("(set? obj)").doc("Returns true if obj is a set").examples("(set? (set 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("set?", args, 1);
            return Types.isVncHashSet(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction sorted_set_Q = new VncFunction("sorted-set?", VncFunction.meta().module("core").arglists("(sorted-set? obj)").doc("Returns true if obj is a sorted-set").examples("(sorted-set? (set 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sorted-set?", args, 1);
            return Types.isVncSortedSet(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction difference = new VncFunction("difference", VncFunction.meta().module("core").arglists("(difference s1)", "(difference s1 s2)", "(difference s1 s2 & sets)").doc("Return a set that is the first set without elements of the remaining sets").examples("(difference (set 1 2 3))", "(difference (set 1 2) (set 2 3))", "(difference (set 1 2) (set 1) (set 1 4) (set 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("difference", args, 1);
            HashSet<VncVal> set = new HashSet<VncVal>(Coerce.toVncSet(args.first()).getSet());
            for (int ii = 1; ii < args.size(); ++ii) {
                set.removeAll(Coerce.toVncSet(args.nth(ii)).getSet());
            }
            return VncHashSet.ofAll(set);
        }
    };
    public static VncFunction union = new VncFunction("union", VncFunction.meta().module("core").arglists("(union s1)", "(union s1 s2)", "(union s1 s2 & sets)").doc("Return a set that is the union of the input sets").examples("(union (set 1 2 3))", "(union (set 1 2) (set 2 3))", "(union (set 1 2 3) (set 1 2) (set 1 4) (set 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("union", args, 1);
            HashSet<VncVal> set = new HashSet<VncVal>(Coerce.toVncSet(args.first()).getSet());
            for (int ii = 1; ii < args.size(); ++ii) {
                set.addAll(Coerce.toVncSet(args.nth(ii)).getSet());
            }
            return VncHashSet.ofAll(set);
        }
    };
    public static VncFunction intersection = new VncFunction("intersection", VncFunction.meta().module("core").arglists("(intersection s1)", "(intersection s1 s2)", "(intersection s1 s2 & sets)").doc("Return a set that is the intersection of the input sets").examples("(intersection (set 1))", "(intersection (set 1 2) (set 2 3))", "(intersection (set 1 2) (set 3 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("intersection", args, 1);
            HashSet intersection = new HashSet();
            Set<VncVal> first = Coerce.toVncSet(args.first()).getSet();
            first.forEach(v -> {
                boolean intersect = true;
                for (int ii = 1; ii < args.size(); ++ii) {
                    if (Coerce.toVncSet(args.nth(ii)).getSet().contains(v)) continue;
                    intersect = false;
                    break;
                }
                if (intersect) {
                    intersection.add(v);
                }
            });
            return VncHashSet.ofAll(intersection);
        }
    };
    public static VncFunction new_hash_map = new VncFunction("hash-map", VncFunction.meta().module("core").arglists("(hash-map & keyvals)", "(hash-map map)").doc("Creates a new hash map containing the items.").examples("(hash-map :a 1 :b 2)", "(hash-map (sorted-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                return new VncHashMap(((VncMap)args.first()).getMap());
            }
            if (args.size() == 1 && Types.isVncJavaObject(args.first())) {
                return ((VncJavaObject)args.first()).toVncMap();
            }
            return VncHashMap.ofAll(args);
        }
    };
    public static VncFunction new_ordered_map = new VncFunction("ordered-map", VncFunction.meta().module("core").arglists("(ordered-map & keyvals)", "(ordered-map map)").doc("Creates a new ordered map containing the items.").examples("(ordered-map :a 1 :b 2)", "(ordered-map (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                return new VncOrderedMap(((VncMap)args.first()).getMap());
            }
            return VncOrderedMap.ofAll(args);
        }
    };
    public static VncFunction new_sorted_map = new VncFunction("sorted-map", VncFunction.meta().module("core").arglists("(sorted-map & keyvals)", "(sorted-map map)").doc("Creates a new sorted map containing the items.").examples("(sorted-map :a 1 :b 2)", "(sorted-map (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                return new VncSortedMap(((VncMap)args.first()).getMap());
            }
            return VncSortedMap.ofAll(args);
        }
    };
    public static VncFunction new_mutable_map = new VncFunction("mutable-map", VncFunction.meta().module("core").arglists("(mutable-map & keyvals)", "(mutable-map map)").doc("Creates a new mutable threadsafe map containing the items.").examples("(mutable-map :a 1 :b 2)", "(mutable-map (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args.size() == 1 && Types.isVncMap(args.first()) ? new VncMutableMap(((VncMap)args.first()).getMap()) : VncMutableMap.ofAll(args);
        }
    };
    public static VncFunction new_stack = new VncFunction("stack", VncFunction.meta().module("core").arglists("(stack )").doc("Creates a new mutable threadsafe stack.").examples("(let [s (stack)]\n   (push! s 4)\n   (push! s 3)\n   (pop! s)\n   s)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("stack", args, 0);
            return new VncStack();
        }
    };
    public static VncFunction new_queue = new VncFunction("queue", VncFunction.meta().module("core").arglists("(queue )", "(queue 100)").doc("Creates a new mutable threadsafe bounded or unbounded queue.").examples(";unbounded queue   \n(let [q (queue)]   \n  (offer! q 1)     \n  (offer! q 2)     \n  (offer! q 3)     \n  (poll! q)        \n   q)                ", ";bounded queue        \n(let [q (queue 10)]   \n  (offer! q 1000 1)   \n  (offer! q 1000 2)   \n  (offer! q 1000 3)   \n  (poll! q 1000)      \n   q)                   ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("queue", args, 0, 1);
            return args.isEmpty() ? new VncQueue() : new VncQueue(Coerce.toVncLong(args.first()).getIntValue());
        }
    };
    public static VncFunction map_Q = new VncFunction("map?", VncFunction.meta().module("core").arglists("(map? obj)").doc("Returns true if obj is a map").examples("(map? {:a 1 :b 2})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("map?", args, 1);
            return Types.isVncMap(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction hash_map_Q = new VncFunction("hash-map?", VncFunction.meta().module("core").arglists("(hash-map? obj)").doc("Returns true if obj is a hash map").examples("(hash-map? (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("hash-map?", args, 1);
            return Types.isVncHashMap(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction ordered_map_Q = new VncFunction("ordered-map?", VncFunction.meta().module("core").arglists("(ordered-map? obj)").doc("Returns true if obj is an ordered map").examples("(ordered-map? (ordered-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("ordered-map?", args, 1);
            return Types.isVncOrderedMap(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction sorted_map_Q = new VncFunction("sorted-map?", VncFunction.meta().module("core").arglists("(sorted-map? obj)").doc("Returns true if obj is a sorted map").examples("(sorted-map? (sorted-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sorted-map?", args, 1);
            return Types.isVncSortedMap(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction mutable_map_Q = new VncFunction("mutable-map?", VncFunction.meta().module("core").arglists("(mutable-map? obj)").doc("Returns true if obj is a mutable map").examples("(mutable-map? (mutable-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("mutable-map?", args, 1);
            return Types.isVncMutableMap(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction stack_Q = new VncFunction("stack?", VncFunction.meta().module("core").arglists("(stack? obj)").doc("Returns true if obj is a stack").examples("(stack? (stack))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("stack?", args, 1);
            return Types.isVncStack(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction queue_Q = new VncFunction("queue?", VncFunction.meta().module("core").arglists("(queue? obj)").doc("Returns true if obj is a queue").examples("(queue? (queue))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("queue?", args, 1);
            return Types.isVncQueue(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction contains_Q = new VncFunction("contains?", VncFunction.meta().module("core").arglists("(contains? coll key)").doc("Returns true if key is present in the given collection, otherwise returns false.").examples("(contains? {:a 1 :b 2} :a)", "(contains? [10 11 12] 1)", "(contains? [10 11 12] 5)", "(contains? \"abc\" 1)", "(contains? \"abc\" 5)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("contains?", args, 2);
            VncVal coll = args.first();
            VncVal key = args.second();
            if (Types.isVncMap(coll)) {
                return ((VncMap)coll).containsKey(key);
            }
            if (Types.isVncVector(coll)) {
                VncVector v = (VncVector)coll;
                VncLong k = (VncLong)key;
                return v.size() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            if (Types.isVncHashSet(coll)) {
                VncHashSet s = (VncHashSet)coll;
                return s.getSet().contains(key) ? Constants.True : Constants.False;
            }
            if (Types.isVncString(coll)) {
                VncString s = (VncString)coll;
                VncLong k = (VncLong)key;
                return s.getValue().length() > k.getValue().intValue() ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'contains?' does not allow %s as coll", Types.getType(coll)));
        }
    };
    public static VncFunction assoc = new VncFunction("assoc", VncFunction.meta().module("core").arglists("(assoc coll key val)", "(assoc coll key val & kvs)").doc("When applied to a map, returns a new map of the same type, that contains the mapping of key(s) to val(s). When applied to a vector, returns a new vector that contains val at index. Note - index must be <= (count vector).").examples("(assoc {} :a 1 :b 2)", "(assoc nil :a 1 :b 2)", "(assoc [1 2 3] 0 10)", "(assoc [1 2 3] 3 10)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return new VncHashMap().assoc(args.rest());
            }
            if (Types.isVncMutableMap(coll)) {
                throw new VncException(String.format("Function 'assoc' can not be used with mutable maps use assoc!", Types.getType(coll)));
            }
            if (Types.isVncMap(coll)) {
                return ((VncMap)coll).assoc(args.rest());
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncVal val = keyvals.nth(ii + 1);
                    vec = vec.size() > key.getValue().intValue() ? vec.setAt(key.getValue().intValue(), val) : vec.addAtEnd(val);
                }
                return vec;
            }
            if (Types.isVncString(coll)) {
                String s = ((VncString)coll).getValue();
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncString val = Coerce.toVncString(keyvals.nth(ii + 1));
                    int idx = key.getValue().intValue();
                    if (s.length() > idx) {
                        if (idx == 0) {
                            s = "" + val.getValue().charAt(0) + s.substring(1);
                            continue;
                        }
                        if (idx == s.length() - 1) {
                            s = s.substring(0, idx) + val.getValue().charAt(0);
                            continue;
                        }
                        s = s.substring(0, idx) + val.getValue().charAt(0) + s.substring(idx + 1);
                        continue;
                    }
                    s = s + val.getValue().charAt(0);
                }
                return new VncString(s);
            }
            if (Types.isVncThreadLocal(coll)) {
                VncThreadLocal th = (VncThreadLocal)coll;
                return th.assoc(args.rest());
            }
            throw new VncException(String.format("Function 'assoc' does not allow %s as collection", Types.getType(coll)));
        }
    };
    public static VncFunction assoc_BANG = new VncFunction("assoc!", VncFunction.meta().module("core").arglists("(assoc! coll key val)", "(assoc! coll key val & kvs)").doc("Associates key/vals with a mutable map, returns the map").examples("(assoc! (mutable-map ) :a 1 :b 2)", "(assoc! nil :a 1 :b 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return new VncMutableMap().assoc(args.rest());
            }
            if (Types.isVncMutableMap(coll)) {
                return ((VncMutableMap)coll).assoc(args.rest());
            }
            throw new VncException(String.format("Function 'assoc!' does not allow %s as collection. It works with mutable maps only.", Types.getType(coll)));
        }
    };
    public static VncFunction assoc_in = new VncFunction("assoc-in", VncFunction.meta().module("core").arglists("(assoc-in m ks v)").doc("Associates a value in a nested associative structure, where ks is a sequence of keys and v is the new value and returns a new nested structure. If any levels do not exist, hash-maps or vectors will be created.").examples("(do\n   (def users [{:name \"James\" :age 26}  {:name \"John\" :age 43}])\n   (assoc-in users [1 :age] 44))", "(do\n   (def users [{:name \"James\" :age 26}  {:name \"John\" :age 43}])\n   (assoc-in users [2] {:name \"Jack\" :age 19}) )").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("assoc-in", args, 3);
            VncVal coll = args.first();
            VncSequence keys = Coerce.toVncSequence(args.second());
            VncVal val = args.nth(2);
            VncVal key = keys.first();
            VncSequence keyRest = keys.rest();
            if (keyRest.isEmpty()) {
                return (VncVal)assoc.apply(VncList.of(coll, key, val));
            }
            VncVal childColl = (VncVal)get.apply(VncList.of(coll, key));
            return (VncVal)assoc.apply(VncList.of(coll, key, (VncVal)assoc_in.apply(VncList.of(childColl, keyRest, val))));
        }
    };
    public static VncFunction dissoc = new VncFunction("dissoc", VncFunction.meta().module("core").arglists("(dissoc coll key)", "(dissoc coll key & ks)").doc("Returns a new coll of the same type, that does not contain a mapping for key(s)").examples("(dissoc {:a 1 :b 2 :c 3} :b)", "(dissoc {:a 1 :b 2 :c 3} :c :b)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncMutableMap(coll)) {
                throw new VncException(String.format("Function 'dissoc' can not be used with mutable maps use dissoc!", Types.getType(coll)));
            }
            if (Types.isVncMap(coll)) {
                return ((VncMap)args.first()).dissoc(args.rest());
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    if (vec.size() <= key.getValue().intValue()) continue;
                    vec = vec.removeAt(key.getValue().intValue());
                }
                return vec;
            }
            if (Types.isVncString(coll)) {
                String s = ((VncString)coll).getValue();
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    int idx = key.getValue().intValue();
                    if (s.length() <= idx) continue;
                    s = idx == 0 ? s.substring(1) : (idx == s.length() - 1 ? s.substring(0, idx) : s.substring(0, idx) + s.substring(idx + 1));
                }
                return new VncString(s);
            }
            if (Types.isVncThreadLocal(coll)) {
                VncThreadLocal th = (VncThreadLocal)coll;
                return th.dissoc(args.rest());
            }
            throw new VncException(String.format("Function 'dissoc' does not allow %s as coll", Types.getType(coll)));
        }
    };
    public static VncFunction dissoc_BANG = new VncFunction("dissoc!", VncFunction.meta().module("core").arglists("(dissoc! coll key)", "(dissoc! coll key & ks)").doc("Dissociates keys from a mutable map, returns the map").examples("(dissoc! (mutable-map :a 1 :b 2 :c 3) :b)", "(dissoc! (mutable-map :a 1 :b 2 :c 3) :c :b)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncMap(coll)) {
                return ((VncMap)coll).dissoc(args.rest());
            }
            throw new VncException(String.format("Function 'dissoc!' does not allow %s as coll. It works with mutable maps only.", Types.getType(coll)));
        }
    };
    public static VncFunction get = new VncFunction("get", VncFunction.meta().module("core").arglists("(get map key)", "(get map key not-found)").doc("Returns the value mapped to key, not-found or nil if key not present.").examples("(get {:a 1 :b 2} :b)", ";; keywords act like functions on maps \n(:b {:a 1 :b 2})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("get", args, 2, 3);
            if (args.first() == Constants.Nil) {
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                return key_not_found;
            }
            if (Types.isVncMap(args.first())) {
                VncMap mhm = Coerce.toVncMap(args.first());
                VncVal key = args.second();
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                VncVal value = mhm.get(key);
                return value != Constants.Nil ? value : key_not_found;
            }
            if (Types.isVncVector(args.first())) {
                VncVector vec = Coerce.toVncVector(args.first());
                int idx = Coerce.toVncLong(args.second()).getIntValue();
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                return vec.nthOrDefault(idx, key_not_found);
            }
            if (Types.isVncThreadLocal(args.first())) {
                VncThreadLocal th = Coerce.toVncThreadLocal(args.first());
                VncKeyword key = Coerce.toVncKeyword(args.second());
                VncConstant key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
                VncVal value = th.get(key);
                return value != Constants.Nil ? value : key_not_found;
            }
            throw new VncException(String.format("Function 'get' does not allow %s as collection", Types.getType(args.first())));
        }
    };
    public static VncFunction get_in = new VncFunction("get-in", VncFunction.meta().module("core").arglists("(get-in m ks)", "(get-in m ks not-found)").doc("Returns the value in a nested associative structure, where ks is a sequence of keys. Returns nil if the key is not present, or the not-found value if supplied.").examples("(get-in {:a 1 :b {:c 2 :d 3}} [:b :c])", "(get-in [:a :b :c] [0])", "(get-in [:a :b [:c :d :e]] [2 1])", "(get-in {:a 1 :b {:c [4 5 6]}} [:b :c 1])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncConstant key_not_found;
            FunctionsUtil.assertArity("get-in", args, 2, 3);
            VncCollection coll = Coerce.toVncCollection(args.first());
            VncSequence keys = Coerce.toVncSequence(args.second());
            VncVal vncVal = key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
            while (!keys.isEmpty()) {
                VncVal key = keys.first();
                keys = keys.rest();
                if (Types.isVncMap(coll)) {
                    VncVal val = ((VncMap)coll).get(key);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                if (Types.isVncLong(key)) {
                    int index = ((VncLong)key).getValue().intValue();
                    VncVal val = ((VncSequence)coll).nthOrDefault(index, Constants.Nil);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                return key_not_found;
            }
            return key_not_found;
        }
    };
    public static VncFunction find = new VncFunction("find", VncFunction.meta().module("core").arglists("(find map key)").doc("Returns the map entry for key, or nil if key not present.").examples("(find {:a 1 :b 2} :b)", "(find {:a 1 :b 2} :z)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal key;
            FunctionsUtil.assertArity("find", args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            VncMap mhm = Coerce.toVncMap(args.first());
            VncVal value = mhm.get(key = args.second());
            return value == Constants.Nil ? Constants.Nil : VncVector.of(key, value);
        }
    };
    public static VncFunction key = new VncFunction("key", VncFunction.meta().module("core").arglists("(key e)").doc("Returns the key of the map entry.").examples("(key (find {:a 1 :b 2} :b))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("key", args, 1);
            VncSequence entry = Coerce.toVncSequence(args.first());
            return entry.first();
        }
    };
    public static VncFunction keys = new VncFunction("keys", VncFunction.meta().module("core").arglists("(keys map)").doc("Returns a collection of the map's keys.").examples("(keys {:a 1 :b 2 :c 3})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keys", args, 1);
            return Coerce.toVncMap(args.first()).keys();
        }
    };
    public static VncFunction val = new VncFunction("val", VncFunction.meta().module("core").arglists("(val e)").doc("Returns the val of the map entry.").examples("(val (find {:a 1 :b 2} :b))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("val", args, 1);
            VncSequence entry = Coerce.toVncSequence(args.first());
            return entry.second();
        }
    };
    public static VncFunction vals = new VncFunction("vals", VncFunction.meta().module("core").arglists("(vals map)").doc("Returns a collection of the map's values.").examples("(vals {:a 1 :b 2 :c 3})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("vals", args, 1);
            VncMap mhm = Coerce.toVncMap(args.first());
            return new VncList(mhm.getMap().values());
        }
    };
    public static VncFunction update = new VncFunction("update", VncFunction.meta().module("core").arglists("(update m k f)").doc("Updates a value in an associative structure, where k is a key and f is a function that will take the old value return the new value. Returns a new structure.").examples("(update [] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] (+ x 1)))", "(update {} :a (fn [x] 5))", "(update {:a 0} :b (fn [x] 5))", "(update {:a 0 :b 1} :a (fn [x] 5))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("update", args, 3);
            if (Types.isVncSequence(args.first())) {
                VncSequence list = (VncSequence)args.first();
                int idx = Coerce.toVncLong(args.second()).getValue().intValue();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                if (idx < 0 || idx > list.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds", idx));
                }
                if (idx < list.size()) {
                    return list.setAt(idx, (VncVal)fn.apply(VncList.of(list.nth(idx))));
                }
                return list.addAtEnd((VncVal)fn.apply(VncList.of(Constants.Nil)));
            }
            if (Types.isVncMap(args.first())) {
                VncMap map = (VncMap)args.first();
                VncVal key = args.second();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                return map.assoc(key, (VncVal)fn.apply(VncList.of(map.get(key))));
            }
            throw new VncException(String.format("'update' does not allow %s as associative structure", Types.getType(args.first())));
        }
    };
    public static VncFunction update_BANG = new VncFunction("update!", VncFunction.meta().module("core").arglists("(update! m k f)").doc("Updates a value in a mutable map, where k is a key and f is a function that will take the old value return the new value.").examples("(update! (mutable-map) :a (fn [x] 5))", "(update! (mutable-map :a 0) :b (fn [x] 5))", "(update! (mutable-map :a 0 :b 1) :a (fn [x] 5))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("update!", args, 3);
            if (Types.isVncMutableMap(args.first())) {
                VncMutableMap map = (VncMutableMap)args.first();
                VncVal key = args.second();
                VncFunction fn = Coerce.toVncFunction(args.nth(2));
                return map.assoc(key, (VncVal)fn.apply(VncList.of(map.get(key))));
            }
            throw new VncException(String.format("'update!' does not allow %s as map. It works with mutable maps only.", Types.getType(args.first())));
        }
    };
    public static VncFunction split_at = new VncFunction("split-at", VncFunction.meta().module("core").arglists("(split-at n coll)").doc("Returns a vector of [(take n coll) (drop n coll)]").examples("(split-at 2 [1 2 3 4 5])", "(split-at 3 [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("split-at", args, 2);
            if (args.second() == Constants.Nil) {
                return VncVector.of(new VncList(), new VncList());
            }
            List<VncVal> items = Coerce.toVncSequence(args.second()).getList();
            int n = Math.min(items.size(), Math.max(0, Coerce.toVncLong(args.first()).getValue().intValue()));
            return VncVector.of(new VncList(items.subList(0, n)), new VncList(items.subList(n, items.size())));
        }
    };
    public static VncFunction split_with = new VncFunction("split-with", VncFunction.meta().module("core").arglists("(split-with pred coll)").doc("Splits the collection at the first false/nil predicate result in a vector with two lists").examples("(split-with odd? [1 3 5 6 7 9])", "(split-with odd? [1 3 5])", "(split-with odd? [2 4 6])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("split-with", args, 2);
            if (args.second() == Constants.Nil) {
                return VncVector.of(new VncList(), new VncList());
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            List<VncVal> items = coll.getList();
            int splitPos = items.size();
            for (int ii = 0; ii < items.size(); ++ii) {
                VncVal val = coll.nth(ii);
                VncVal match = (VncVal)pred.apply(VncList.of(val));
                if (match != Constants.False && match != Constants.Nil) continue;
                splitPos = ii;
                break;
            }
            if (splitPos == 0) {
                return VncVector.of(new VncList(), new VncList(items));
            }
            if (splitPos < items.size()) {
                return VncVector.of(new VncList(items.subList(0, splitPos)), new VncList(items.subList(splitPos, items.size())));
            }
            return VncVector.of(new VncList(items), new VncList());
        }
    };
    public static VncFunction into = new VncFunction("into", VncFunction.meta().module("core").arglists("(into to-coll from-coll)").doc("Returns a new coll consisting of to-coll with all of the items offrom-coll conjoined.").examples("(into (sorted-map) [ [:a 1] [:c 3] [:b 2] ] )", "(into (sorted-map) [ {:a 1} {:c 3} {:b 2} ] )", "(into [] {1 2, 3 4})", "(into '() '(1 2 3))", "(into [1 2 3] '(4 5 6))", "(into '() (bytebuf [0 1 2]))", "(into [] (bytebuf [0 1 2]))", "(into '() \"abc\")", "(into [] \"abc\")", "(into (sorted-map) {:b 2 :c 3 :a 1})", "(do\n   (into (. :java.util.concurrent.CopyOnWriteArrayList :new)\n         (doto (. :java.util.ArrayList :new)\n               (. :add 3)\n               (. :add 4))))\n", "(do\n   (into (. :java.util.concurrent.CopyOnWriteArrayList :new)\n         '(3 4)))\n").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("into", args, 2);
            if (args.second() == Constants.Nil) {
                return args.first();
            }
            VncCollection to = Coerce.toVncCollection(args.first());
            if (Types.isVncByteBuffer(args.second())) {
                VncList byteList = ((VncByteBuffer)args.second()).toVncList();
                if (Types.isVncSequence(to)) {
                    return ((VncSequence)to).addAllAtEnd(byteList);
                }
                throw new VncException(String.format("Function 'into' does only allow list and vector as to-coll if from-coll is a bytebuf", new Object[0]));
            }
            if (Types.isVncString(args.second())) {
                VncList charList = ((VncString)args.second()).toVncList();
                if (Types.isVncSequence(to)) {
                    return ((VncSequence)to).addAllAtEnd(charList);
                }
                if (Types.isVncSet(to)) {
                    return ((VncSet)to).addAll(charList);
                }
                throw new VncException(String.format("Function 'into' does only allow list, vector, and set as to-coll if from-coll is a string", new Object[0]));
            }
            VncCollection from = Coerce.toVncCollection(args.second());
            if (Types.isVncVector(to)) {
                return ((VncVector)to).addAllAtEnd(from.toVncList());
            }
            if (Types.isVncList(to)) {
                return ((VncList)to).addAllAtStart(from.toVncList());
            }
            if (Types.isVncHashSet(to) || Types.isVncSortedSet(to)) {
                return ((VncHashSet)to).addAll(from.toVncList());
            }
            if (Types.isVncMap(to)) {
                if (Types.isVncSequence(from)) {
                    VncMap toMap = (VncMap)to;
                    for (VncVal it : ((VncSequence)from).getList()) {
                        if (Types.isVncSequence(it)) {
                            toMap = toMap.assoc(((VncSequence)it).toVncList());
                            continue;
                        }
                        if (!Types.isVncMap(it)) continue;
                        toMap = toMap.putAll((VncMap)it);
                    }
                    return toMap;
                }
                if (Types.isVncMap(from)) {
                    return ((VncMap)to).putAll((VncMap)from);
                }
                throw new VncException(String.format("Function 'into' does not allow %s as from-coll into a map", Types.getType(from)));
            }
            if (Types.isVncJavaList(to)) {
                if (Types.isVncJavaList(from)) {
                    List to_ = (List)((VncJavaList)to).getDelegate();
                    List from_ = (List)((VncJavaList)from).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                if (Types.isVncJavaSet(from)) {
                    List to_ = (List)((VncJavaList)to).getDelegate();
                    Set from_ = (Set)((VncJavaSet)from).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                return ((VncJavaList)to).addAllAtEnd(from.toVncList());
            }
            if (Types.isVncJavaSet(to)) {
                if (Types.isVncJavaSet(from)) {
                    Set to_ = (Set)((VncJavaSet)to).getDelegate();
                    Set from_ = (Set)((VncJavaSet)from).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                if (Types.isVncJavaList(from)) {
                    Set to_ = (Set)((VncJavaSet)to).getDelegate();
                    List from_ = (List)((VncJavaList)to).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                return ((VncJavaSet)to).addAll(from.toVncList());
            }
            throw new VncException(String.format("Function 'into' does not allow %s as to-coll", Types.getType(args.first())));
        }
    };
    public static VncFunction sequential_Q = new VncFunction("sequential?", VncFunction.meta().module("core").arglists("(sequential? obj)").doc("Returns true if obj is a sequential collection").examples("(sequential? '(1))", "(sequential? [1])", "(sequential? {:a 1})", "(sequential? nil)", "(sequential? \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sequential?", args, 1);
            return Types.isVncSequence(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction coll_Q = new VncFunction("coll?", VncFunction.meta().module("core").arglists("(coll? obj)").doc("Returns true if obj is a collection").examples("(coll? {:a 1})", "(coll? [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("coll?", args, 1);
            return Types.isVncCollection(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction every_Q = new VncFunction("every?", VncFunction.meta().module("core").arglists("(every? pred coll)").doc("Returns true if the predicate is true for all collection items, false otherwise").examples("(every? number? nil)", "(every? number? [])", "(every? number? [1 2 3 4])", "(every? number? [1 2 3 :a])", "(every? #(>= % 10) [10 11 12])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("every?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.False;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            if (coll.isEmpty()) {
                return Constants.False;
            }
            return coll.toVncList().getList().stream().allMatch(v -> pred.apply(VncList.of(v)) == Constants.True) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_every_Q = new VncFunction("not-every?", VncFunction.meta().module("core").arglists("(not-every? pred coll)").doc("Returns false if the predicate is true for all collection items, true otherwise").examples("(not-every? number? nil)", "(not-every? number? [])", "(not-every? number? [1 2 3 4])", "(not-every? number? [1 2 3 :a])", "(not-every? #(>= % 10) [10 11 12])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-every?", args, 2);
            return every_Q.apply(args) == Constants.True ? Constants.False : Constants.True;
        }
    };
    public static VncFunction any_Q = new VncFunction("any?", VncFunction.meta().module("core").arglists("(any? pred coll)").doc("Returns true if the predicate is true for at least one collection item, false otherwise").examples("(any? number? nil)", "(any? number? [])", "(any? number? [1 :a :b])", "(any? number? [1 2 3])", "(any? #(>= % 10) [1 5 10])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("any?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.False;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            if (coll.isEmpty()) {
                return Constants.False;
            }
            return coll.toVncList().getList().stream().anyMatch(v -> pred.apply(VncList.of(v)) == Constants.True) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction not_any_Q = new VncFunction("not-any?", VncFunction.meta().module("core").arglists("(not-any? pred coll)").doc("Returns false if the predicate is true for at least one collection item, true otherwise").examples("(not-any? number? nil)", "(not-any? number? [])", "(not-any? number? [1 :a :b])", "(not-any? number? [1 2 3])", "(not-any? #(>= % 10) [1 5 10])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-any?", args, 2);
            return any_Q.apply(args) == Constants.True ? Constants.False : Constants.True;
        }
    };
    public static VncFunction some = new VncFunction("some", VncFunction.meta().module("core").arglists("(some? pred coll)").doc("Returns the first logical true value of (pred x) for any x in coll, else nil.").examples("(some even? '(1 2 3 4))", "(some even? '(1 3 5 7))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("some?", args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.Nil;
            }
            VncFunction pred = Coerce.toVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            if (coll.isEmpty()) {
                return Constants.Nil;
            }
            return coll.toVncList().getList().stream().anyMatch(v -> pred.apply(VncList.of(v)) == Constants.True) ? Constants.True : Constants.Nil;
        }
    };
    public static VncFunction count = new VncFunction("count", VncFunction.meta().module("core").arglists("(count coll)").doc("Returns the number of items in the collection. (count nil) returns 0. Also works on strings, and Java Collections").examples("(count {:a 1 :b 2})", "(count [1 2])", "(count \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("count", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return new VncLong(0L);
            }
            if (Types.isVncString(arg)) {
                return new VncLong(((VncString)arg).getValue().length());
            }
            if (Types.isVncByteBuffer(arg)) {
                return new VncLong(((VncByteBuffer)arg).size());
            }
            if (Types.isVncCollection(arg)) {
                return new VncLong(((VncCollection)arg).size());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'count'", Types.getType(arg)));
        }
    };
    public static VncFunction empty = new VncFunction("empty", VncFunction.meta().module("core").arglists("(empty coll)").doc("Returns an empty collection of the same category as coll, or nil").examples("(empty {:a 1})", "(empty [1 2])", "(empty '(1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).empty();
            }
            if (Types.isVncMap(coll)) {
                return ((VncMap)coll).empty();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'empty'", Types.getType(coll)));
        }
    };
    public static VncFunction empty_Q = new VncFunction("empty?", VncFunction.meta().module("core").arglists("(empty? x)").doc("Returns true if x is empty").examples("(empty? {})", "(empty? [])", "(empty? '())").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty?", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.True;
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).getValue().isEmpty() ? Constants.True : Constants.False;
            }
            if (Types.isVncCollection(val)) {
                return ((VncCollection)val).isEmpty() ? Constants.True : Constants.False;
            }
            if (Types.isVncByteBuffer(val)) {
                return ((VncByteBuffer)val).size() == 0 ? Constants.True : Constants.False;
            }
            return Constants.False;
        }
    };
    public static VncFunction not_empty_Q = new VncFunction("not-empty?", VncFunction.meta().module("core").arglists("(not-empty? x)").doc("Returns true if x is not empty").examples("(not-empty? {:a 1})", "(not-empty? [1 2])", "(not-empty? '(1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("not-empty?", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.False;
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).getValue().isEmpty() ? Constants.False : Constants.True;
            }
            if (Types.isVncCollection(val)) {
                return ((VncCollection)val).isEmpty() ? Constants.False : Constants.True;
            }
            if (Types.isVncByteBuffer(val)) {
                return ((VncByteBuffer)val).size() == 0 ? Constants.False : Constants.True;
            }
            return Constants.True;
        }
    };
    public static VncFunction cons = new VncFunction("cons", VncFunction.meta().module("core").arglists("(cons x coll)").doc("Returns a new collection where x is the first element and coll is the rest").examples("(cons 1 '(2 3 4 5 6))", "(cons [1 2] [4 5 6])", "(cons 3 (set 1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cons", args, 2);
            VncVal coll = args.second();
            if (Types.isVncVector(coll)) {
                return ((VncVector)coll).addAtStart(args.first());
            }
            if (Types.isVncList(coll)) {
                return ((VncList)coll).addAtStart(args.first());
            }
            if (Types.isVncHashSet(coll)) {
                return ((VncHashSet)coll).add(args.first());
            }
            if (Types.isVncMap(coll) && Types.isVncMap(args.first())) {
                return ((VncMap)coll).putAll((VncMap)args.first());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cons'", Types.getType(coll)));
        }
    };
    public static VncFunction concat = new VncFunction("concat", VncFunction.meta().module("core").arglists("(concat coll)", "(concat coll & colls)").doc("Returns a collection of the concatenation of the elements in the supplied colls.").examples("(concat [1 2])", "(concat [1 2] [4 5 6])", "(concat '(1 2))", "(concat '(1 2) [4 5 6])", "(concat {:a 1})", "(concat {:a 1} {:b 2 :c 3})", "(concat \"abc\")", "(concat \"abc\" \"def\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArrayList result = new ArrayList();
            args.getList().forEach(val -> {
                if (val != Constants.Nil) {
                    if (Types.isVncString(val)) {
                        String str = ((VncString)val).getValue();
                        for (char ch : str.toCharArray()) {
                            result.add(new VncString(String.valueOf(ch)));
                        }
                    } else if (Types.isVncSequence(val)) {
                        result.addAll(((VncSequence)val).getList());
                    } else if (Types.isVncSet(val)) {
                        result.addAll(((VncSet)val).getList());
                    } else if (Types.isVncMap(val)) {
                        result.addAll(((VncMap)val).toVncList().getList());
                    } else {
                        throw new VncException(String.format("Invalid argument type %s while calling function 'concat'", Types.getType(val)));
                    }
                }
            });
            return new VncList(result);
        }
    };
    public static VncFunction interleave = new VncFunction("interleave", VncFunction.meta().module("core").arglists("(interleave c1 c2)", "(interleave c1 c2 & colls)").doc("Returns a collection of the first item in each coll, then the second etc.").examples("(interleave [:a :b :c] [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("interleave", args, 2);
            int len = Coerce.toVncSequence(args.first()).size();
            ArrayList<VncSequence> lists = new ArrayList<VncSequence>();
            for (int ii = 0; ii < args.size(); ++ii) {
                VncSequence l = Coerce.toVncSequence(args.nth(ii));
                lists.add(l);
                len = Math.min(len, l.size());
            }
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            for (int nn = 0; nn < len; ++nn) {
                for (int ii = 0; ii < lists.size(); ++ii) {
                    result.add(((VncSequence)lists.get(ii)).nth(nn));
                }
            }
            return new VncList(result);
        }
    };
    public static VncFunction interpose = new VncFunction("interpose", VncFunction.meta().module("core").arglists("(interpose sep coll)").doc("Returns a collection of the elements of coll separated by sep.").examples("(interpose \", \" [1 2 3])", "(apply str (interpose \", \" [1 2 3]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("interpose", args, 2);
            VncVal sep = args.first();
            VncSequence coll = Coerce.toVncSequence(args.second());
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            if (!coll.isEmpty()) {
                result.add(coll.first());
                coll.rest().forEach(v -> {
                    result.add(sep);
                    result.add((VncVal)v);
                });
            }
            return new VncList(result);
        }
    };
    public static VncFunction first = new VncFunction("first", VncFunction.meta().module("core").arglists("(first coll)").doc("Returns the first element of coll.").examples("(first nil)", "(first [])", "(first [1 2 3])", "(first '())", "(first '(1 2 3))", "(first \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("first", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).first();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).first();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'first'", Types.getType(val)));
        }
    };
    public static VncFunction second = new VncFunction("second", VncFunction.meta().module("core").arglists("(second coll)").doc("Returns the second element of coll.").examples("(second nil)", "(second [])", "(second [1 2 3])", "(second '())", "(second '(1 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("second", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).second();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).second();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'second'", Types.getType(val)));
        }
    };
    public static VncFunction third = new VncFunction("third", VncFunction.meta().module("core").arglists("(third coll)").doc("Returns the third element of coll.").examples("(third nil)", "(third [])", "(second [1 2 3])", "(third '())", "(third '(1 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("third", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).third();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).nth(2);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'third'", Types.getType(val)));
        }
    };
    public static VncFunction nth = new VncFunction("nth", VncFunction.meta().module("core").arglists("(nth coll idx)").doc("Returns the nth element of coll.").examples("(nth nil 1)", "(nth [1 2 3] 1)", "(nth '(1 2 3) 1)", "(nth \"abc\" 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nth", args, 2);
            int idx = Coerce.toVncLong(args.second()).getValue().intValue();
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).nth(idx);
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).nth(idx);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'nth'", Types.getType(val)));
        }
    };
    public static VncFunction last = new VncFunction("last", VncFunction.meta().module("core").arglists("(last coll)").doc("Returns the last element of coll.").examples("(last nil)", "(last [])", "(last [1 2 3])", "(last '())", "(last '(1 2 3))", "(last \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("last", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).last();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).last();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'last'", Types.getType(val)));
        }
    };
    public static VncFunction rest = new VncFunction("rest", VncFunction.meta().module("core").arglists("(rest coll)").doc("Returns a collection with second to list element").examples("(rest nil)", "(rest [])", "(rest [1])", "(rest [1 2 3])", "(rest '())", "(rest '(1))", "(rest '(1 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rest", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(coll)) {
                return ((VncVector)coll).rest();
            }
            if (Types.isVncList(coll)) {
                return ((VncList)coll).rest();
            }
            if (Types.isVncJavaList(coll)) {
                return ((VncJavaList)coll).rest();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'rest'", Types.getType(args.first())));
        }
    };
    public static VncFunction butlast = new VncFunction("butlast", VncFunction.meta().module("core").arglists("(butlast coll)").doc("Returns a collection with all but the last list element").examples("(butlast nil)", "(butlast [])", "(butlast [1])", "(butlast [1 2 3])", "(butlast '())", "(butlast '(1))", "(butlast '(1 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("butlast", args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                return vec.size() > 1 ? vec.slice(0, vec.size() - 1) : new VncVector();
            }
            if (Types.isVncList(coll)) {
                VncList list = (VncList)coll;
                return list.size() > 1 ? list.slice(0, list.size() - 1) : new VncList();
            }
            if (Types.isVncJavaList(coll)) {
                VncList list = ((VncJavaList)coll).toVncList();
                return list.size() > 1 ? list.slice(0, list.size() - 1) : new VncList();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'butlast'", Types.getType(args.first())));
        }
    };
    public static VncFunction nfirst = new VncFunction("nfirst", VncFunction.meta().module("core").arglists("(nfirst coll n)").doc("Returns a collection of the first n items").examples("(nfirst nil 2)", "(nfirst [] 2)", "(nfirst [1] 2)", "(nfirst [1 2 3] 2)", "(nfirst '() 2)", "(nfirst '(1) 2)", "(nfirst '(1 2 3) 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nfirst", args, 2);
            if (args.first() == Constants.Nil) {
                return new VncList();
            }
            if (Types.isVncVector(args.first())) {
                VncVector vec = Coerce.toVncVector(args.first());
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.second()).getValue().intValue()));
                return vec.isEmpty() ? new VncVector() : new VncVector(vec.getList().subList(0, n));
            }
            if (Types.isVncList(args.first()) || Types.isVncJavaList(args.first())) {
                VncSequence list = Coerce.toVncSequence(args.first());
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.second()).getValue().intValue()));
                return list.isEmpty() ? new VncList() : new VncList(list.getList().subList(0, n));
            }
            throw new VncException(String.format("nfirst: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction nlast = new VncFunction("nlast", VncFunction.meta().module("core").arglists("(nlast coll n)").doc("Returns a collection of the last n items").examples("(nlast nil 2)", "(nlast [] 2)", "(nlast [1] 2)", "(nlast [1 2 3] 2)", "(nlast '() 2)", "(nlast '(1) 2)", "(nlast '(1 2 3) 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nlast", args, 2);
            if (args.first() == Constants.Nil) {
                return new VncList();
            }
            if (Types.isVncVector(args.first())) {
                VncVector vec = Coerce.toVncVector(args.first());
                int n = Math.max(0, Math.min(vec.size(), Coerce.toVncLong(args.second()).getValue().intValue()));
                return vec.isEmpty() ? new VncVector() : new VncVector(vec.getList().subList(vec.size() - n, vec.size()));
            }
            if (Types.isVncList(args.first()) || Types.isVncJavaList(args.first())) {
                VncList list = Coerce.toVncList(args.first());
                int n = Math.max(0, Math.min(list.size(), Coerce.toVncLong(args.second()).getValue().intValue()));
                return list.isEmpty() ? new VncList() : new VncList(list.getList().subList(list.size() - n, list.size()));
            }
            throw new VncException(String.format("nlast: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction distinct = new VncFunction("distinct", VncFunction.meta().module("core").arglists("(distinct coll)").doc("Returns a collection with all duplicates removed").examples("(distinct [1 2 3 4 2 3 4])", "(distinct '(1 2 3 4 2 3 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("distinct", args, 1);
            if (args.first() == Constants.Nil) {
                return new VncList();
            }
            return ((VncSequence)args.first()).withValues(Coerce.toVncSequence(args.first()).getList().stream().distinct().collect(Collectors.toList()));
        }
    };
    public static VncFunction dedupe = new VncFunction("dedupe", VncFunction.meta().module("core").arglists("(dedupe coll)").doc("Returns a collection with all consecutive duplicates removed").examples("(dedupe [1 2 2 2 3 4 4 2 3])", "(dedupe '(1 2 2 2 3 4 4 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dedupe", args, 1);
            if (args.first() == Constants.Nil) {
                return new VncList();
            }
            VncVal seen = null;
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (VncVal val : Coerce.toVncSequence(args.first()).getList()) {
                if (seen != null && val.equals(seen)) continue;
                items.add(val);
                seen = val;
            }
            return ((VncSequence)args.first()).withValues(items);
        }
    };
    public static VncFunction partition = new VncFunction("partition", VncFunction.meta().module("core").arglists("(partition n coll)", "(partition n step coll)", "(partition n step padcoll coll)").doc("Returns a collection of lists of n items each, at offsets step apart. If step is not supplied, defaults to n, i.e. the partitions do not overlap. If a padcoll collection is supplied, use its elements as necessary to complete last partition upto n items. In case there are not enough padding elements, return a partition with less than n items.").examples("(partition 4 (range 20))", "(partition 4 6 (range 20))", "(partition 3 6 [\"a\"] (range 20))", "(partition 4 6 [\"a\" \"b\" \"c\" \"d\"] (range 20))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("partition", args, 2, 3, 4);
            int n = Coerce.toVncLong(args.first()).getValue().intValue();
            int step = args.size() > 2 ? Coerce.toVncLong(args.second()).getValue().intValue() : n;
            ArrayList padcoll = args.size() > 3 ? Coerce.toVncSequence(args.nth(2)).getList() : new ArrayList();
            List<VncVal> coll = Coerce.toVncSequence(args.nth(args.size() - 1)).getList();
            if (n <= 0) {
                throw new VncException(String.format("partition: n must be a positive number", new Object[0]));
            }
            if (step <= 0) {
                throw new VncException(String.format("partition: step must be a positive number", new Object[0]));
            }
            ArrayList<List<VncVal>> splits = new ArrayList<List<VncVal>>();
            for (int ii = 0; ii < coll.size(); ii += step) {
                splits.add(coll.subList(ii, Math.min(ii + step, coll.size())));
            }
            VncList result = new VncList();
            for (List list : splits) {
                if (n == list.size()) {
                    result = result.addAtEnd(new VncList(list));
                    continue;
                }
                if (n < list.size()) {
                    result = result.addAtEnd(new VncList(list.subList(0, n)));
                    continue;
                }
                ArrayList split_ = new ArrayList(list);
                for (int ii = 0; ii < n - list.size() && ii < padcoll.size(); ++ii) {
                    split_.add(padcoll.get(ii));
                }
                result = result.addAtEnd(new VncList(split_));
            }
            return result;
        }
    };
    public static VncFunction coalesce = new VncFunction("coalesce", VncFunction.meta().module("core").arglists("(coalesce args*)").doc("Returns the first non nil arg").examples("(coalesce )", "(coalesce 1 2)", "(coalesce nil)", "(coalesce nil 1 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args.stream().filter(v -> v != Constants.Nil).findFirst().orElse(Constants.Nil);
        }
    };
    public static VncFunction emptyToNil = new VncFunction("empty-to-nil", VncFunction.meta().module("core").arglists("(empty-to-nil x)").doc("Returns nil if x is empty").examples("(empty-to-nil \"\")", "(empty-to-nil [])", "(empty-to-nil '())", "(empty-to-nil {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("empty-to-nil", args, 1);
            VncVal arg = args.first();
            if (Types.isVncString(arg)) {
                return ((VncString)arg).getValue().isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncVector(arg)) {
                return ((VncVector)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncList(arg)) {
                return ((VncList)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncMap(arg)) {
                return ((VncMap)arg).isEmpty() ? Constants.Nil : arg;
            }
            return arg;
        }
    };
    public static VncFunction instance_Q = new VncFunction("instance?", VncFunction.meta().module("core").arglists("(instance? type x)").doc("Returns true if x is an instance of the given type").examples("(instance? :venice.Long 500)", "(instance? :java.math.BigInteger 500)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("instance?", args, 2);
            VncKeyword type = Coerce.toVncKeyword(args.first());
            VncVal x = args.second();
            return Types.isInstanceOf(type, x) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction pop = new VncFunction("pop", VncFunction.meta().module("core").arglists("(pop coll)").doc("For a list, returns a new list without the first item, for a vector, returns a new vector without the last item.").examples("(pop '(1 2 3 4))", "(pop [1 2 3 4])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pop", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(val)) {
                VncVector vec = (VncVector)val;
                return vec.size() < 2 ? new VncVector() : vec.slice(0, vec.size() - 1);
            }
            if (Types.isVncSequence(val)) {
                VncSequence seq = (VncSequence)val;
                return seq.isEmpty() ? new VncList() : seq.rest();
            }
            throw new VncException(String.format("pop: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction pop_BANG = new VncFunction("pop!", VncFunction.meta().module("core").arglists("(pop! stack)").doc("Pops an item from a stack.").examples("(let [s (stack)]\n   (push! s 4)\n   (push! s 3)\n   (pop! s)\n   s)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pop!", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncStack(val)) {
                return ((VncStack)val).pop();
            }
            throw new VncException(String.format("pop!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction push_BANG = new VncFunction("push!", VncFunction.meta().module("core").arglists("(push! stack v)").doc("Pushes an item to a stack.").examples("(let [s (stack)]\n   (push! s 4)\n   (push! s 3)\n   (pop! s)\n   s)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("push!", args, 2);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncStack(val)) {
                return ((VncStack)val).push(args.second());
            }
            throw new VncException(String.format("push!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction offer_BANG = new VncFunction("offer!", VncFunction.meta().module("core").arglists("(offer! queue v)", "(offer! queue timeout v)").doc("Offers an item to a queue with an optional timeout in milliseconds.").examples("(let [s (queue)]\n   (offer! s 4)\n   (offer! s 3)\n   (poll! s)\n   s)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("offer!", args, 2, 3);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncQueue(val)) {
                if (args.size() == 2) {
                    return ((VncQueue)val).offer(args.second());
                }
                return ((VncQueue)val).offer(args.third(), Coerce.toVncLong(args.second()).getValue());
            }
            throw new VncException(String.format("offer!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction poll_BANG = new VncFunction("poll!", VncFunction.meta().module("core").arglists("(poll! queue)", "(poll! queue timeout)").doc("Polls an item from a queue with an optional timeout in milliseconds.").examples("(let [s (queue)]\n   (offer! s 4)\n   (offer! s 3)\n   (poll! s)\n   s)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("poll!", args, 1, 2);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncQueue(val)) {
                if (args.size() == 1) {
                    return ((VncQueue)val).poll();
                }
                return ((VncQueue)val).poll(Coerce.toVncLong(args.second()).getValue());
            }
            throw new VncException(String.format("poll!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction peek = new VncFunction("peek", VncFunction.meta().module("core").arglists("(peek coll)").doc("For a list, same as first, for a vector, same as last, for a stack the top element").examples("(peek '(1 2 3 4))", "(peek [1 2 3 4])", "(let [s (stack)]\n   (push! s 4)\n  (peek s))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("peek", args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(val)) {
                VncVector vec = (VncVector)val;
                return vec.isEmpty() ? Constants.Nil : vec.nth(vec.size() - 1);
            }
            if (Types.isVncSequence(val)) {
                VncSequence seq = (VncSequence)val;
                return seq.isEmpty() ? Constants.Nil : seq.first();
            }
            if (Types.isVncStack(val)) {
                return ((VncStack)val).peek();
            }
            throw new VncException(String.format("peek: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction take_while = new VncFunction("take-while", VncFunction.meta().module("core").arglists("(take-while predicate coll)").doc("Returns a list of successive items from coll while (predicate item) returns logical true.").examples("(take-while neg? [-2 -1 0 1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(VncList.of(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(0, i);
            }
            return coll;
        }
    };
    public static VncFunction take = new VncFunction("take", VncFunction.meta().module("core").arglists("(take n coll)").doc("Returns a collection of the first n items in coll, or all items if there are fewer than n.").examples("(take 3 [1 2 3 4 5])", "(take 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take", args, 2);
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            return coll.slice(0, (int)Math.min(n.getValue(), (long)coll.size()));
        }
    };
    public static VncFunction drop_while = new VncFunction("drop-while", VncFunction.meta().module("core").arglists("(drop-while predicate coll)").doc("Returns a list of the items in coll starting from the first item for which (predicate item) returns logical false.").examples("(drop-while neg? [-2 -1 0 1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop-while", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = (VncVal)predicate.apply(VncList.of(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(i);
            }
            return coll.empty();
        }
    };
    public static VncFunction drop = new VncFunction("drop", VncFunction.meta().module("core").arglists("(drop n coll)").doc("Returns a collection of all but the first n items in coll").examples("(drop 3 [1 2 3 4 5])", "(drop 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop", args, 2);
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            return coll.slice((int)Math.min(n.getValue() + 1L, (long)coll.size()));
        }
    };
    public static VncFunction flatten = new VncFunction("flatten", VncFunction.meta().module("core").arglists("(flatten coll)").doc("Takes any nested combination of collections (lists, vectors, etc.) and returns their contents as a single, flat sequence. (flatten nil) returns an empty list.").examples("(flatten [])", "(flatten [[1 2 3] [4 5 6] [7 8 9]])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("flatten", args, 1);
            VncCollection coll = Coerce.toVncCollection(args.first());
            ArrayList result = new ArrayList();
            CoreFunctions.flatten(coll, result);
            return Types.isVncVector(coll) ? new VncVector(result) : new VncList(result);
        }
    };
    public static VncFunction reverse = new VncFunction("reverse", VncFunction.meta().module("core").arglists("(reverse coll)").doc("Returns a collection of the items in coll in reverse order").examples("(reverse [1 2 3 4 5 6])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reverse", args, 1);
            VncSequence coll = Coerce.toVncSequence(args.first());
            ArrayList<VncVal> reversed = new ArrayList<VncVal>();
            for (int ii = coll.size() - 1; ii >= 0; --ii) {
                reversed.add(coll.nth(ii));
            }
            return coll.withValues(reversed);
        }
    };
    public static VncFunction sort = new VncFunction("sort", VncFunction.meta().module("core").arglists("(sort coll)", "(sort comparefn coll)").doc("Returns a sorted list of the items in coll. If no compare function comparefn is supplied, uses the natural compare. The compare function takes two arguments and returns -1, 0, or 1").examples("(sort [3 2 5 4 1 6])", "(sort compare [3 2 5 4 1 6])", "; reversed\n(sort (comp (partial * -1) compare) [3 2 5 4 1 6])", "(sort {:c 3 :a 1 :b 2})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sort", args, 1, 2);
            if (args.size() == 1) {
                return CoreFunctions.sort("sort", args, args.first(), (x, y) -> Coerce.toVncLong((VncVal)compare.apply(VncList.of(x, y))).getIntValue());
            }
            if (args.size() == 2) {
                VncFunction compfn = Coerce.toVncFunction(args.first());
                return CoreFunctions.sort("sort", args, args.second(), (x, y) -> Coerce.toVncLong((VncVal)compfn.apply(VncList.of(x, y))).getIntValue());
            }
            throw new VncException("sort: args not supported");
        }
    };
    public static VncFunction sort_by = new VncFunction("sort-by", VncFunction.meta().module("core").arglists("(sort-by keyfn coll)", "(sort-by keyfn compfn coll)").doc("Returns a sorted sequence of the items in coll, where the sort order is determined by comparing (keyfn item).  If no comparator is supplied, uses compare.").examples("(sort-by count [\"aaa\" \"bb\" \"c\"])", "; reversed\n(sort-by count (comp (partial * -1) compare) [\"aaa\" \"bb\" \"c\"])", "(sort-by first [[1 2] [3 4] [2 3]])", "; reversed\n(sort-by first (comp (partial * -1) compare) [[1 2] [3 4] [2 3]])", "(sort-by (fn [x] (get x :rank)) [{:rank 2} {:rank 3} {:rank 1}])", "; reversed\n(sort-by (fn [x] (get x :rank)) (comp (partial * -1) compare) [{:rank 2} {:rank 3} {:rank 1}])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sort-by", args, 2, 3);
            if (args.size() == 2) {
                VncFunction keyfn = Coerce.toVncFunction(args.first());
                return CoreFunctions.sort("sort-by", args, args.second(), (x, y) -> Coerce.toVncLong((VncVal)compare.apply(VncList.of((VncVal)keyfn.apply(VncList.of(x)), (VncVal)keyfn.apply(VncList.of(y))))).getIntValue());
            }
            if (args.size() == 3) {
                VncFunction keyfn = Coerce.toVncFunction(args.first());
                VncFunction compfn = Coerce.toVncFunction(args.second());
                return CoreFunctions.sort("sort-by", args, args.nth(2), (x, y) -> Coerce.toVncLong((VncVal)compfn.apply(VncList.of((VncVal)keyfn.apply(VncList.of(x)), (VncVal)keyfn.apply(VncList.of(y))))).getIntValue());
            }
            throw new VncException("sort-by: args not supported");
        }
    };
    public static VncFunction group_by = new VncFunction("group-by", VncFunction.meta().module("core").arglists("(group-by f coll)").doc("Returns a map of the elements of coll keyed by the result of f on each element. The value at each key will be a vector of the corresponding elements, in the order they appeared in coll.").examples("(group-by count [\"a\" \"as\" \"asd\" \"aa\" \"asdf\" \"qwer\"])", "(group-by odd? (range 10))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("group-by", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            VncMap map = new VncOrderedMap();
            for (VncVal v : coll.getList()) {
                VncVal key = (VncVal)fn.apply(VncList.of(v));
                VncSequence val = Coerce.toVncSequence(((VncMap)map).getMap().get(key));
                if (val == null) {
                    map = ((VncMap)map).assoc(key, VncVector.of(v));
                    continue;
                }
                map = ((VncMap)map).assoc(key, val.addAtEnd(v));
            }
            return map;
        }
    };
    public static VncFunction apply = new VncFunction("apply", VncFunction.meta().module("core").arglists("(apply f args* coll)").doc("Applies f to all arguments composed of args and coll").examples("(apply + [1 2 3])", "(apply + 1 2 [3 4 5])", "(apply str [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncList fn_args = args.slice(1, args.size() - 1);
            VncVal coll = args.last();
            if (coll == Constants.Nil) {
                return (VncVal)fn.apply(fn_args.addAtEnd(Constants.Nil));
            }
            VncSequence tailArgs = Coerce.toVncSequence(args.last());
            return (VncVal)fn.apply(fn_args.addAllAtEnd(tailArgs));
        }
    };
    public static VncFunction comp = new VncFunction("comp", VncFunction.meta().module("core").arglists("(comp f*)").doc("Takes a set of functions and returns a fn that is the composition of those fns. The returned fn takes a variable number of args, applies the rightmost of fns to the args, the next fn (right-to-left) to the result, etc. ").examples("((comp str +) 8 8 8)", "(map (comp - (partial + 3) (partial * 2)) [1 2 3 4])", "((reduce comp [(partial + 1) (partial * 2) (partial + 3)]) 100)", "(filter (comp not zero?) [0 1 0 2 0 3 0 4])", "(do \n   (def fifth (comp first rest rest rest rest)) \n   (fifth [1 2 3 4 5]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("comp", args, 1);
            final List fns = args.getList().stream().map(v -> Coerce.toVncFunction(v)).collect(Collectors.toList());
            return new VncFunction(){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList args_ = args;
                    VncVal result = Constants.Nil;
                    for (int ii = fns.size() - 1; ii >= 0; --ii) {
                        VncFunction fn = (VncFunction)fns.get(ii);
                        result = (VncVal)fn.apply(args_);
                        args_ = VncList.of(result);
                    }
                    return result;
                }
            };
        }
    };
    public static VncFunction compare = new VncFunction("compare", VncFunction.meta().module("core").arglists("(compare x y)").doc("Comparator. Returns -1, 0, or 1 when x is logically 'less than', 'equal to', or 'greater than' y. For list and vectors the longer sequence is always 'greater' regardless of its contents. For sets and maps only the size of the collection is compared.").examples("(compare nil 0)", "(compare 0 nil)", "(compare 1 0)", "(compare 1 1)", "(compare 1M 2M)", "(compare 1 nil)", "(compare nil 1)", "(compare \"aaa\" \"bbb\")", "(compare [0 1 2] [0 1 2])", "(compare [0 1 2] [0 9 2])", "(compare [0 9 2] [0 1 2])", "(compare [1 2 3] [0 1 2 3])", "(compare [0 1 2] [3 4])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("compare", args, 2);
            return new VncLong(args.first().compareTo(args.second()));
        }
    };
    public static VncFunction partial = new VncFunction("partial", VncFunction.meta().module("core").arglists("(partial f args*)").doc("Takes a function f and fewer than the normal arguments to f, and returns a fn that takes a variable number of additional args. When called, the returned function calls f with args + additional args.").examples("((partial * 2) 3)", "(map (partial * 2) [1 2 3 4])", "(do \n   (def hundred-times (partial * 100)) \n   (hundred-times 5))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("partial", args, 2);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            final VncList fnArgs = args.rest();
            return new VncFunction(){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    return (VncVal)fn.apply(fnArgs.addAllAtEnd(args));
                }
            };
        }
    };
    public static VncFunction map = new VncFunction("map", VncFunction.meta().module("core").arglists("(map f coll colls*)").doc("Applys f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ").examples("(map inc [1 2 3 4])", "(map + [1 2 3 4] [10 20 30 40])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() < 2) {
                return Constants.Nil;
            }
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncList lists = FunctionsUtil.removeNilValues(args.rest());
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                ArrayList<VncVal> fnArgs = new ArrayList<VncVal>();
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncSequence nthList = Coerce.toVncSequence(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.add(nthList.nth(index));
                }
                if (!hasMore) continue;
                VncVal val = (VncVal)fn.apply(new VncList(fnArgs));
                result.add(val);
                ++index;
            }
            return new VncList(result);
        }
    };
    public static VncFunction mapv = new VncFunction("mapv", VncFunction.meta().module("core").arglists("(mapv f coll colls*)").doc("Returns a vector consisting of the result of applying f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted.  Any remaining items in other colls are ignored. ").examples("(mapv inc [1 2 3 4])", "(mapv + [1 2 3 4] [10 20 30 40])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncList lists = FunctionsUtil.removeNilValues(args.rest());
            ArrayList result = new ArrayList();
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                ArrayList<VncVal> fnArgs = new ArrayList<VncVal>();
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncSequence nthList = Coerce.toVncSequence(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.add(nthList.nth(index));
                }
                if (!hasMore) continue;
                result.add(fn.apply(new VncList(fnArgs)));
                ++index;
            }
            return new VncVector(result);
        }
    };
    public static VncFunction keep = new VncFunction("keep", VncFunction.meta().module("core").arglists("(keep f coll)").doc("Returns a sequence of the non-nil results of (f item). Note, this means false return values will be included. f must be free of side-effects.").examples("(keep even? (range 1 4))", "(keep (fn [x] (if (odd? x) x)) (range 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keep", args, 2);
            VncVal result = (VncVal)map.apply(args);
            return result == Constants.Nil ? Constants.Nil : FunctionsUtil.removeNilValues(Coerce.toVncList(result));
        }
    };
    public static VncFunction docoll = new VncFunction("docoll", VncFunction.meta().module("core").arglists("(docoll f coll)").doc("Applies f to the items of the collection presumably for side effects. Returns nil. ").examples("(docoll #(println %) [1 2 3 4])", "(docoll \n    (fn [[k v]] (println (pr-str k v)))  \n    {:a 1 :b 2 :c 3 :d 4})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("docoll", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncVal coll = args.second();
            if (coll != Constants.Nil) {
                if (Types.isVncSequence(coll)) {
                    ((VncSequence)coll).forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(VncList.of(v));
                    });
                } else if (Types.isVncMap(coll)) {
                    ((VncMap)coll).entries().forEach(v -> {
                        VncVal cfr_ignored_0 = (VncVal)fn.apply(VncList.of(VncVector.of(v.getKey(), v.getValue())));
                    });
                } else {
                    throw new VncException(String.format("docoll: collection type %s not supported", Types.getType(coll)));
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction mapcat = new VncFunction("mapcat", VncFunction.meta().module("core").arglists("(mapcat fn & colls)").doc("Returns the result of applying concat to the result of applying map to fn and colls. Thus function fn should return a collection.").examples("(mapcat reverse [[3 2 1 0] [6 5 4] [9 8 7]])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return (VncVal)concat.apply(Coerce.toVncList((VncVal)map.apply(args)));
        }
    };
    public static VncFunction map_invert = new VncFunction("map-invert", VncFunction.meta().module("core").arglists("(map-invert m)").doc("Returns the map with the vals mapped to the keys.").examples("(map-invert {:a 1 :b 2 :c 3})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("map-invert", args, 1);
            VncMap m = Coerce.toVncMap(args.first());
            HashMap<VncVal, VncVal> inverted = new HashMap<VncVal, VncVal>();
            for (VncMapEntry e : m.entries()) {
                inverted.put(e.getValue(), e.getKey());
            }
            return m.withValues(inverted, m.getMeta());
        }
    };
    public static VncFunction filter = new VncFunction("filter", VncFunction.meta().module("core").arglists("(filter predicate coll)").doc("Returns a collection of the items in coll for which (predicate item) returns logical true. ").examples("(filter even? [1 2 3 4 5 6 7])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("filter", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(VncList.of(val));
                if (keep == Constants.False || keep == Constants.Nil) continue;
                items.add(val);
            }
            return coll.withValues(items);
        }
    };
    public static VncFunction remove = new VncFunction("remove", VncFunction.meta().module("core").arglists("(remove predicate coll)").doc("Returns a collection of the items in coll for which (predicate item) returns logical false. ").examples("(remove even? [1 2 3 4 5 6 7])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("remove", args, 2);
            VncFunction predicate = Coerce.toVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = (VncVal)predicate.apply(VncList.of(val));
                if (keep != Constants.False) continue;
                items.add(val);
            }
            return coll.withValues(items);
        }
    };
    public static VncFunction reduce = new VncFunction("reduce", VncFunction.meta().module("core").arglists("(reduce f coll)", "(reduce f val coll)").doc("f should be a function of 2 arguments. If val is not supplied, returns the result of applying f to the first 2 items in coll, then applying f to that result and the 3rd item, etc. If coll contains no items, f must accept no arguments as well, and reduce returns the result of calling f with no arguments.  If coll has only 1 item, it is returned and f is not called.  If val is supplied, returns the result of applying f to val and the first item in coll, then applying f to that result and the 2nd item, etc. If coll contains no items, returns val and f is not called.").examples("(reduce (fn [x y] (+ x y)) [1 2 3 4 5 6 7])", "(reduce (fn [x y] (+ x y)) 10 [1 2 3 4 5 6 7])", "((reduce comp [(partial + 1) (partial * 2) (partial + 3)]) 100)", "(reduce (fn [m [k v]] (assoc m v k)) {} {:b 2 :a 1 :c 3})", "(reduce (fn [m c] (assoc m (first c) c)) {} [[:a 1] [:b 2] [:c 3]])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            List<VncVal> coll;
            FunctionsUtil.assertArity("reduce", args, 2, 3);
            boolean twoArguments = args.size() < 3;
            VncFunction reduceFn = Coerce.toVncFunction(args.first());
            if (twoArguments) {
                List<VncVal> coll2;
                if (Types.isVncSequence(args.second())) {
                    coll2 = Coerce.toVncSequence(args.second()).getList();
                } else if (Types.isVncMap(args.second())) {
                    coll2 = Coerce.toVncMap(args.second()).toVncList().getList();
                } else {
                    throw new VncException(String.format("Function 'reduce' does not allow %s as coll parameter", Types.getType(args.second())));
                }
                if (coll2.isEmpty()) {
                    return (VncVal)reduceFn.apply(new VncList());
                }
                VncVal value = coll2.get(0);
                for (int ii = 1; ii < coll2.size(); ++ii) {
                    value = (VncVal)reduceFn.apply(VncList.of(value, coll2.get(ii)));
                }
                return value;
            }
            if (Types.isVncSequence(args.nth(2))) {
                coll = Coerce.toVncSequence(args.nth(2)).getList();
            } else if (Types.isVncMap(args.nth(2))) {
                coll = Coerce.toVncMap(args.nth(2)).toVncList().getList();
            } else {
                throw new VncException(String.format("Function 'reduce' does not allow %s as coll parameter", Types.getType(args.nth(2))));
            }
            if (coll.isEmpty()) {
                return args.second();
            }
            if (coll.size() == 1) {
                return (VncVal)reduceFn.apply(VncList.of(args.second(), coll.get(0)));
            }
            VncVal value = args.second();
            for (int ii = 0; ii < coll.size(); ++ii) {
                value = (VncVal)reduceFn.apply(VncList.of(value, coll.get(ii)));
            }
            return value;
        }
    };
    public static VncFunction reduce_kv = new VncFunction("reduce-kv", VncFunction.meta().module("core").arglists("(reduce-kv f init coll))").doc("Reduces an associative collection. f should be a function of 3 arguments. Returns the result of applying f to init, the first key and the first value in coll, then applying f to that result and the 2nd key and value, etc. If coll contains no entries, returns init and f is not called. Note that reduce-kv is supported on vectors, where the keys will be the ordinals.").examples("(reduce-kv (fn [x y z] (assoc x z y)) {} {:a 1 :b 2 :c 3})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reduce-kv", args, 3);
            VncFunction reduceFn = Coerce.toVncFunction(args.first());
            List<VncMapEntry> values = Coerce.toVncHashMap(args.nth(2)).entries();
            VncMap value = (VncMap)args.second();
            if (values.isEmpty()) {
                return value;
            }
            for (VncMapEntry entry : values) {
                VncVal key = entry.getKey();
                VncVal val = entry.getValue();
                value = Coerce.toVncMap((VncVal)reduceFn.apply(VncList.of(value, key, val)));
            }
            return value;
        }
    };
    public static VncFunction merge = new VncFunction("merge", VncFunction.meta().module("core").arglists("(merge & maps)").doc("Returns a map that consists of the rest of the maps conj-ed onto the first.  If a key occurs in more than one map, the mapping from the latter (left-to-right) will be the mapping in the result.").examples("(merge {:a 1 :b 2 :c 3} {:b 9 :d 4})", "(merge {:a 1} nil)", "(merge nil {:a 1})", "(merge nil nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("merge", args, 1);
            List maps = args.stream().filter(v -> v != Constants.Nil).collect(Collectors.toList());
            if (maps.isEmpty()) {
                return Constants.Nil;
            }
            HashMap map = new HashMap();
            maps.stream().forEach(v -> map.putAll(Coerce.toVncMap(v).getMap()));
            return new VncHashMap(map);
        }
    };
    public static VncFunction conj = new VncFunction("conj", VncFunction.meta().module("core").arglists("(conj coll x)", "(conj coll x & xs)").doc("Returns a new collection with the x, xs 'added'. (conj nil item) returns (item).  The 'addition' may happen at different 'places' depending on the concrete type.").examples("(conj [1 2 3] 4)", "(conj '(1 2 3) 4)", "(conj (set 1 2 3) 4)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("conj", args, 2);
            VncVal coll = args.first();
            if (Types.isVncVector(coll)) {
                return ((VncVector)coll).addAllAtEnd(args.rest());
            }
            if (Types.isVncList(coll)) {
                return ((VncList)coll).addAllAtStart(args.rest());
            }
            if (Types.isVncSet(coll)) {
                return ((VncSet)coll).addAll(args.rest());
            }
            if (Types.isVncMap(coll)) {
                VncMap map = (VncMap)coll;
                VncVal second = args.second();
                if (Types.isVncVector(second) && ((VncVector)second).size() == 2) {
                    return map.assoc(VncList.of(((VncVector)second).first(), ((VncVector)second).second()));
                }
                if (Types.isVncMap(second)) {
                    return map.putAll((VncMap)second);
                }
                throw new VncException(String.format("Invalid x %s while calling function 'conj'", Types.getType(args.second())));
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'conj'", Types.getType(coll)));
        }
    };
    public static VncFunction disj = new VncFunction("disj", VncFunction.meta().module("core").arglists("(disj coll x)", "(disj coll x & xs)").doc("Returns a new set with the x, xs removed.").examples("(disj (set 1 2 3) 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("disj", args, 2);
            if (args.first() instanceof VncHashSet) {
                return ((VncHashSet)args.first()).removeAll(args.rest());
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'disj'", Types.getType(args.first())));
        }
    };
    public static VncFunction seq = new VncFunction("seq", VncFunction.meta().module("core").arglists("(seq coll)").doc("Returns a seq on the collection. If the collection is empty, returns nil. (seq nil) returns nil. seq also works on Strings.").examples("(seq nil)", "(seq [1 2 3])", "(seq '(1 2 3))", "(seq {:a 1 :b 2})", "(seq \"abcd\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("seq", args, 1);
            VncVal val = args.first();
            if (Types.isVncMap(val)) {
                if (((VncMap)val).isEmpty()) {
                    return Constants.Nil;
                }
                return new VncList(((VncMap)val).entries().stream().map(e -> VncVector.of(e.getKey(), e.getValue())).collect(Collectors.toList()));
            }
            if (Types.isVncVector(val)) {
                return ((VncVector)val).isEmpty() ? Constants.Nil : ((VncVector)val).toVncList();
            }
            if (Types.isVncList(val)) {
                return ((VncList)val).isEmpty() ? Constants.Nil : val;
            }
            if (Types.isVncString(val)) {
                String s = ((VncString)val).getValue();
                if (s.length() == 0) {
                    return Constants.Nil;
                }
                ArrayList<VncString> lst = new ArrayList<VncString>();
                for (char c : s.toCharArray()) {
                    lst.add(new VncString(String.valueOf(c)));
                }
                return new VncList(lst);
            }
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            throw new VncException("seq: called on non-sequence");
        }
    };
    public static VncFunction repeat = new VncFunction("repeat", VncFunction.meta().module("core").arglists("(repeat n x)").doc("Returns a collection with the value x repeated n times").examples("(repeat 5 [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("repeat", args, 2);
            long repeat = Coerce.toVncLong(args.first()).getValue();
            if (repeat < 0L) {
                throw new VncException("repeat: a count n must be grater or equal to 0");
            }
            VncVal val = args.second();
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(val);
                ++ii;
            }
            return new VncList(values);
        }
    };
    public static VncFunction repeatedly = new VncFunction("repeatedly", VncFunction.meta().module("core").arglists("(repeatedly n fn)").doc("Takes a function of no args, presumably with side effects, and returns a collection of n calls to it").examples("(repeatedly 5 #(rand-long 11))", ";; compare with repeat, which only calls the 'rand-long'\n;; function once, repeating the value five times. \n(repeat 5 (rand-long 11))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("repeatedly", args, 2);
            long repeat = Coerce.toVncLong(args.first()).getValue();
            VncFunction fn = Coerce.toVncFunction(args.second());
            if (repeat < 0L) {
                throw new VncException("repeatedly: a count n must be grater or equal to 0");
            }
            ArrayList values = new ArrayList();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(fn.apply(new VncList()));
                ++ii;
            }
            return new VncList(values);
        }
    };
    public static VncFunction meta = new VncFunction("meta", VncFunction.meta().module("core").arglists("(meta obj)").doc("Returns the metadata of obj, returns nil if there is no metadata.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("meta", args, 1);
            return args.first().getMeta();
        }
    };
    public static VncFunction with_meta = new VncFunction("with-meta", VncFunction.meta().module("core").arglists("(with-meta obj m)").doc("Returns a copy of the object obj, with a map m as its metadata.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("meta", args, 2);
            return args.first().withMeta(Coerce.toVncMap(args.second()));
        }
    };
    public static VncFunction vary_meta = new VncFunction("vary-meta", VncFunction.meta().module("core").arglists("(vary-meta obj f & args)").doc("Returns a copy of the object obj, with (apply f (meta obj) args) as its metadata.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("vary-meta", args, 2);
            VncVal obj = args.first();
            VncVal meta = obj.getMeta();
            VncFunction fn = Coerce.toVncFunction(args.second());
            VncList fnArgs = args.slice(2).addAtStart(meta == Constants.Nil ? new VncHashMap() : meta);
            return obj.withMeta((VncVal)fn.apply(fnArgs));
        }
    };
    public static VncFunction gensym = new VncFunction("gensym", VncFunction.meta().module("core").arglists("(gensym)", "(gensym prefix)").doc("Generates a symbol.").examples("(gensym )", "(gensym \"prefix_\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("gensym", args, 0, 1);
            String prefix = args.isEmpty() ? "G__" : (Types.isVncSymbol(args.first()) ? Coerce.toVncSymbol(args.first()).getName() : Coerce.toVncString(args.first()).getValue());
            return new VncSymbol(prefix + String.valueOf(gensymValue.incrementAndGet()));
        }
    };
    public static VncFunction name = new VncFunction("name", VncFunction.meta().module("core").arglists("(name x)").doc("Returns the name String of a string, symbol, keyword, or function/macro.").examples("(name :x)", "(name 'x)", "(name \"x\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("name", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncKeyword(arg)) {
                return new VncString(((VncKeyword)arg).getValue());
            }
            if (Types.isVncSymbol(arg)) {
                return new VncString(((VncSymbol)arg).getName());
            }
            if (Types.isVncString(arg)) {
                return arg;
            }
            if (Types.isVncFunction(arg)) {
                return new VncString(((VncFunction)arg).getName());
            }
            throw new VncException(String.format("Function 'name' does not allow %s as parameter", Types.getType(arg)));
        }
    };
    public static VncFunction module = new VncFunction("module", VncFunction.meta().module("module").arglists("(module fn)").doc("Returns the module a function/macro has been defined in.").examples("(module +)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("module", args, 1);
            VncVal arg = args.first();
            if (Types.isVncFunction(arg)) {
                return new VncString(((VncFunction)arg).getModule());
            }
            throw new VncException(String.format("Function 'module' does not allow %s as parameter", Types.getType(arg)));
        }
    };
    public static VncFunction type = new VncFunction("type", VncFunction.meta().module("core").arglists("(type x)").doc("Returns the type of x.").examples("(type 5)", "(type [1 2])", "(type (. :java.math.BigInteger :valueOf 100))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("type", args, 1);
            return Types.getType(args.first());
        }
    };
    public static VncFunction java_obj_Q = new VncFunction("java-obj?", VncFunction.meta().module("core").arglists("(java-obj? obj)").doc("Returns true if obj is a Java object").examples("(java-obj? (. :java.math.BigInteger :new \"0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-obj?", args, 1);
            return Types.isVncJavaObject(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction java_enumeration_to_list = new VncFunction("java-enumeration-to-list", VncFunction.meta().module("core").arglists("(java-enumeration-to-list e)").doc("Converts a Java enumeration to a list").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-enumeration-to-list", args, 1);
            if (Types.isVncJavaObject(args.first(), Enumeration.class)) {
                Enumeration e = (Enumeration)Coerce.toVncJavaObject(args.first()).getDelegate();
                List list = StreamUtil.stream(e).map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
                return new VncList(list);
            }
            throw new VncException(String.format("Function 'java-enumeration-to-list' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction java_iterator_to_list = new VncFunction("java-iterator-to-list", VncFunction.meta().module("core").arglists("(java-iterator-to-list e)").doc("Converts a Java iterator to a list").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-iterator-to-list", args, 1);
            if (Types.isVncJavaObject(args.first(), Iterator.class)) {
                Iterator i = (Iterator)Coerce.toVncJavaObject(args.first()).getDelegate();
                List list = StreamUtil.stream(i).map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
                return new VncList(list);
            }
            throw new VncException(String.format("Function 'java-iterator-to-list' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction java_wrap = new VncFunction("java-wrap", VncFunction.meta().module("core").arglists("(java-wrap val)").doc("Wraps a venice value").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-wrap", args, 1);
            VncVal arg = args.first();
            return arg instanceof VncTunnelAsJavaObject ? arg : new VncTunnelAsJavaObject(arg);
        }
    };
    public static VncFunction java_unwrap = new VncFunction("java-unwrap", VncFunction.meta().module("core").arglists("(java-unwrap val)").doc("Unwraps a venice value").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-unwrap", args, 1);
            VncVal arg = args.first();
            return arg instanceof VncTunnelAsJavaObject ? ((VncTunnelAsJavaObject)arg).getDelegate() : arg;
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("throw", (VncVal)throw_ex).put("nil?", (VncVal)nil_Q).put("some?", (VncVal)some_Q).put("true?", (VncVal)true_Q).put("false?", (VncVal)false_Q).put("boolean?", (VncVal)boolean_Q).put("int?", (VncVal)int_Q).put("long?", (VncVal)long_Q).put("double?", (VncVal)double_Q).put("decimal?", (VncVal)decimal_Q).put("number?", (VncVal)number_Q).put("bytebuf?", (VncVal)bytebuf_Q).put("string?", (VncVal)string_Q).put("symbol", (VncVal)symbol).put("symbol?", (VncVal)symbol_Q).put("keyword", (VncVal)keyword).put("keyword?", (VncVal)keyword_Q).put("fn?", (VncVal)fn_Q).put("macro?", (VncVal)macro_Q).put("pr-str", (VncVal)pr_str).put("str", (VncVal)str).put("readline", (VncVal)readline).put("read-string", (VncVal)read_string).put("==", (VncVal)equal_Q).put("!=", (VncVal)not_equal_Q).put("<", (VncVal)lt).put("<=", (VncVal)lte).put(">", (VncVal)gt).put(">=", (VncVal)gte).put("match?", (VncVal)match_Q).put("not-match?", (VncVal)not_match_Q).put("match", (VncVal)match_Q).put("match-not", (VncVal)not_match_Q).put("boolean", (VncVal)boolean_cast).put("int", (VncVal)int_cast).put("long", (VncVal)long_cast).put("double", (VncVal)double_cast).put("decimal", (VncVal)decimal_cast).put("bytebuf", (VncVal)bytebuf_cast).put("bytebuf-to-string", (VncVal)bytebuf_to_string).put("bytebuf-from-string", (VncVal)bytebuf_from_string).put("list", (VncVal)new_list).put("list*", (VncVal)new_list_ASTERISK).put("list?", (VncVal)list_Q).put("vector", (VncVal)new_vector).put("vector?", (VncVal)vector_Q).put("map?", (VncVal)map_Q).put("hash-map?", (VncVal)hash_map_Q).put("ordered-map?", (VncVal)ordered_map_Q).put("sorted-map?", (VncVal)sorted_map_Q).put("mutable-map?", (VncVal)mutable_map_Q).put("stack?", (VncVal)stack_Q).put("queue?", (VncVal)queue_Q).put("hash-map", (VncVal)new_hash_map).put("ordered-map", (VncVal)new_ordered_map).put("sorted-map", (VncVal)new_sorted_map).put("mutable-map", (VncVal)new_mutable_map).put("stack", (VncVal)new_stack).put("queue", (VncVal)new_queue).put("assoc", (VncVal)assoc).put("assoc!", (VncVal)assoc_BANG).put("assoc-in", (VncVal)assoc_in).put("dissoc", (VncVal)dissoc).put("dissoc!", (VncVal)dissoc_BANG).put("contains?", (VncVal)contains_Q).put("find", (VncVal)find).put("get", (VncVal)get).put("get-in", (VncVal)get_in).put("key", (VncVal)key).put("keys", (VncVal)keys).put("val", (VncVal)val).put("vals", (VncVal)vals).put("update", (VncVal)update).put("update!", (VncVal)update_BANG).put("subvec", (VncVal)subvec).put("bytebuf-sub", (VncVal)bytebuf_sub).put("empty", (VncVal)empty).put("set?", (VncVal)set_Q).put("sorted-set?", (VncVal)sorted_set_Q).put("set", (VncVal)new_set).put("sorted-set", (VncVal)new_sorted_set).put("difference", (VncVal)difference).put("union", (VncVal)union).put("intersection", (VncVal)intersection).put("split-at", (VncVal)split_at).put("split-with", (VncVal)split_with).put("into", (VncVal)into).put("sequential?", (VncVal)sequential_Q).put("coll?", (VncVal)coll_Q).put("cons", (VncVal)cons).put("co", (VncVal)cons).put("concat", (VncVal)concat).put("interpose", (VncVal)interpose).put("interleave", (VncVal)interleave).put("mapcat", (VncVal)mapcat).put("map-invert", (VncVal)map_invert).put("keep", (VncVal)keep).put("docoll", (VncVal)docoll).put("nth", (VncVal)nth).put("first", (VncVal)first).put("second", (VncVal)second).put("third", (VncVal)third).put("last", (VncVal)last).put("rest", (VncVal)rest).put("butlast", (VncVal)butlast).put("nfirst", (VncVal)nfirst).put("nlast", (VncVal)nlast).put("empty-to-nil", (VncVal)emptyToNil).put("pop", (VncVal)pop).put("pop!", (VncVal)pop_BANG).put("push!", (VncVal)push_BANG).put("poll!", (VncVal)poll_BANG).put("offer!", (VncVal)offer_BANG).put("peek", (VncVal)peek).put("empty?", (VncVal)empty_Q).put("not-empty?", (VncVal)not_empty_Q).put("every?", (VncVal)every_Q).put("not-every?", (VncVal)not_every_Q).put("any?", (VncVal)any_Q).put("not-any?", (VncVal)not_any_Q).put("count", (VncVal)count).put("compare", (VncVal)compare).put("apply", (VncVal)apply).put("comp", (VncVal)comp).put("partial", (VncVal)partial).put("map", (VncVal)map).put("mapv", (VncVal)mapv).put("filter", (VncVal)filter).put("distinct", (VncVal)distinct).put("dedupe", (VncVal)dedupe).put("partition", (VncVal)partition).put("remove", (VncVal)remove).put("reduce", (VncVal)reduce).put("reduce-kv", (VncVal)reduce_kv).put("take", (VncVal)take).put("take-while", (VncVal)take_while).put("drop", (VncVal)drop).put("drop-while", (VncVal)drop_while).put("flatten", (VncVal)flatten).put("reverse", (VncVal)reverse).put("replace", (VncVal)replace).put("group-by", (VncVal)group_by).put("sort", (VncVal)sort).put("sort-by", (VncVal)sort_by).put("some", (VncVal)some).put("merge", (VncVal)merge).put("conj", (VncVal)conj).put("disj", (VncVal)disj).put("seq", (VncVal)seq).put("repeat", (VncVal)repeat).put("repeatedly", (VncVal)repeatedly).put("meta", (VncVal)meta).put("with-meta", (VncVal)with_meta).put("vary-meta", (VncVal)vary_meta).put("coalesce", (VncVal)coalesce).put("gensym", (VncVal)gensym).put("name", (VncVal)name).put("module", (VncVal)module).put("type", (VncVal)type).put("instance?", (VncVal)instance_Q).put("java-obj?", (VncVal)java_obj_Q).put("java-iterator-to-list", (VncVal)java_iterator_to_list).put("java-enumeration-to-list", (VncVal)java_enumeration_to_list).put("java-wrap", (VncVal)java_wrap).put("java-unwrap", (VncVal)java_unwrap).toMap();
    private static final AtomicLong gensymValue = new AtomicLong(0L);

    public static boolean list_Q(VncVal mv) {
        return Types.isVncList(mv);
    }

    public static boolean vector_Q(VncVal mv) {
        return Types.isVncVector(mv);
    }

    private static void flatten(VncVal value, List<VncVal> result) {
        if (Types.isVncSequence(value)) {
            Coerce.toVncSequence(value).forEach(v -> CoreFunctions.flatten(v, result));
        } else if (Types.isVncMap(value)) {
            ((VncMap)value).entries().forEach(e -> {
                result.add(e.getKey());
                CoreFunctions.flatten(e.getValue(), result);
            });
        } else {
            result.add(value);
        }
    }

    private static VncVal sort(String fnName, VncVal fnArgs, VncVal coll, Comparator<VncVal> c) {
        if (Types.isVncVector(coll)) {
            return new VncVector(((VncVector)coll).getList().stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncSequence(coll)) {
            return new VncList(((VncSequence)coll).getList().stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncSet(coll)) {
            return new VncList(((VncSet)coll).getList().stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncMap(coll)) {
            return new VncList(((VncMap)coll).toVncList().getList().stream().sorted(c).collect(Collectors.toList()));
        }
        throw new VncException(String.format("%s: collection type %s not supported", fnName, Types.getType(coll)));
    }

    private static String encoding(VncVal enc) {
        return enc == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(enc) ? Coerce.toVncKeyword(enc).getValue() : Coerce.toVncString(enc).getValue());
    }
}

