/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.MathOp;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;

public class MathFunctions {
    public static VncFunction add = new VncFunction("+", VncFunction.meta().module("core").arglists("(+)", "(+ x)", "(+ x y)", "(+ x y & more)").doc("Returns the sum of the numbers. (+) returns 0.").examples("(+)", "(+ 1)", "(+ 1 2)", "(+ 1 2 3 4)", "(+ (int 1) (int 2))", "(+ 1 2.5)", "(+ 1 2.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    return new VncLong(0);
                }
                case 1: {
                    return args.first();
                }
                case 2: {
                    return Numeric.calc(MathOp.ADD, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.ADD, val, v);
            }
            return val;
        }
    };
    public static VncFunction subtract = new VncFunction("-", VncFunction.meta().module("core").arglists("(- x)", "(- x y)", "(- x y & more)").doc("If one number is supplied, returns the negation, else subtracts the numbers from x and returns the result.").examples("(- 4)", "(- 8 3 -2 -1)", "(- (int 5) (int 2))", "(- 8 2.5)", "(- 8 1.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    throw new ArityException(0, "-");
                }
                case 1: {
                    VncVal first = args.first();
                    if (Types.isVncLong(first)) {
                        return new VncLong(((VncLong)first).getValue() * -1L);
                    }
                    if (Types.isVncInteger(first)) {
                        return new VncInteger(((VncInteger)first).getValue() * -1);
                    }
                    if (Types.isVncDouble(first)) {
                        return new VncDouble(((VncDouble)first).getValue() * -1.0);
                    }
                    if (Types.isVncBigDecimal(first)) {
                        return new VncBigDecimal(((VncBigDecimal)first).getValue().negate());
                    }
                    return first;
                }
                case 2: {
                    return Numeric.calc(MathOp.SUB, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.SUB, val, v);
            }
            return val;
        }
    };
    public static VncFunction multiply = new VncFunction("*", VncFunction.meta().module("core").arglists("(*)", "(* x)", "(* x y)", "(* x y & more)").doc("Returns the product of numbers. (*) returns 1").examples("(*)", "(* 4)", "(* 4 3)", "(* 4 3 2)", "(* (int 4) (int 3))", "(* 6.0 2)", "(* 6 1.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    return new VncLong(1);
                }
                case 1: {
                    return args.first();
                }
                case 2: {
                    return Numeric.calc(MathOp.MUL, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.MUL, val, v);
            }
            return val;
        }
    };
    public static VncFunction divide = new VncFunction("/", VncFunction.meta().module("core").arglists("(/ x)", "(/ x y)", "(/ x y & more)").doc("If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators.").examples("(/ 2.0)", "(/ 12 2 3)", "(/ 12 3)", "(/ (int 12) (int 3))", "(/ 6.0 2)", "(/ 6 1.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    throw new ArityException(0, "/");
                }
                case 1: {
                    VncVal first = args.first();
                    if (Types.isVncLong(first)) {
                        return Numeric.calc(MathOp.DIV, new VncLong(1L), first);
                    }
                    if (Types.isVncInteger(first)) {
                        return Numeric.calc(MathOp.DIV, new VncInteger(1), first);
                    }
                    if (Types.isVncDouble(first)) {
                        return Numeric.calc(MathOp.DIV, new VncDouble(1.0), first);
                    }
                    if (Types.isVncBigDecimal(first)) {
                        return Numeric.calc(MathOp.DIV, new VncBigDecimal(BigDecimal.ONE), first);
                    }
                    return first;
                }
                case 2: {
                    return Numeric.calc(MathOp.DIV, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.DIV, val, v);
            }
            return val;
        }
    };
    public static VncFunction modulo = new VncFunction("mod", VncFunction.meta().module("core").arglists("(mod n d)").doc("Modulus of n and d.").examples("(mod 10 4)", "(mod (int 10) (int 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("mod", args, 2);
            VncVal n = args.first();
            VncVal d = args.second();
            if (Types.isVncLong(n)) {
                if (Types.isVncLong(d)) {
                    return new VncLong(((VncLong)n).getValue() % ((VncLong)d).getValue());
                }
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator if nominator is a long", Types.getType(args.second())));
            }
            if (Types.isVncInteger(n)) {
                if (Types.isVncInteger(d)) {
                    return new VncInteger(((VncInteger)n).getValue() % ((VncInteger)d).getValue());
                }
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator if nominator is an int", Types.getType(args.second())));
            }
            throw new VncException(String.format("Function 'mod' does not allow %s as numerator", Types.getType(args.first())));
        }
    };
    public static VncFunction inc = new VncFunction("inc", VncFunction.meta().module("core").arglists("(inc x)").doc("Increments the number x").examples("(inc 10)", "(inc (int 10))", "(inc 10.1)", "(inc 10.12M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("inc", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(((VncLong)arg).getValue() + 1L);
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(((VncInteger)arg).getValue() + 1);
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() + 1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().add(new BigDecimal(1)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'inc'", Types.getType(arg)));
        }
    };
    public static VncFunction dec = new VncFunction("dec", VncFunction.meta().module("core").arglists("(dec x)").doc("Decrements the number x").examples("(dec 10)", "(dec (int 10))", "(dec 10.1)", "(dec 10.12M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(((VncLong)arg).getValue() - 1L);
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(((VncInteger)arg).getValue() - 1);
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() - 1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().subtract(new BigDecimal(1)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'dec'", Types.getType(arg)));
        }
    };
    public static VncFunction max = new VncFunction("max", VncFunction.meta().module("core").arglists("(max x)", "(max x y)", "(max x y & more)").doc("Returns the greatest of the values").examples("(max 1)", "(max 1 2)", "(max 4 3 2 1)", "(max (int 1) (int 2))", "(max 1.0)", "(max 1.0 2.0)", "(max 4.0 3.0 2.0 1.0)", "(max 1.0M)", "(max 1.0M 2.0M)", "(max 4.0M 3.0M 2.0M 1.0M)", "(max 1.0M 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(0, "max");
            }
            VncVal max = op1 = args.first();
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncNumber(op)) {
                    max = op.compareTo(max) > 0 ? op : max;
                    continue;
                }
                throw new VncException(String.format("Function 'max' does not allow %s as operand", Types.getType(max)));
            }
            return max;
        }
    };
    public static VncFunction min = new VncFunction("min", VncFunction.meta().module("core").arglists("(min x)", "(min x y)", "(min x y & more)").doc("Returns the smallest of the values").examples("(min 1)", "(min 1 2)", "(min 4 3 2 1)", "(min (int 1) (int 2))", "(min 1.0)", "(min 1.0 2.0)", "(min 4.0 3.0 2.0 1.0)", "(min 1.0M)", "(min 1.0M 2.0M)", "(min 4.0M 3.0M 2.0M 1.0M)", "(min 1.0M 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(0, "min");
            }
            VncVal min = op1 = args.first();
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncNumber(op)) {
                    min = op.compareTo(min) < 0 ? op : min;
                    continue;
                }
                throw new VncException(String.format("Function 'min' does not allow %s as operand", Types.getType(min)));
            }
            return min;
        }
    };
    public static VncFunction abs = new VncFunction("abs", VncFunction.meta().module("core").arglists("(abs x)").doc("Returns the absolute value of the number").examples("(abs 10)", "(abs -10)", "(abs (int -10))", "(abs -10.1)", "(abs -10.12M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("abs", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.abs(((VncLong)arg).getValue()));
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(Math.abs(((VncInteger)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.abs(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().abs());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'abs'", Types.getType(arg)));
        }
    };
    public static VncFunction negate = new VncFunction("negate", VncFunction.meta().module("core").arglists("(negate x)").doc("Negates x").examples("(negate 10)", "(negate (int 10))", "(negate 1.23)", "(negate 1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("negate", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.negateExact(((VncLong)arg).getValue()));
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(Math.negateExact(((VncInteger)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() * -1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(Coerce.toVncBigDecimal(args.first()).getValue().negate());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'negate'", Types.getType(arg)));
        }
    };
    public static VncFunction sqrt = new VncFunction("sqrt", VncFunction.meta().module("core").arglists("(sqrt x)").doc("Square root of x").examples("(sqrt 10)", "(sqrt (int 10))", "(sqrt 10.23)", "(sqrt 10.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sqrt", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncDouble(Math.sqrt(((VncLong)arg).getValue().doubleValue()));
            }
            if (Types.isVncInteger(arg)) {
                return new VncDouble(Math.sqrt(((VncInteger)arg).getValue().doubleValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.sqrt(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(new BigDecimal(Math.sqrt(Coerce.toVncBigDecimal(args.first()).getValue().doubleValue())));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'sqrt'", Types.getType(arg)));
        }
    };
    public static VncFunction rand_long = new VncFunction("rand-long", VncFunction.meta().module("core").arglists("(rand-long)", "(rand-long max)").doc("Without argument returns a random long between 0 and MAX_LONG. With argument max returns a random long between 0 and max exclusive.\nThis function is based on a cryptographically strong random number generator (RNG).").examples("(rand-long)", "(rand-long 100)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-long", args, 0, 1);
            if (args.isEmpty()) {
                return new VncLong(Math.abs(random.nextLong()));
            }
            long max = Coerce.toVncLong(args.first()).getValue();
            if (max < 2L) {
                throw new VncException("Function 'rand-long' does not allow negative max values");
            }
            return new VncLong(Math.abs(random.nextLong()) % max);
        }
    };
    public static VncFunction rand_double = new VncFunction("rand-double", VncFunction.meta().module("core").arglists("(rand-double)", "(rand-double max)").doc("Without argument returns a double between 0.0 and 1.0. With argument max returns a random double between 0.0 and max.\nThis function is based on a cryptographically strong random number generator (RNG).").examples("(rand-double)", "(rand-double 100.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-double", args, 0, 1);
            if (args.isEmpty()) {
                return new VncDouble(random.nextDouble());
            }
            double max = Coerce.toVncDouble(args.first()).getValue();
            if (max < 0.0) {
                throw new VncException("Function 'rand-double' does not allow negative max values");
            }
            return new VncDouble(random.nextDouble() * max);
        }
    };
    public static VncFunction rand_gaussian = new VncFunction("rand-gaussian", VncFunction.meta().module("core").arglists("(rand-gaussian)", "(rand-gaussian mean stddev)").doc("Without argument returns a Gaussion distributed double value with mean 0.0 and standard deviation 1.0. With argument mean and stddev returns a Gaussion distributed double value with the given mean and standard deviation.\nThis function is based on a cryptographically strong random number generator (RNG)").examples("(rand-gaussian)", "(rand-gaussian 0.0 5.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-gaussian", args, 0, 2);
            if (args.isEmpty()) {
                return new VncDouble(random.nextGaussian());
            }
            double mean = Coerce.toVncDouble(args.first()).getValue();
            double stddev = Coerce.toVncDouble(args.second()).getValue();
            return new VncDouble(mean + stddev * random.nextGaussian());
        }
    };
    public static VncFunction zero_Q = new VncFunction("zero?", VncFunction.meta().module("core").arglists("(zero? x)").doc("Returns true if x zero else false").examples("(zero? 0)", "(zero? 2)", "(zero? (int 0))", "(zero? 0.0)", "(zero? 0.0M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("zero?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() == 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncInteger(op1)) {
                return ((VncInteger)op1).getValue() == 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() == 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) == 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'zero?' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction pos_Q = new VncFunction("pos?", VncFunction.meta().module("core").arglists("(pos? x)").doc("Returns true if x greater than zero else false").examples("(pos? 3)", "(pos? -3)", "(pos? (int 3))", "(pos? 3.2)", "(pos? 3.2M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pos?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() > 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncInteger(op1)) {
                return ((VncInteger)op1).getValue() > 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() > 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'pos?' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction neg_Q = new VncFunction("neg?", VncFunction.meta().module("core").arglists("(neg? x)").doc("Returns true if x smaller than zero else false").examples("(neg? -3)", "(neg? 3)", "(neg? (int -3))", "(neg? -3.2)", "(neg? -3.2M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("neg?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() < 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncInteger(op1)) {
                return ((VncInteger)op1).getValue() < 0 ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() < 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'neg?' does not allow %s as operand 1s", Types.getType(op1)));
        }
    };
    public static VncFunction even_Q = new VncFunction("even?", VncFunction.meta().module("core").arglists("(even? n)").doc("Returns true if n is even, throws an exception if n is not an integer").examples("(even? 4)", "(even? 3)", "(even? (int 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("even?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncInteger(op1)) {
                return ((VncInteger)op1).getValue() % 2 == 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'even?' does not allow %s as operand.", Types.getType(op1)));
        }
    };
    public static VncFunction odd_Q = new VncFunction("odd?", VncFunction.meta().module("core").arglists("(odd? n)").doc("Returns true if n is odd, throws an exception if n is not an integer").examples("(odd? 3)", "(odd? 4)", "(odd? (int 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("odd?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 1L ? Constants.True : Constants.False;
            }
            if (Types.isVncInteger(op1)) {
                return ((VncInteger)op1).getValue() % 2 == 1 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'odd?' does not allow %s as operand", Types.getType(op1)));
        }
    };
    public static VncFunction dec_add = new VncFunction("dec/add", VncFunction.meta().module("core").arglists("(dec/add x y scale rounding-mode)").doc("Adds two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/add 2.44697M 1.79882M 3 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/add", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().add(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_sub = new VncFunction("dec/sub", VncFunction.meta().module("core").arglists("(dec/sub x y scale rounding-mode)").doc("Subtract y from x and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/sub 2.44697M 1.79882M 3 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/sub", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().subtract(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_mul = new VncFunction("dec/mul", VncFunction.meta().module("core").arglists("(dec/mul x y scale rounding-mode)").doc("Multiplies two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/mul 2.44697M 1.79882M 5 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/mul", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().multiply(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_div = new VncFunction("dec/div", VncFunction.meta().module("core").arglists("(dec/div x y scale rounding-mode)").doc("Divides x by y and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/div 2.44697M 1.79882M 5 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/div", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().divide(op2.getValue(), scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_scale = new VncFunction("dec/scale", VncFunction.meta().module("core").arglists("(dec/scale x scale rounding-mode)").doc("Scales a decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/scale 2.44697M 0 :HALF_UP)", "(dec/scale 2.44697M 1 :HALF_UP)", "(dec/scale 2.44697M 2 :HALF_UP)", "(dec/scale 2.44697M 3 :HALF_UP)", "(dec/scale 2.44697M 10 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/scale", args, 3);
            VncVal arg = args.first();
            VncLong scale = Coerce.toVncLong(args.second());
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(val.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'dec/scale' does not allow %s as operand 1s", Types.getType(arg)));
        }
    };
    public static VncFunction range = new VncFunction("range", VncFunction.meta().module("core").arglists("(range end)", "(range start end)", "(range start end step)").doc("Returns a collection of numbers from start (inclusive) to end (exclusive), by step, where start defaults to 0 and step defaults to 1. When start is equal to end, returns empty list.").examples("(range 10)", "(range 10 20)", "(range 10 20 3)", "(range (int 10) (int 20))", "(range (int 10) (int 20) (int 3))", "(range 10 15 0.5)", "(range 1.1M 2.2M 0.1M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("range", args, 1, 2, 3);
            VncVal start = null;
            VncVal end = null;
            VncVal step = null;
            switch (args.size()) {
                case 1: {
                    start = new VncLong(0);
                    end = args.first();
                    step = new VncLong(1);
                    break;
                }
                case 2: {
                    start = args.first();
                    end = args.second();
                    step = Types.isVncInteger(start) ? new VncInteger(1) : new VncLong(1);
                    break;
                }
                case 3: {
                    start = args.first();
                    end = args.second();
                    step = args.nth(2);
                }
            }
            if (!Types.isVncNumber(start)) {
                throw new VncException("range: start value must be a number");
            }
            if (!Types.isVncNumber(end)) {
                throw new VncException("range: end value must be a number");
            }
            if (!Types.isVncNumber(step)) {
                throw new VncException("range: step value must be a number");
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            if (zero_Q.apply(VncList.of(step)) == Constants.True) {
                throw new VncException("range: a step value must not be 0");
            }
            if (pos_Q.apply(VncList.of(step)) == Constants.True) {
                if (CoreFunctions.lt.apply(VncList.of(end, start)) == Constants.True) {
                    throw new VncException("range positive step: end must not be lower than start");
                }
                VncVal val = start;
                while (CoreFunctions.lt.apply(VncList.of(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(VncList.of(val, step));
                }
            } else {
                if (CoreFunctions.gt.apply(VncList.of(end, start)) == Constants.True) {
                    throw new VncException("range negative step: end must not be greater than start");
                }
                VncVal val = start;
                while (CoreFunctions.gt.apply(VncList.of(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(VncList.of(val, step));
                }
            }
            return new VncList(values);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("+", (VncVal)add).put("-", (VncVal)subtract).put("*", (VncVal)multiply).put("/", (VncVal)divide).put("mod", (VncVal)modulo).put("inc", (VncVal)inc).put("dec", (VncVal)dec).put("abs", (VncVal)abs).put("min", (VncVal)min).put("max", (VncVal)max).put("negate", (VncVal)negate).put("sqrt", (VncVal)sqrt).put("dec/add", (VncVal)dec_add).put("dec/sub", (VncVal)dec_sub).put("dec/mul", (VncVal)dec_mul).put("dec/div", (VncVal)dec_div).put("dec/scale", (VncVal)dec_scale).put("zero?", (VncVal)zero_Q).put("pos?", (VncVal)pos_Q).put("neg?", (VncVal)neg_Q).put("even?", (VncVal)even_Q).put("odd?", (VncVal)odd_Q).put("rand-long", (VncVal)rand_long).put("rand-double", (VncVal)rand_double).put("rand-gaussian", (VncVal)rand_gaussian).put("range", (VncVal)range).toMap();
    private static final SecureRandom random = new SecureRandom();
}

