/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Map;

public class ModuleFunctions {
    public static VncFunction loadCoreModule = new VncFunction("load-core-module", VncFunction.meta().module("core").arglists("(load-core-module name)").doc("Loads a Venice extension module.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("load-core-module", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String module = ModuleLoader.load(((VncString)args.first()).getValue());
                    return new VncString(module);
                }
                if (Types.isVncSymbol(name)) {
                    String module = ModuleLoader.load(((VncSymbol)args.first()).getName());
                    return new VncString(module);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction loadClasspathVenice = new VncFunction("load-classpath-venice", VncFunction.meta().module("core").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                FunctionsUtil.assertArity("load-classpath-venice", args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncString)args.first()).getValue());
                    return res == null ? Constants.Nil : new VncString(res);
                }
                if (Types.isVncKeyword(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncKeyword)args.first()).getValue());
                    return res == null ? Constants.Nil : new VncString(res);
                }
                if (Types.isVncSymbol(name)) {
                    String res = ModuleLoader.loadVeniceResource(((VncSymbol)args.first()).getName());
                    return res == null ? Constants.Nil : new VncString(res);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("load-core-module", (VncVal)loadCoreModule).put("load-classpath-venice", (VncVal)loadClasspathVenice).toMap();
}

