/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncTunnelAsJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ScheduleFunctions {
    public static VncFunction schedule_delay = new VncFunction("schedule-delay", VncFunction.meta().module("core").arglists("(schedule-delay fn delay time-unit)").doc("Creates and executes a one-shot action that becomes enabled after the given delay. \nReturns a future. (deref f), (future? f), (future-cancel f), and (future-done? f) will work on the returned future. \nTime unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(schedule-delay (fn[] (println \"test\")) 1 :seconds)", "(deref (schedule-delay (fn [] 100) 2 :seconds))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("schedule-delay", args, 3);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            VncLong delay = Coerce.toVncLong(args.second());
            VncKeyword unit = Coerce.toVncKeyword(args.third());
            VncFunction wrapped = new VncFunction(fn.getName(), fn.getMeta()){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    return new VncTunnelAsJavaObject((VncVal)fn.apply(args));
                }
            };
            Callable task = (Callable)DynamicInvocationHandler.proxify(ThreadLocalMap.getCallStack().peek(), Callable.class, VncHashMap.of(new VncKeyword("call"), wrapped));
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Callable<VncVal> taskWrapper = () -> {
                try {
                    ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    VncVal vncVal = (VncVal)task.call();
                    return vncVal;
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            ScheduledFuture<VncVal> future = ScheduleFunctions.getExecutor().schedule(taskWrapper, (long)delay.getValue(), ScheduleFunctions.toTimeUnit(unit));
            return new VncJavaObject(future);
        }
    };
    public static VncFunction schedule_at_fixed_rate = new VncFunction("schedule-at-fixed-rate", VncFunction.meta().module("core").arglists("(schedule-at-fixed-rate fn initial-delay period time-unit)").doc("Creates and executes a periodic action that becomes enabled first after the given initial delay, and subsequently with the given period. \nReturns a future. (future? f), (future-cancel f), and (future-done? f) will work on the returned future. \nTime unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(schedule-at-fixed-rate (fn[] (println \"test\")) 1 2 :seconds)", "(let [s (schedule-at-fixed-rate (fn[] (println \"test\")) 1 2 :seconds)] \n   (sleep 16 :seconds) \n   (future-cancel s))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("schedule-at-fixed-rate", args, 4);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            VncLong delay = Coerce.toVncLong(args.second());
            VncLong period = Coerce.toVncLong(args.third());
            VncKeyword unit = Coerce.toVncKeyword(args.nth(3));
            VncFunction wrapped = new VncFunction(fn.getName(), fn.getMeta()){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    return new VncTunnelAsJavaObject((VncVal)fn.apply(args));
                }
            };
            Runnable task = (Runnable)DynamicInvocationHandler.proxify(ThreadLocalMap.getCallStack().peek(), Runnable.class, VncHashMap.of(new VncKeyword("run"), wrapped));
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Runnable taskWrapper = () -> {
                try {
                    ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    task.run();
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            ScheduledFuture<?> future = ScheduleFunctions.getExecutor().scheduleAtFixedRate(taskWrapper, delay.getValue(), period.getValue(), ScheduleFunctions.toTimeUnit(unit));
            return new VncJavaObject(future);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("schedule-delay", (VncVal)schedule_delay).put("schedule-at-fixed-rate", (VncVal)schedule_at_fixed_rate).toMap();
    private static final AtomicLong threadPoolCounter = new AtomicLong(0L);
    private static ScheduledExecutorService executor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        AtomicLong atomicLong = threadPoolCounter;
        synchronized (atomicLong) {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownNow() {
        AtomicLong atomicLong = threadPoolCounter;
        synchronized (atomicLong) {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid scheduler time-unit " + unit.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScheduledExecutorService getExecutor() {
        AtomicLong atomicLong = threadPoolCounter;
        synchronized (atomicLong) {
            if (executor == null) {
                executor = ScheduleFunctions.createExecutor();
            }
            return executor;
        }
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(4, ThreadPoolUtil.createThreadFactory("venice-scheduler-pool-%d", threadPoolCounter, true));
    }
}

