/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class SystemFunctions {
    public static VncFunction version = new VncFunction("version", VncFunction.meta().module("core").arglists("(version)").doc("Returns the version.").examples("(version )").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("version", args, 0);
            return new VncString("1.5.11");
        }
    };
    public static VncFunction uuid = new VncFunction("uuid", VncFunction.meta().module("core").arglists("(uuid)").doc("Generates a UUID.").examples("(uuid )").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("uuid", args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static VncFunction objid = new VncFunction("oobjid", VncFunction.meta().module("core").arglists("(objid)").doc("Returns the original unique hash code for the given object.").examples("(objid x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("objid", args, 1);
            return new VncLong(System.identityHashCode(args.first()));
        }
    };
    public static VncFunction current_time_millis = new VncFunction("current-time-millis", VncFunction.meta().module("core").arglists("(current-time-millis)").doc("Returns the current time in milliseconds.").examples("(current-time-millis)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("current-time-millis", args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction nano_time = new VncFunction("nano-time", VncFunction.meta().module("core").arglists("(nano-time)").doc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.").examples("(nano-time)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("nano-time", args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction sleep = new VncFunction("sleep", VncFunction.meta().module("core").arglists("(sleep n)", "(sleep n time-unit)").doc("Sleep for the time n. The default time unit is milliseconds \nTime unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(sleep 30)", "(sleep 30 :milliseconds)", "(sleep 5 :seconds)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sleep", args, 1, 2);
            try {
                long sleep = Coerce.toVncLong(args.first()).getValue();
                TimeUnit unit = args.size() == 1 ? TimeUnit.MILLISECONDS : SystemFunctions.toTimeUnit(Coerce.toVncKeyword(args.second()));
                Thread.sleep(Math.max(0L, unit.toMillis(sleep)));
            }
            catch (java.lang.InterruptedException ex) {
                throw new InterruptedException("(sleep n) interrupted", ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction pid = new VncFunction("pid", VncFunction.meta().module("core").arglists("(pid)").doc("Returns the PID of this process.").examples("(pid)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pid", args, 0);
            return new VncString(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
    };
    public static VncFunction gc = new VncFunction("gc", VncFunction.meta().module("core").arglists("(gc)").doc("Run the Java garbage collector. Runs the finalization methods of any objects pending finalization prior to the GC.").examples("(gc)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("gc", args, 0);
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            return Constants.Nil;
        }
    };
    public static VncFunction shutdown_hook = new VncFunction("shutdown-hook", VncFunction.meta().module("core").arglists("(shutdown-hook f)").doc("Registers the function f as JVM shutdown hook.").examples("(shutdown-hook (fn [] (println \"shutdown\")))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("shutdown-hook", args, 1);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            final IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            final AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                        ThreadLocalMap.clearCallStack();
                        JavaInterop.register(parentInterceptor);
                        fn.apply(new VncList());
                    }
                    finally {
                        JavaInterop.unregister();
                        ThreadLocalMap.remove();
                    }
                }
            });
            return Constants.Nil;
        }
    };
    public static VncFunction callstack = new VncFunction("callstack", VncFunction.meta().module("core").arglists("(callstack )").doc("Returns the current callstack.").examples("(do                             \n   (defn f1 [x] (f2 x))         \n   (defn f2 [x] (f3 x))         \n   (defn f3 [x] (f4 x))         \n   (defn f4 [x] (callstack))    \n   (f1 100))                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("callstack", args, 0);
            CallStack stack = ThreadLocalMap.getCallStack();
            return new VncVector(stack.callstack().stream().map(f -> VncOrderedMap.of(CALLSTACK_KEY_FN_NAME, f.getFnName() == null ? Constants.Nil : new VncString(f.getFnName()), CALLSTACK_KEY_FILE, new VncString(f.getFile()), CALLSTACK_KEY_LINE, new VncLong(f.getLine()), CALLSTACK_KEY_COL, new VncLong(f.getCol()))).collect(Collectors.toList()));
        }
    };
    public static VncFunction os_type = new VncFunction("os-type", VncFunction.meta().module("core").arglists("(os-type)").doc("Returns the OS type").examples("(os-type)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os", args, 0);
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                return new VncKeyword("windows");
            }
            if (osName.startsWith("Mac OS X")) {
                return new VncKeyword("mac-osx");
            }
            if (osName.startsWith("LINUX")) {
                return new VncKeyword("linux");
            }
            return new VncKeyword("unknown");
        }
    };
    public static VncFunction os_type_Q = new VncFunction("os-type?", VncFunction.meta().module("core").arglists("(os-type? type)").doc("Returns true if the OS id of the type otherwise false. Type is one of :windows, :mac-osx, or :linux").examples("(os-type? :mac-osx)", "(os-type? :windows)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("os-type?", args, 1);
            String type = Coerce.toVncKeyword(args.first()).getValue();
            String osName = System.getProperty("os.name");
            switch (type) {
                case "windows": {
                    return osName.startsWith("Windows") ? Constants.True : Constants.False;
                }
                case "mac-osx": {
                    return osName.startsWith("Mac OS X") ? Constants.True : Constants.False;
                }
                case "linux": {
                    return osName.startsWith("LINUX") ? Constants.True : Constants.False;
                }
            }
            return Constants.False;
        }
    };
    public static VncFunction sandboxed_Q = new VncFunction("sandboxed?", VncFunction.meta().module("core").arglists("(sandboxed? )").doc("Returns true if there is a sandbox otherwise false").examples("(sandboxed? )").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sandboxed?", args, 0);
            return JavaInterop.isSandboxed() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction system_prop = new VncFunction("system-prop", VncFunction.meta().module("core").arglists("(system-prop name default-val)").doc("Returns the system property with the given name. Returns the default-val if the property does not exist or it's value is nil").examples("(system-prop :os.name)", "(system-prop :foo.org \"abc\")", "(system-prop \"os.name\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("system-prop", args, 1, 2);
            VncString key = Coerce.toVncString((VncVal)CoreFunctions.name.apply(VncList.of(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = JavaInterop.getInterceptor().onReadSystemProperty(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static VncFunction java_version = new VncFunction("java-version", VncFunction.meta().module("core").arglists("(java-version)").doc("Returns the Jvav VM version.").examples("(java-version)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-version", args, 0);
            return new VncString(System.getProperty("java.version"));
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("uuid", (VncVal)uuid).put("objid", (VncVal)objid).put("current-time-millis", (VncVal)current_time_millis).put("nano-time", (VncVal)nano_time).put("pid", (VncVal)pid).put("gc", (VncVal)gc).put("shutdown-hook", (VncVal)shutdown_hook).put("sandboxed?", (VncVal)sandboxed_Q).put("sleep", (VncVal)sleep).put("callstack", (VncVal)callstack).put("os-type", (VncVal)os_type).put("os-type?", (VncVal)os_type_Q).put("version", (VncVal)version).put("system-prop", (VncVal)system_prop).put("java-version", (VncVal)java_version).toMap();
    public static final VncKeyword CALLSTACK_KEY_FN_NAME = new VncKeyword(":fn-name");
    public static final VncKeyword CALLSTACK_KEY_FILE = new VncKeyword(":file");
    public static final VncKeyword CALLSTACK_KEY_LINE = new VncKeyword(":line");
    public static final VncKeyword CALLSTACK_KEY_COL = new VncKeyword(":col");

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid scheduler time-unit " + unit.getValue());
    }
}

