/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;

public class JavaInteropFn
extends VncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private final JavaImports javaImports;

    private JavaInteropFn(JavaImports javaImports) {
        super(".", VncFunction.meta().module("core").arglists("(. classname :new args)", "(. classname method-name args)", "(. classname field-name)", "(. classname :class)", "(. object method-name args)", "(. object field-name)", "(. object :class)").doc("Java interop. Calls a constructor or an class/object method or accesses a class/instance field. The function is sandboxed.").examples(";; invoke constructor \n(. :java.lang.Long :new 10)", ";; invoke static method \n(. :java.time.ZonedDateTime :now)", ";; invoke static method \n(. :java.lang.Math :min 10 20)", ";; access static field \n(. :java.lang.Math :PI)", ";; invoke method \n(. (. :java.lang.Long :new 10) :toString)", ";; get class name \n(. :java.lang.Math :class)", ";; get class name \n(. (. :java.io.File :new \"/temp\") :class)").build());
        this.javaImports = javaImports;
    }

    public static JavaInteropFn create(JavaImports javaImports) {
        return new JavaInteropFn(javaImports);
    }

    @Override
    public VncVal apply(VncList args) {
        return JavaInteropUtil.applyJavaAccess(args, this.javaImports);
    }
}

