/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncDouble
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Double value;

    public VncDouble(Double v) {
        this(v, Constants.Nil);
    }

    public VncDouble(Float v) {
        this(v.doubleValue(), Constants.Nil);
    }

    public VncDouble(Double v, VncVal meta) {
        super(meta);
        this.value = v;
    }

    @Override
    public VncDouble withMeta(VncVal meta) {
        return new VncDouble(this.value, meta);
    }

    public Double getValue() {
        return this.value;
    }

    @Override
    public int typeRank() {
        return 3;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(((VncDouble)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(Numeric.intToDouble((VncInteger)o).getValue());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(Numeric.longToDouble((VncLong)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToDouble((VncBigDecimal)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncDouble other = (VncDouble)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

