/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public abstract class VncFunction
extends VncVal
implements IVncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncVal ast;
    private final Env env;
    private final VncVector params;
    private volatile boolean macro = false;
    private final String name;
    private final AtomicReference<VncVal> fnMeta = new AtomicReference<VncConstant>(Constants.Nil);
    private volatile boolean _private;
    private volatile String module;

    public VncFunction() {
        this(null, null, null, null);
    }

    public VncFunction(String name) {
        this(name, null, null, null);
    }

    public VncFunction(String name, VncVal meta) {
        this(name, null, null, null, meta);
    }

    public VncFunction(VncVal ast, Env env, VncVector params) {
        this(null, ast, env, params);
    }

    public VncFunction(String name, VncVal ast, Env env, VncVector params) {
        this(name, ast, env, params, Constants.Nil);
    }

    public VncFunction(String name, VncVal ast, Env env, VncVector params, VncVal meta) {
        super(Constants.Nil);
        this.name = name != null ? name : VncFunction.createAnonymousFuncName();
        this.ast = ast;
        this.env = env;
        this.params = params;
        this.fnMeta.set(meta);
        this._private = MetaUtil.isPrivate(meta);
        this.module = MetaUtil.getModule(meta);
    }

    @Override
    public VncFunction withMeta(VncVal meta) {
        this.fnMeta.set(meta);
        this._private = MetaUtil.isPrivate(meta);
        this.module = MetaUtil.getModule(meta);
        return this;
    }

    public VncVal getAst() {
        return this.ast;
    }

    public Env getEnv() {
        return this.env;
    }

    public VncVector getParams() {
        return this.params;
    }

    public Env genEnv(VncList args) {
        return new Env(this.env).addAll(Destructuring.destructure(this.params, args));
    }

    public boolean isMacro() {
        return this.macro;
    }

    public void setMacro() {
        this.macro = true;
    }

    public String getName() {
        return this.name;
    }

    public static String createAnonymousFuncName() {
        return "anonymous-" + UUID.randomUUID().toString();
    }

    public VncList getArgLists() {
        return (VncList)this.getMetaVal(MetaUtil.ARGLIST, new VncList());
    }

    public VncVal getDoc() {
        return this.getMetaVal(MetaUtil.DOC);
    }

    public VncList getExamples() {
        return (VncList)this.getMetaVal(MetaUtil.EXAMPLES, new VncList());
    }

    @Override
    public int typeRank() {
        return 100;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return String.format("%s %s %s", this.isMacro() ? "macro" : "function", this.getName(), new StringBuilder().append("{").append("visibility ").append(this.isPrivate() ? ":private" : ":public").append(", module ").append(StringUtil.quote(this.getModule() == null ? "" : this.getModule(), '\"')).append("}"));
    }

    @Override
    public VncVal getMeta() {
        return this.fnMeta.get();
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    public static MetaBuilder meta() {
        return new MetaBuilder();
    }

    public static class MetaBuilder {
        private final HashMap<VncVal, VncVal> meta = new HashMap();

        public MetaBuilder arglists(String ... arglists) {
            this.meta.put(MetaUtil.ARGLIST, new VncList(Arrays.stream(arglists).map(s -> new VncString((String)s)).collect(Collectors.toList())));
            return this;
        }

        public MetaBuilder doc(String doc) {
            this.meta.put(MetaUtil.DOC, new VncString(doc));
            return this;
        }

        public MetaBuilder examples(String ... examples) {
            this.meta.put(MetaUtil.EXAMPLES, new VncList(Arrays.stream(examples).map(s -> new VncString((String)s)).collect(Collectors.toList())));
            return this;
        }

        public MetaBuilder module(String module) {
            this.meta.put(MetaUtil.MODULE, new VncString(module));
            return this;
        }

        public VncHashMap build() {
            return new VncHashMap(this.meta);
        }
    }
}

