/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.concurrent.ConcurrentHashMap;

public class VncMultiFunction
extends VncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private static final VncKeyword DEFAULT_METHOD = new VncKeyword(":default");
    private final VncFunction discriminatorFn;
    private final ConcurrentHashMap<VncVal, VncFunction> functions = new ConcurrentHashMap();

    public VncMultiFunction(String name, VncFunction discriminatorFn) {
        super(name);
        if (discriminatorFn == null) {
            throw new VncException("A discriminator function must not be null");
        }
        this.discriminatorFn = discriminatorFn;
    }

    @Override
    public VncMultiFunction withMeta(VncVal meta) {
        super.withMeta(meta);
        return this;
    }

    public VncMultiFunction addFn(VncVal dispatchVal, VncFunction fn) {
        if (dispatchVal == null) {
            throw new VncException("A dispatch value must not be null");
        }
        if (fn == null) {
            throw new VncException("A multifunction method must not be null");
        }
        this.functions.put(dispatchVal, fn);
        return this;
    }

    public VncMultiFunction removeFn(VncVal dispatchVal) {
        if (dispatchVal == null) {
            throw new VncException("A dispatch value must not be null");
        }
        this.functions.remove(dispatchVal);
        return this;
    }

    @Override
    public VncVector getParams() {
        return this.discriminatorFn.getParams();
    }

    @Override
    public VncVal apply(VncList params) {
        VncVal dispatchVal = (VncVal)this.discriminatorFn.apply(params);
        return (VncVal)this.findMethod(dispatchVal).apply(params);
    }

    @Override
    public int typeRank() {
        return 102;
    }

    @Override
    public String toString() {
        return "multi-fn " + this.getName();
    }

    private VncFunction findMethod(VncVal dispatchVal) {
        VncFunction fn = this.functions.get(dispatchVal);
        if (fn != null) {
            return fn;
        }
        VncFunction defaultFn = this.functions.get(DEFAULT_METHOD);
        if (defaultFn != null) {
            return defaultFn;
        }
        throw new VncException(String.format("No matching '%s' multifunction method defined for dispatch value %s", this.getName(), Printer.pr_str(dispatchVal, true)));
    }
}

