/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.repackage.io.vavr.collection.Seq;
import org.repackage.io.vavr.collection.Vector;

public class VncVector
extends VncSequence {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Vector<VncVal> value;

    public VncVector() {
        this((Seq<VncVal>)null, null);
    }

    public VncVector(VncVal meta) {
        this((Seq<VncVal>)null, meta);
    }

    public VncVector(Collection<? extends VncVal> vals) {
        this(vals, null);
    }

    public VncVector(Collection<? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : Vector.ofAll(vals), meta);
    }

    public VncVector(Seq<VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? Vector.empty() : (vals instanceof Vector ? (Vector<Object>)vals : Vector.ofAll(vals));
    }

    public static VncVector of(VncVal ... mvs) {
        return new VncVector(Vector.of(mvs), (VncVal)Constants.Nil);
    }

    @Override
    public VncVector empty() {
        return new VncVector(this.getMeta());
    }

    @Override
    public VncVector withVariadicValues(VncVal ... replaceVals) {
        return VncVector.of(replaceVals);
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals) {
        return new VncVector(replaceVals, this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return new VncVector(replaceVals, meta);
    }

    @Override
    public VncVector withMeta(VncVal meta) {
        return new VncVector(this.value, meta);
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public List<VncVal> getList() {
        return this.value.toJavaList();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a vector of size %d. %s", idx, this.size(), this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.value.get(0))));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.head();
    }

    @Override
    public VncVal second() {
        return this.nthOrDefault(1, Constants.Nil);
    }

    @Override
    public VncVal third() {
        return this.nthOrDefault(2, Constants.Nil);
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : (VncVal)this.value.last();
    }

    @Override
    public VncVector rest() {
        return this.isEmpty() ? new VncVector(this.getMeta()) : new VncVector(this.value.tail(), this.getMeta());
    }

    @Override
    public VncVector slice(int start, int end) {
        return new VncVector(this.value.subSequence(start, end), this.getMeta());
    }

    @Override
    public VncVector slice(int start) {
        return new VncVector(this.value.subSequence(start), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value, this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return this;
    }

    @Override
    public VncVector addAtStart(VncVal val) {
        return new VncVector(this.value.prepend((Object)val), this.getMeta());
    }

    @Override
    public VncVector addAllAtStart(VncSequence list) {
        return new VncVector(this.value.prependAll(list.getList()), this.getMeta());
    }

    @Override
    public VncVector addAtEnd(VncVal val) {
        return new VncVector(this.value.append((Object)val), this.getMeta());
    }

    @Override
    public VncVector addAllAtEnd(VncSequence list) {
        return new VncVector(this.value.appendAll(list.getList()), this.getMeta());
    }

    @Override
    public VncVector setAt(int idx, VncVal val) {
        return new VncVector(this.value.update(idx, (Object)val), this.getMeta());
    }

    @Override
    public VncVector removeAt(int idx) {
        return new VncVector(this.value.removeAt(idx), this.getMeta());
    }

    @Override
    public int typeRank() {
        return 201;
    }

    @Override
    public Object convertToJavaObject() {
        return this.getList().stream().map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncVector(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncVector)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncVector)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncVector other = (VncVector)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "[" + Printer.join(this.value.toJavaList(), " ", true) + "]";
    }

    @Override
    public String toString(boolean print_readably) {
        return "[" + Printer.join(this.value.toJavaList(), " ", print_readably) + "]";
    }
}

