/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.concurrent;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.concurrent.ConcurrentHashMap;

public class Delay
implements IDeref {
    private static final String KEY = "result";
    private final VncFunction fn;
    private final ConcurrentHashMap<String, Result> results = new ConcurrentHashMap();

    public Delay(VncFunction fn) {
        this.fn = fn;
    }

    @Override
    public VncVal deref() {
        return this.results.computeIfAbsent(KEY, k -> this.compute()).deref();
    }

    public boolean isRealized() {
        return this.results.containsKey(KEY);
    }

    private Result compute() {
        try {
            return new Result((VncVal)this.fn.apply(new VncList()), null);
        }
        catch (RuntimeException ex) {
            return new Result(null, ex);
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean print_readably) {
        if (this.isRealized()) {
            try {
                VncVal val = this.deref();
                return "(delay :value " + Printer.pr_str(val, print_readably) + ")";
            }
            catch (Exception ex) {
                return "(delay :exception :" + ex.getClass().getName() + ")";
            }
        }
        return "(delay :not-realized)";
    }

    private static class Result {
        private final VncVal val;
        private final RuntimeException ex;

        public Result(VncVal val, RuntimeException ex) {
            this.val = val;
            this.ex = ex;
        }

        public VncVal deref() {
            if (this.val != null) {
                return this.val;
            }
            throw this.ex;
        }
    }
}

