/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.concurrent;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.util.CallStack;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalMap {
    private final Map<VncKeyword, VncVal> values = new HashMap<VncKeyword, VncVal>();
    private final CallStack callStack = new CallStack();
    private static ThreadLocal<ThreadLocalMap> context = ThreadLocal.withInitial(() -> new ThreadLocalMap());

    public static VncVal get(VncKeyword key) {
        return ThreadLocalMap.get(key, Constants.Nil);
    }

    public static VncVal get(VncKeyword key, VncVal defaultValue) {
        if (key == null) {
            return Constants.Nil;
        }
        VncVal v = ThreadLocalMap.get().values.get(key);
        if (v instanceof VncStack) {
            VncVal thVal = ((VncStack)v).peek();
            return thVal == Constants.Nil ? defaultValue : thVal;
        }
        return v == null ? defaultValue : v;
    }

    public static void set(VncKeyword key, VncVal val) {
        if (key != null) {
            VncVal v = ThreadLocalMap.get().values.get(key);
            if (v == null) {
                ThreadLocalMap.get().values.put(key, val == null ? Constants.Nil : val);
            } else if (v instanceof VncStack) {
                ((VncStack)v).push(val == null ? Constants.Nil : val);
            } else {
                if (val instanceof VncMutableMap) {
                    throw new VncException(String.format("VncMutableMap is not permitted for thread-local values", key.getValue()));
                }
                ThreadLocalMap.get().values.put(key, val);
            }
        }
    }

    public static void remove(VncKeyword key) {
        if (key != null) {
            ThreadLocalMap.get().values.remove(key);
        }
    }

    public static boolean containsKey(VncKeyword key) {
        return key == null ? false : ThreadLocalMap.get().values.containsKey(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void push(VncKeyword key, VncVal val) {
        if (key == null) return;
        ThreadLocalMap tmap = ThreadLocalMap.get();
        if (tmap.values.containsKey(key)) {
            VncVal v = tmap.values.get(key);
            if (!(v instanceof VncStack)) throw new VncException(String.format("The var %s is not defined as dynamic on the thread-local map", key.getValue()));
            ((VncStack)v).push(val == null ? Constants.Nil : val);
            return;
        } else {
            VncStack stack = new VncStack();
            stack.push(val == null ? Constants.Nil : val);
            tmap.values.put(key, stack);
        }
    }

    public static VncVal pop(VncKeyword key) {
        if (key != null) {
            ThreadLocalMap tmap = ThreadLocalMap.get();
            if (tmap.values.containsKey(key)) {
                VncVal v = tmap.values.get(key);
                if (v instanceof VncStack) {
                    return ((VncStack)v).pop();
                }
                throw new VncException(String.format("The var %s is not defined as dynamic on the thread-local map", key.getValue()));
            }
        }
        return Constants.Nil;
    }

    public static VncVal peek(VncKeyword key) {
        if (key != null) {
            ThreadLocalMap tmap = ThreadLocalMap.get();
            if (tmap.values.containsKey(key)) {
                VncVal v = tmap.values.get(key);
                if (v instanceof VncStack) {
                    return ((VncStack)v).peek();
                }
                throw new VncException(String.format("The var %s is not defined as dynamic on the thread-local map", key.getValue()));
            }
        }
        return Constants.Nil;
    }

    public static void clearCallStack() {
        ThreadLocalMap.get().callStack.clear();
    }

    public static CallStack getCallStack() {
        return ThreadLocalMap.get().callStack;
    }

    public static Map<VncKeyword, VncVal> getValues() {
        HashMap<VncKeyword, VncVal> copy = new HashMap<VncKeyword, VncVal>();
        ThreadLocalMap.copyValues(ThreadLocalMap.get().values, copy);
        return copy;
    }

    public static void setValues(Map<VncKeyword, VncVal> newValues) {
        ThreadLocalMap.copyValues(newValues, ThreadLocalMap.get().values);
    }

    public static void clearValues() {
        try {
            ThreadLocalMap.get().values.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clear() {
        try {
            ThreadLocalMap.get().values.clear();
            ThreadLocalMap.get().callStack.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void remove() {
        try {
            ThreadLocalMap.get().values.clear();
            ThreadLocalMap.get().callStack.clear();
            context.set(null);
            context.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ThreadLocalMap get() {
        return context.get();
    }

    private static void copyValues(Map<VncKeyword, VncVal> from, Map<VncKeyword, VncVal> to) {
        to.clear();
        for (Map.Entry<VncKeyword, VncVal> e : from.entrySet()) {
            VncVal val = e.getValue();
            if (val instanceof VncStack) {
                VncStack copyStack = new VncStack();
                if (!((VncStack)val).isEmpty()) {
                    copyStack.push(((VncStack)val).peek());
                }
                to.put(e.getKey(), copyStack);
                continue;
            }
            to.put(e.getKey(), val);
        }
    }
}

