/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.util.StackFrame;

public class CallFrame {
    private final String fnName;
    private final String module;
    private final VncVal meta;

    private CallFrame(String fnName, String module, VncVal meta) {
        this.fnName = fnName;
        this.module = module;
        this.meta = meta;
    }

    public static CallFrame fromVal(String fnName, VncVal val) {
        return new CallFrame(fnName, null, val.getMeta());
    }

    public static CallFrame fromVal(VncVal val) {
        return new CallFrame(null, null, val.getMeta());
    }

    public static CallFrame fromFunction(VncFunction fn, VncVal fnSym) {
        return new CallFrame(fn.getName(), fn.getModule(), Types.isVncSymbol(fnSym) ? fnSym.getMeta() : Constants.Nil);
    }

    public CallFrame withModule(String module) {
        return new CallFrame(this.fnName, module, this.meta);
    }

    public String getFnName() {
        return this.fnName;
    }

    public String getModule() {
        return this.module;
    }

    public String getFile() {
        VncVal vFile = this.getMetaVal(MetaUtil.FILE);
        String file = vFile == Constants.Nil ? null : Coerce.toVncString(vFile).getValue();
        return file == null || file.isEmpty() ? "unknown" : file;
    }

    public int getLine() {
        VncVal vLine = this.getMetaVal(MetaUtil.LINE);
        return vLine == Constants.Nil ? -1 : Coerce.toVncLong(vLine).getValue().intValue();
    }

    public int getCol() {
        VncVal vCol = this.getMetaVal(MetaUtil.COLUMN);
        return vCol == Constants.Nil ? -1 : Coerce.toVncLong(vCol).getValue().intValue();
    }

    public StackFrame toStackFrame() {
        return new StackFrame(this.getFnName(), this.getFile(), this.getLine(), this.getCol());
    }

    public String toString() {
        return this.fnName == null ? String.format("%s: line %d, col %d", this.getFile(), this.getLine(), this.getCol()) : String.format("%s (%s: line %d, col %d)", this.fnName, this.getFile(), this.getLine(), this.getCol());
    }

    private VncVal getMetaVal(VncString key) {
        return this.meta instanceof VncHashMap ? ((VncHashMap)this.meta).get(key) : Constants.Nil;
    }
}

