/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.util.CallFrame;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;

public class CallStack {
    private final ConcurrentLinkedDeque<CallFrame> queue = new ConcurrentLinkedDeque();

    public void push(CallFrame frame) {
        if (frame.getModule() == null) {
            if (this.queue.isEmpty()) {
                this.queue.push(frame.withModule("user"));
            } else {
                this.queue.push(frame.withModule(this.queue.peek().getModule()));
            }
        } else {
            this.queue.push(frame);
        }
    }

    public CallFrame pop() {
        return this.queue.pop();
    }

    public CallFrame peek() {
        return this.queue.peek();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void clear() {
        this.queue.clear();
    }

    public CallStack copy() {
        CallStack stack = new CallStack();
        this.queue.forEach(f -> stack.queue.add((CallFrame)f));
        return stack;
    }

    public List<String> toList() {
        return Arrays.stream(this.queue.toArray(new CallFrame[0])).map(f -> f.toString()).collect(Collectors.toList());
    }

    public List<CallFrame> callstack() {
        return Arrays.asList(this.queue.toArray(new CallFrame[0]));
    }

    public String peekModule() {
        return this.queue.isEmpty() ? "user" : this.queue.peek().getModule();
    }

    public String toString() {
        return this.toList().stream().collect(Collectors.joining("\n"));
    }
}

