/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import com.github.jlangch.venice.JavaMethodInvocationException;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.impl.util.Tuple4;
import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import com.github.jlangch.venice.impl.util.reflect.ScopedEnumValue;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectionAccessor {
    private static final AtomicBoolean cachingEnabled = new AtomicBoolean(true);
    private static final HashMap<String, Class<?>> classCache = new HashMap();
    private static final HashMap<Class<?>, List<String>> getterPropertiesCache = new HashMap();
    private static final HashMap<Class<?>, List<String>> setterPropertiesCache = new HashMap();
    private static final HashMap<Tuple2<Class<?>, String>, Method> getterMethodCache = new HashMap();
    private static final HashMap<Tuple2<Class<?>, String>, Method> setterMethodCache = new HashMap();
    private static final HashMap<Tuple2<Class<?>, Integer>, List<Constructor<?>>> constructorCache = new HashMap();
    private static final HashMap<Tuple2<Class<?>, String>, Field> staticFieldCache = new HashMap();
    private static final HashMap<Tuple2<Class<?>, String>, Field> instanceFieldCache = new HashMap();
    private static final HashMap<Tuple4<Class<?>, String, Integer, Boolean>, List<Method>> staticMethodCache = new HashMap();
    private static final HashMap<Tuple4<Class<?>, String, Integer, Boolean>, List<Method>> instanceMethodCache = new HashMap();

    public static void enableCache(boolean enable) {
        ReflectionAccessor.clearCache();
        cachingEnabled.set(enable);
    }

    public static boolean isCacheEnabled() {
        return cachingEnabled.get();
    }

    public static void clearCache() {
        classCache.clear();
        getterMethodCache.clear();
        setterMethodCache.clear();
        constructorCache.clear();
        staticFieldCache.clear();
        instanceFieldCache.clear();
        instanceMethodCache.clear();
        staticMethodCache.clear();
    }

    public static Class<?> classForName(String className) {
        try {
            return ReflectionAccessor.memoizedClassForName(className);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get class '%s'", className), ex);
        }
    }

    public static Class<?> classExists(String className) {
        try {
            return ReflectionAccessor.memoizedClassForName(className);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object invokeConstructor(Class<?> clazz, Object[] args) {
        try {
            Class<?>[] params;
            List<Constructor<?>> ctors = ReflectionAccessor.memoizedPublicConstructors(clazz, args.length);
            if (ctors.isEmpty()) {
                throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingConstructorErrMsg(clazz));
            }
            if (ctors.size() == 1) {
                Constructor<?> ctor = ctors.get(0);
                return ctor.newInstance(ReflectionAccessor.boxArgs(ctor.getParameterTypes(), args));
            }
            for (Constructor<?> ctor : ctors) {
                params = ctor.getParameterTypes();
                if (!ReflectionAccessor.isCongruent(params, args, true, ctor.isVarArgs())) continue;
                Object[] boxedArgs = ReflectionAccessor.boxArgs(params, args);
                return ctor.newInstance(boxedArgs);
            }
            for (Constructor<?> ctor : ctors) {
                params = ctor.getParameterTypes();
                if (!ReflectionAccessor.isCongruent(params, args, false, ctor.isVarArgs())) continue;
                Object[] boxedArgs = ReflectionAccessor.boxArgs(params, args);
                return ctor.newInstance(boxedArgs);
            }
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingConstructorErrMsg(clazz));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke constructor '%s'", clazz.getName()), ex);
        }
    }

    public static Object invokeInstanceMethod(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            List<Method> methods = ReflectionAccessor.memoizedInstanceMethod(clazz, methodName, args.length, true);
            return ReflectionAccessor.invokeMatchingMethod(methodName, methods, target, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke instance method '%s' on target '%s'", methodName, target == null ? "<null>" : target.getClass().getName()), ex);
        }
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) {
        try {
            Class<?> clazz = ReflectionAccessor.classForName(className);
            return ReflectionAccessor.invokeStaticMethod(clazz, methodName, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke static method '%s' on class '%s'", methodName, className), ex);
        }
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName, Object[] args) {
        if (methodName.equals("new")) {
            return ReflectionAccessor.invokeConstructor(clazz, args);
        }
        try {
            List<Method> methods = ReflectionAccessor.memoizedStaticMethod(clazz, methodName, args.length, true);
            return ReflectionAccessor.invokeMatchingMethod(methodName, methods, null, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke static method '%s' on class '%s'", methodName, clazz.getName()), ex);
        }
    }

    public static Object getStaticField(String className, String fieldName) {
        try {
            Class<?> clazz = ReflectionAccessor.classForName(className);
            return ReflectionAccessor.getStaticField(clazz, fieldName);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get static field '%s' on class '%s'", fieldName, className), ex);
        }
    }

    public static Object getStaticField(Class<?> clazz, String fieldName) {
        try {
            Field f = ReflectionAccessor.memoizedStaticField(clazz, fieldName);
            if (f != null) {
                return f.get(null);
            }
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingFieldErrMsg(fieldName, clazz.getName()));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get static field '%s' on class '%s'", fieldName, clazz.getName()), ex);
        }
    }

    public static Object getInstanceField(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field f = ReflectionAccessor.memoizedInstanceField(clazz, fieldName);
            if (f != null) {
                return f.get(target);
            }
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingFieldErrMsg(fieldName, clazz.getName()));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get instance field '%s' on target '%s'", fieldName, target.getClass().getName()), ex);
        }
    }

    public static List<String> getBeanGetterProperties(Object target) {
        return ReflectionAccessor.memoizedBeanGetterProperties(target.getClass());
    }

    public static List<String> getBeanSetterProperties(Object target) {
        return ReflectionAccessor.memoizedBeanSetterProperties(target.getClass());
    }

    public static Object getBeanProperty(Object target, String propertyName) {
        Method method = ReflectionAccessor.memoizedBeanGetterMethod(target.getClass(), propertyName);
        if (method == null) {
            throw new JavaMethodInvocationException(String.format("No bean get property '%s' on target '%s'", propertyName, target.getClass().getName()));
        }
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get bean property '%s' on target '%s'", propertyName, target.getClass().getName()), ex);
        }
    }

    public static void setBeanProperty(Object target, String propertyName, Object value) {
        Method method = ReflectionAccessor.memoizedBeanSetterMethod(target.getClass(), propertyName);
        if (method == null) {
            throw new JavaMethodInvocationException(String.format("No bean set property '%s' on target '%s'", propertyName, target.getClass().getName()));
        }
        try {
            Class<?> type = method.getParameterTypes()[0];
            method.invoke(target, ReflectionAccessor.boxArg(type, value));
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to set bean property '%s' on target '%s'", propertyName, target.getClass().getName()), ex);
        }
    }

    public static boolean isStaticMethod(Class<?> clazz, String methodName, Object[] args) {
        try {
            List<Method> methods = ReflectionAccessor.memoizedStaticMethod(clazz, methodName, args.length, true);
            return !methods.isEmpty();
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed check for available static method '%s' on class '%s'", methodName, clazz.getName()), ex);
        }
    }

    public static boolean isInstanceMethod(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            List<Method> methods = ReflectionAccessor.memoizedInstanceMethod(clazz, methodName, args.length, true);
            return !methods.isEmpty();
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available instance method '%s' on target '%s'", methodName, target == null ? "<null>" : target.getClass().getName()), ex);
        }
    }

    public static boolean isStaticField(Class<?> clazz, String fieldName) {
        try {
            Field f = ReflectionAccessor.memoizedStaticField(clazz, fieldName);
            return f != null;
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available static field '%s' on target '%s'", fieldName, clazz.getName()), ex);
        }
    }

    public static boolean isInstanceField(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field f = ReflectionAccessor.memoizedInstanceField(clazz, fieldName);
            return f != null;
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available instance field '%s' on target '%s'", fieldName, target.getClass().getName()), ex);
        }
    }

    private static Object invokeMatchingMethod(String methodName, List<Method> methods, Object target, Object[] args) {
        Class<?>[] params;
        if (methods.isEmpty()) {
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingMethodErrMsg(methodName, target, args));
        }
        if (methods.size() == 1) {
            Method m = methods.get(0);
            Object[] boxedArgs = ReflectionAccessor.boxArgs(m.getParameterTypes(), args);
            return ReflectionAccessor.invoke(m, target, boxedArgs);
        }
        for (Method m : methods) {
            params = m.getParameterTypes();
            if (!ReflectionAccessor.isCongruent(params, args, true, m.isVarArgs())) continue;
            Object[] boxedArgs = ReflectionAccessor.boxArgs(params, args);
            return ReflectionAccessor.invoke(m, target, boxedArgs);
        }
        for (Method m : methods) {
            params = m.getParameterTypes();
            if (!ReflectionAccessor.isCongruent(params, args, false, m.isVarArgs())) continue;
            Object[] boxedArgs = ReflectionAccessor.boxArgs(params, args);
            return ReflectionAccessor.invoke(m, target, boxedArgs);
        }
        throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingMethodErrMsg(methodName, target, args));
    }

    private static Object invoke(Method method, Object target, Object[] args) {
        try {
            if (method.getDeclaringClass().getName().equals("java.util.stream.ReferencePipeline")) {
                return ReflectionAccessor.invokeStreamMethod(method.getName(), target, args);
            }
            return method.invoke(target, args);
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(target == null ? String.format("Failed to invoke static method %s", method.getName()) : String.format("Failed to invoke method %s on target %s", method.getName(), target.getClass().getName()), ex);
        }
    }

    private static Object invokeStreamMethod(String methodName, Object target, Object[] args) {
        Stream stream = (Stream)target;
        switch (methodName) {
            case "allMatch": {
                return stream.allMatch((Predicate)args[0]);
            }
            case "anyMatch": {
                return stream.anyMatch((Predicate)args[0]);
            }
            case "collect": {
                switch (args.length) {
                    case 1: {
                        return stream.collect((Collector)args[0]);
                    }
                    case 3: {
                        return stream.collect((Supplier)args[0], (BiConsumer)args[1], (BiConsumer)args[2]);
                    }
                }
                throw new JavaMethodInvocationException("Unsupported stream method 'collect' with " + args.length + " parameters");
            }
            case "distinct": {
                return stream.distinct();
            }
            case "filter": {
                return stream.filter((Predicate)args[0]);
            }
            case "findAny": {
                return stream.findAny();
            }
            case "findFirst": {
                return stream.findFirst();
            }
            case "limit": {
                return stream.limit((Long)args[0]);
            }
            case "map": {
                return stream.map((Function)args[0]);
            }
            case "mapToDouble": {
                return stream.mapToDouble((ToDoubleFunction)args[0]);
            }
            case "mapToInt": {
                return stream.mapToInt((ToIntFunction)args[0]);
            }
            case "mapToLong": {
                return stream.mapToLong((ToLongFunction)args[0]);
            }
            case "max": {
                return stream.max((Comparator)args[0]);
            }
            case "min": {
                return stream.min((Comparator)args[0]);
            }
            case "noneMatch": {
                return stream.noneMatch((Predicate)args[0]);
            }
            case "reduce": {
                switch (args.length) {
                    case 1: {
                        return stream.reduce((BinaryOperator)args[0]);
                    }
                    case 2: {
                        return stream.reduce(args[0], (BinaryOperator)args[1]);
                    }
                    case 3: {
                        return stream.reduce(args[0], (BiFunction)args[1], (BinaryOperator)args[2]);
                    }
                }
                throw new JavaMethodInvocationException("Unsupported stream method 'reduce' with " + args.length + " parameters");
            }
            case "sorted": {
                return args.length == 0 ? stream.sorted() : stream.sorted((Comparator)args[0]);
            }
            case "skip": {
                return stream.skip((Long)args[0]);
            }
        }
        throw new JavaMethodInvocationException("Unsupported stream method '" + methodName + "'");
    }

    private static boolean isCongruent(Class<?>[] params, Object[] args, boolean exactMatch, boolean varargs) {
        if (args == null) {
            return params.length == 0;
        }
        if (params.length == args.length) {
            for (int ii = 0; ii < params.length; ++ii) {
                boolean match;
                Object arg = args[ii];
                Class<?> argType = arg == null ? null : arg.getClass();
                Class<?> paramType = params[ii];
                if (ReflectionTypes.isEnumType(paramType)) {
                    if (arg == null) continue;
                    if (arg instanceof String) {
                        ScopedEnumValue scopedEnum = new ScopedEnumValue((String)arg);
                        if (!scopedEnum.isScoped() || scopedEnum.isCompatible(paramType)) continue;
                        return false;
                    }
                    return false;
                }
                boolean bl = match = exactMatch ? ReflectionAccessor.paramArgTypeMatchExact(paramType, argType) : ReflectionAccessor.paramArgTypeMatch(paramType, argType);
                if (match) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean paramArgTypeMatchExact(Class<?> paramType, Class<?> argType) {
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType == Byte.TYPE || argType == Byte.class || paramType == Short.TYPE || argType == Short.class || paramType == Integer.TYPE || argType == Integer.class || paramType == Long.TYPE || paramType == Long.class) {
            return argType == Byte.class || argType == Short.class || argType == Integer.class || argType == Long.class;
        }
        if (paramType == Float.TYPE || paramType == Float.class || paramType == Double.TYPE || paramType == Double.class) {
            return argType == Float.class || argType == Double.class;
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return argType == Character.class;
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return argType == Boolean.class;
        }
        return false;
    }

    private static boolean paramArgTypeMatch(Class<?> paramType, Class<?> argType) {
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType == Byte.TYPE || paramType == Byte.class || paramType == Short.TYPE || paramType == Short.class || paramType == Integer.TYPE || paramType == Integer.class || paramType == Long.TYPE || paramType == Long.class || paramType == Float.TYPE || paramType == Float.class || paramType == Double.TYPE || paramType == Double.class) {
            return argType == Byte.class || argType == Short.class || argType == Integer.class || argType == Long.class || argType == Float.class || argType == Double.class;
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return argType == Character.class;
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return argType == Boolean.class;
        }
        if (ReflectionTypes.isArrayType(paramType)) {
            Class<?> paramComponentType = paramType.getComponentType();
            if (paramComponentType == Byte.TYPE) {
                if (argType == String.class) {
                    return true;
                }
                if (ByteBuffer.class.isAssignableFrom(argType)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static Object[] boxArgs(Class<?>[] params, Object[] args) {
        if (params.length == 0) {
            return null;
        }
        Object[] ret = new Object[params.length];
        for (int ii = 0; ii < params.length; ++ii) {
            ret[ii] = ReflectionAccessor.boxArg(params[ii], args[ii]);
        }
        return ret;
    }

    private static Object boxArg(Class<?> paramType, Object arg) {
        Object boxed;
        if (!paramType.isPrimitive()) {
            if (ReflectionTypes.isArrayType(paramType)) {
                return ReflectionAccessor.boxArrayArg(paramType, arg);
            }
            if (arg instanceof Number) {
                Object boxed2 = ReflectionAccessor.boxNumberArg(paramType, (Number)arg);
                if (boxed2 != null) {
                    return boxed2;
                }
            } else if (ReflectionTypes.isEnumType(paramType)) {
                return ReflectionAccessor.boxEnumArg(paramType, arg);
            }
            return paramType.cast(arg);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.class.cast(arg);
        }
        if (paramType == Character.TYPE) {
            return Character.class.cast(arg);
        }
        if (arg instanceof Number && (boxed = ReflectionAccessor.boxNumberArg(paramType, (Number)arg)) != null) {
            return boxed;
        }
        throw new JavaMethodInvocationException(String.format("Unexpected param type, expected: %s, given: %s", paramType.getName(), arg.getClass().getName()));
    }

    private static Object boxNumberArg(Class<?> paramType, Number arg) {
        if (paramType == Byte.TYPE || paramType == Byte.class) {
            return arg.byteValue();
        }
        if (paramType == Short.TYPE || paramType == Short.class) {
            return arg.shortValue();
        }
        if (paramType == Integer.TYPE || paramType == Integer.class) {
            return arg.intValue();
        }
        if (paramType == Long.TYPE || paramType == Long.class) {
            return arg.longValue();
        }
        if (paramType == Float.TYPE || paramType == Float.class) {
            return Float.valueOf(arg.floatValue());
        }
        if (paramType == Double.TYPE || paramType == Double.class) {
            return arg.doubleValue();
        }
        return null;
    }

    private static Enum<?> boxEnumArg(Class<? extends Enum<?>> enumType, Object arg) {
        if (arg instanceof String) {
            ScopedEnumValue scopedEnum = new ScopedEnumValue((String)arg);
            if (scopedEnum.isScoped()) {
                if (scopedEnum.isCompatible(enumType)) {
                    Enum<?> e = scopedEnum.getEnum(enumType);
                    if (e != null) {
                        return e;
                    }
                    throw new JavaMethodInvocationException(String.format("Enum %s does not define value %s", enumType.getName(), scopedEnum.getEnumValue()));
                }
                throw new JavaMethodInvocationException(String.format("Enum %s is not compatible with %s", scopedEnum.getScopedEnumValue(), enumType.getName()));
            }
            Enum<?> e = scopedEnum.getEnum(enumType);
            if (e != null) {
                return e;
            }
            throw new JavaMethodInvocationException(String.format("Enum %s does not define value %s", enumType.getName(), scopedEnum.getEnumValue()));
        }
        throw new JavaMethodInvocationException(String.format("Cannot convert type %s to enum %s", arg.getClass().getName(), enumType.getName()));
    }

    private static Object boxArrayArg(Class<?> type, Object arg) {
        Class<?> argComponentType;
        Class<?> componentType = type.getComponentType();
        if (componentType == Byte.TYPE) {
            if (arg == null) {
                return ReflectionAccessor.boxStringToByteArray((String)arg);
            }
            if (arg.getClass() == String.class) {
                return ReflectionAccessor.boxStringToByteArray((String)arg);
            }
            if (arg.getClass() == byte[].class) {
                return (byte[])arg;
            }
            if (arg instanceof ByteBuffer) {
                return ((ByteBuffer)arg).array();
            }
        } else if (ReflectionTypes.isArrayType(arg.getClass()) && componentType == (argComponentType = arg.getClass().getComponentType())) {
            return arg;
        }
        if (ReflectionTypes.isListOrSet(arg.getClass())) {
            int size = ((Collection)arg).size();
            Object arr = Array.newInstance(componentType, size);
            AtomicInteger idx = new AtomicInteger(0);
            ((Collection)arg).forEach(v -> Array.set(arr, idx.getAndIncrement(), ReflectionAccessor.boxArg(componentType, v)));
            return arr;
        }
        if (ReflectionTypes.isMap(arg.getClass())) {
            throw new JavaMethodInvocationException("Cannot box map to array");
        }
        Object arr = Array.newInstance(componentType, 1);
        Array.set(arr, 0, ReflectionAccessor.boxArg(componentType, arg));
        return arr;
    }

    private static byte[] boxStringToByteArray(String str) {
        try {
            return str == null ? null : str.getBytes("UTF-8");
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException("Failed to box arg of type String to byte[]", ex);
        }
    }

    private static String noMatchingFieldErrMsg(String fieldName, Object target) {
        return String.format("No matching public field found: '%s' for target '%s'", fieldName, target == null ? "<null>" : target.getClass().getName());
    }

    private static String noMatchingMethodErrMsg(String methodName, Object target, Object ... methodArgs) {
        return String.format("No matching public method found: %s(%s) for target '%s'", methodName, ReflectionAccessor.formatArgTypes(methodArgs), target == null ? "<null>" : target.getClass().getName());
    }

    private static String noMatchingConstructorErrMsg(Class<?> clazz) {
        return String.format("No matching public constructor found: '%s'", clazz.getName());
    }

    private static Class<?> memoizedClassForName(String className) {
        return ReflectionAccessor.isCacheEnabled() ? classCache.computeIfAbsent(className, k -> ReflectionUtil.classForName(k)) : ReflectionUtil.classForName(className);
    }

    private static List<String> memoizedBeanGetterProperties(Class<?> clazz) {
        return ReflectionAccessor.isCacheEnabled() ? getterPropertiesCache.computeIfAbsent(clazz, k -> ReflectionUtil.getBeanGetterProperties(k)) : ReflectionUtil.getBeanGetterProperties(clazz);
    }

    private static List<String> memoizedBeanSetterProperties(Class<?> clazz) {
        return ReflectionAccessor.isCacheEnabled() ? setterPropertiesCache.computeIfAbsent(clazz, k -> ReflectionUtil.getBeanSetterProperties(k)) : ReflectionUtil.getBeanSetterProperties(clazz);
    }

    private static Method memoizedBeanGetterMethod(Class<?> clazz, String propertyName) {
        return ReflectionAccessor.isCacheEnabled() ? getterMethodCache.computeIfAbsent(new Tuple2(clazz, propertyName), k -> ReflectionUtil.getBeanGetterMethod((Class)k._1, (String)k._2)) : ReflectionUtil.getBeanGetterMethod(clazz, propertyName);
    }

    private static Method memoizedBeanSetterMethod(Class<?> clazz, String propertyName) {
        return ReflectionAccessor.isCacheEnabled() ? setterMethodCache.computeIfAbsent(new Tuple2(clazz, propertyName), k -> ReflectionUtil.getBeanSetterMethod((Class)k._1, (String)k._2)) : ReflectionUtil.getBeanSetterMethod(clazz, propertyName);
    }

    private static List<Constructor<?>> memoizedPublicConstructors(Class<?> clazz, int args) {
        return ReflectionAccessor.isCacheEnabled() ? constructorCache.computeIfAbsent(new Tuple2(clazz, args), k -> ReflectionUtil.getPublicConstructors((Class)k._1, (Integer)k._2)) : ReflectionUtil.getPublicConstructors(clazz, args);
    }

    private static Field memoizedStaticField(Class<?> clazz, String fieldName) {
        return ReflectionAccessor.isCacheEnabled() ? staticFieldCache.computeIfAbsent(new Tuple2(clazz, fieldName), k -> ReflectionUtil.getPublicStaticField((Class)k._1, (String)k._2)) : ReflectionUtil.getPublicStaticField(clazz, fieldName);
    }

    private static Field memoizedInstanceField(Class<?> clazz, String fieldName) {
        return ReflectionAccessor.isCacheEnabled() ? instanceFieldCache.computeIfAbsent(new Tuple2(clazz, fieldName), k -> ReflectionUtil.getPublicInstanceField((Class)k._1, (String)k._2)) : ReflectionUtil.getPublicInstanceField(clazz, fieldName);
    }

    private static List<Method> memoizedStaticMethod(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return ReflectionAccessor.isCacheEnabled() ? staticMethodCache.computeIfAbsent(new Tuple4(clazz, methodName, arity, includeInheritedClasses), k -> ReflectionUtil.getAllPublicStaticMethods((Class)k._1, (String)k._2, (Integer)k._3, (Boolean)k._4)) : ReflectionUtil.getAllPublicStaticMethods(clazz, methodName, arity, includeInheritedClasses);
    }

    private static List<Method> memoizedInstanceMethod(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return ReflectionAccessor.isCacheEnabled() ? instanceMethodCache.computeIfAbsent(new Tuple4(clazz, methodName, arity, includeInheritedClasses), k -> ReflectionUtil.getAllPublicInstanceMethods((Class)k._1, (String)k._2, (Integer)k._3, (Boolean)k._4)) : ReflectionUtil.getAllPublicInstanceMethods(clazz, methodName, arity, includeInheritedClasses);
    }

    private static String formatArgTypes(Object[] args) {
        return Arrays.stream(args).map(o -> o.getClass().getSimpleName()).collect(Collectors.joining(", "));
    }
}

