/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.nanojson;

import com.github.jlangch.venice.nanojson.JsonLazyNumber;
import com.github.jlangch.venice.nanojson.JsonParserException;
import com.github.jlangch.venice.nanojson.JsonTokener;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.BitSet;

public final class JsonReader {
    private JsonTokener tokener;
    private int token;
    private BitSet states = new BitSet();
    private int stateIndex = 0;
    private boolean inObject;
    private boolean first = true;
    private StringBuilder key = new StringBuilder();

    public static JsonReader from(Reader in) throws JsonParserException {
        return new JsonReader(new JsonTokener(in));
    }

    public static JsonReader from(InputStream in) throws JsonParserException {
        return new JsonReader(new JsonTokener(in));
    }

    public static JsonReader from(String s) throws JsonParserException {
        return new JsonReader(new JsonTokener(new StringReader(s)));
    }

    JsonReader(JsonTokener tokener) throws JsonParserException {
        this.tokener = tokener;
        this.token = tokener.advanceToToken();
    }

    public boolean pop() throws JsonParserException {
        while (!this.next()) {
        }
        this.first = false;
        this.inObject = this.states.get(--this.stateIndex);
        return this.token != 0;
    }

    public Type current() throws JsonParserException {
        switch (this.token) {
            case 6: 
            case 7: {
                return Type.BOOLEAN;
            }
            case 5: {
                return Type.NULL;
            }
            case 9: {
                return Type.NUMBER;
            }
            case 8: {
                return Type.STRING;
            }
            case 10: {
                return Type.OBJECT;
            }
            case 11: {
                return Type.ARRAY;
            }
        }
        throw this.createTokenMismatchException(5, 6, 7, 9, 8, 10, 11);
    }

    public void object() throws JsonParserException {
        if (this.token != 10) {
            throw this.createTokenMismatchException(10);
        }
        this.states.set(this.stateIndex++, this.inObject);
        this.inObject = true;
        this.first = true;
    }

    public String key() throws JsonParserException {
        if (!this.inObject) {
            throw this.tokener.createParseException(null, "Not reading an object", true);
        }
        return this.key.toString();
    }

    public void array() throws JsonParserException {
        if (this.token != 11) {
            throw this.createTokenMismatchException(11);
        }
        this.states.set(this.stateIndex++, this.inObject);
        this.inObject = false;
        this.first = true;
    }

    public Object value() throws JsonParserException {
        switch (this.token) {
            case 6: {
                return true;
            }
            case 7: {
                return false;
            }
            case 5: {
                return null;
            }
            case 9: {
                return this.number();
            }
            case 8: {
                return this.string();
            }
        }
        throw this.createTokenMismatchException(5, 6, 7, 9, 8);
    }

    public void nul() throws JsonParserException {
        if (this.token != 5) {
            throw this.createTokenMismatchException(5);
        }
    }

    public String string() throws JsonParserException {
        if (this.token == 5) {
            return null;
        }
        if (this.token != 8) {
            throw this.createTokenMismatchException(5, 8);
        }
        return this.tokener.reusableBuffer.toString();
    }

    public boolean bool() throws JsonParserException {
        if (this.token == 6) {
            return true;
        }
        if (this.token == 7) {
            return false;
        }
        throw this.createTokenMismatchException(6, 7);
    }

    public Number number() throws JsonParserException {
        if (this.token == 5) {
            return null;
        }
        return new JsonLazyNumber(this.tokener.reusableBuffer.toString(), this.tokener.isDouble);
    }

    public long longVal() throws JsonParserException {
        String s = this.tokener.reusableBuffer.toString();
        return this.tokener.isDouble ? (long)Double.parseDouble(s) : Long.parseLong(s);
    }

    public int intVal() throws JsonParserException {
        String s = this.tokener.reusableBuffer.toString();
        return this.tokener.isDouble ? (int)Double.parseDouble(s) : Integer.parseInt(s);
    }

    public float floatVal() throws JsonParserException {
        String s = this.tokener.reusableBuffer.toString();
        return Float.parseFloat(s);
    }

    public double doubleVal() throws JsonParserException {
        String s = this.tokener.reusableBuffer.toString();
        return Double.parseDouble(s);
    }

    public boolean next() throws JsonParserException {
        if (this.stateIndex == 0) {
            throw this.tokener.createParseException(null, "Unabled to call next() at the root", true);
        }
        this.token = this.tokener.advanceToToken();
        if (this.inObject) {
            if (this.token == 3) {
                this.inObject = this.states.get(--this.stateIndex);
                return false;
            }
            if (!this.first) {
                if (this.token != 1) {
                    throw this.createTokenMismatchException(1, 3);
                }
                this.token = this.tokener.advanceToToken();
            }
            if (this.token != 8) {
                throw this.createTokenMismatchException(8);
            }
            this.key.setLength(0);
            this.key.append((CharSequence)this.tokener.reusableBuffer);
            this.token = this.tokener.advanceToToken();
            if (this.token != 2) {
                throw this.createTokenMismatchException(2);
            }
            this.token = this.tokener.advanceToToken();
        } else {
            if (this.token == 4) {
                this.inObject = this.states.get(--this.stateIndex);
                return false;
            }
            if (!this.first) {
                if (this.token != 1) {
                    throw this.createTokenMismatchException(1, 4);
                }
                this.token = this.tokener.advanceToToken();
            }
        }
        if (this.token != 5 && this.token != 8 && this.token != 9 && this.token != 6 && this.token != 7 && this.token != 10 && this.token != 11) {
            throw this.createTokenMismatchException(5, 8, 9, 6, 7, 10, 11);
        }
        this.first = false;
        return true;
    }

    private JsonParserException createTokenMismatchException(int ... t) {
        return this.tokener.createParseException(null, "token mismatch (expected " + Arrays.toString(t) + ", was " + this.token + ")", true);
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL;

    }
}

