/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.pdf;

import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;

public class ClasspathUserAgent
extends ITextUserAgent {
    private final ConcurrentLinkedQueue<String> alternateBasePaths = new ConcurrentLinkedQueue();
    private final Map<String, ByteBuffer> cachedResources = new ConcurrentHashMap<String, ByteBuffer>();

    public ClasspathUserAgent(ITextOutputDevice outputDevice) {
        super(outputDevice);
    }

    public ClasspathUserAgent addAlternateBasePath(String path) {
        if (StringUtil.isBlank(path)) {
            throw new IllegalArgumentException("A path must not be blank");
        }
        String altPath = this.stripLeadingTrailingSlash(path);
        if (StringUtil.isNotBlank(altPath)) {
            this.alternateBasePaths.add(altPath);
        }
        return this;
    }

    public ClasspathUserAgent addResource(String name, ByteBuffer data) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("A 'resource' name must not be blank");
        }
        if (data == null) {
            throw new IllegalArgumentException("A 'resource' data must not be null");
        }
        this.cachedResources.put(name, data);
        return this;
    }

    protected InputStream resolveAndOpenStream(String uri) {
        if (uri == null) {
            return null;
        }
        if (this.isClasspathScheme(uri)) {
            String cpResource = this.stripClasspathScheme(uri);
            ByteBuffer data = this.cachedResources.get(cpResource);
            if (data != null) {
                return new ByteArrayInputStream(data.array());
            }
            data = this.slurp(new ClassPathResource(cpResource));
            if (data != null) {
                this.cachedResources.put(cpResource, data);
                return new ByteArrayInputStream(data.array());
            }
            for (String path : this.alternateBasePaths) {
                data = this.slurp(new ClassPathResource(path + "/" + cpResource));
                if (data == null) continue;
                this.cachedResources.put(cpResource, data);
                return new ByteArrayInputStream(data.array());
            }
            return null;
        }
        return super.resolveAndOpenStream(uri);
    }

    private boolean isClasspathScheme(String uri) {
        return uri.startsWith("classpath:");
    }

    private String stripClasspathScheme(String uri) {
        return uri.replaceFirst("^classpath:/*", "");
    }

    private String stripLeadingTrailingSlash(String path) {
        if (StringUtil.isBlank(path)) {
            return path;
        }
        String p = path.trim();
        p = StringUtil.removeStart(p, "/");
        p = StringUtil.removeEnd(p, "/");
        return p;
    }

    private ByteBuffer slurp(ClassPathResource cpResource) {
        return cpResource.getResourceAsByteBuffer();
    }
}

