/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.nanojson.JsonObject;
import com.github.jlangch.venice.nanojson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ReplConfig {
    public static final String ANSI_RESET = "\u001b[0m";
    private static final String DEFAULT_PROMPT = "venice> ";
    private static final String DEFAULT_SECONDARY_PROMPT = "| ";
    private static final String DEFAULT_RESULT_PREFIX = "=> ";
    private final Map<String, String> config;

    private ReplConfig(Map<String, String> config) {
        this.config = config;
    }

    public static ReplConfig load(CommandLineArgs cli) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("colors.use", cli.switchPresent("-colors") ? "true" : "false");
        try {
            JsonObject jsonObj = ReplConfig.loadJsonConfig();
            config.put("prompt", (String)jsonObj.get("prompt"));
            config.put("secondary-prompt", (String)jsonObj.get("secondary-prompt"));
            config.put("result-prefix", (String)jsonObj.get("result-prefix"));
            JsonObject colObj = (JsonObject)jsonObj.get("colors");
            if (colObj != null) {
                for (String cname : Arrays.asList("result", "stdout", "error", "system", "interrupt", "prompt")) {
                    config.put("colors." + cname, StringUtil.emptyToNull((String)colObj.get(cname)));
                }
            }
            return new ReplConfig(config);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse REPL json config file", ex);
        }
    }

    public String getColor(String key) {
        return this.useColors() ? this.get(key) : null;
    }

    public String get(String key) {
        return StringUtil.emptyToNull(this.config.get(key));
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        return val == null ? defaultValue : val;
    }

    public boolean useColors() {
        return "true".equals(this.config.get("colors.use"));
    }

    public String getPrompt() {
        String prompt = this.getOrDefault("prompt", DEFAULT_PROMPT);
        return !this.useColors() || this.get("colors.prompt") == null ? prompt : this.get("colors.prompt") + prompt + ANSI_RESET;
    }

    public String getSecondaryPrompt() {
        String prompt = this.getOrDefault("secondary-prompt", DEFAULT_SECONDARY_PROMPT);
        return !this.useColors() || this.get("colors.secondary-prompt") == null ? prompt : this.get("colors.secondary-prompt") + prompt + ANSI_RESET;
    }

    public String getResultPrefix() {
        return this.getOrDefault("result-prefix", DEFAULT_RESULT_PREFIX);
    }

    public static String getRawClasspathConfig() {
        return new ClassPathResource(VeniceClasspath.getVeniceBasePath() + "repl.json").getResourceAsString("UTF-8");
    }

    private static JsonObject loadJsonConfig() throws Exception {
        File fileJson = new File("repl.json");
        if (fileJson.isFile()) {
            System.out.println("Loading REPL config from " + fileJson + "...");
            return JsonParser.object().from(new FileReader(fileJson));
        }
        return JsonParser.object().from(ReplConfig.getRawClasspathConfig());
    }
}

