/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class VncBigDecimal
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final BigDecimal value;

    public VncBigDecimal(BigDecimal v) {
        this(v, Constants.Nil);
    }

    public VncBigDecimal(double v) {
        this(BigDecimal.valueOf(v), Constants.Nil);
    }

    public VncBigDecimal(long v) {
        this(BigDecimal.valueOf(v), Constants.Nil);
    }

    public VncBigDecimal(BigDecimal v, VncVal meta) {
        super(meta);
        this.value = v;
    }

    @Override
    public VncBigDecimal withMeta(VncVal meta) {
        return new VncBigDecimal(this.value, meta);
    }

    public VncBigDecimal negate() {
        return new VncBigDecimal(this.value.negate());
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int typeRank() {
        return 4;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(((VncBigDecimal)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(Numeric.intToDecimal((VncInteger)o).getValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(Numeric.doubleToDecimal((VncDouble)o).getValue());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(Numeric.longToDecimal((VncLong)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncBigDecimal other = (VncBigDecimal)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString() + "M";
    }

    public static RoundingMode toRoundingMode(VncString val) {
        return RoundingMode.valueOf(RoundingMode.class, val.getValue());
    }
}

