/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

public class StopWatch {
    private final Resolution resolution;
    private long startTime = 0L;
    private long elapsedTime = 0L;

    public StopWatch() {
        this(Resolution.MILLIS);
    }

    public StopWatch(Resolution resolution) {
        this.resolution = resolution;
        this.startTime = this.currentTime();
    }

    public static StopWatch millis() {
        return new StopWatch(Resolution.MILLIS);
    }

    public static StopWatch nanos() {
        return new StopWatch(Resolution.NANOS);
    }

    public StopWatch start() {
        this.startTime = this.currentTime();
        return this;
    }

    public StopWatch stop() {
        this.elapsedTime = this.splitTime();
        return this;
    }

    public long elapsedMillis() {
        return this.resolution == Resolution.NANOS ? this.elapsedTime / 1000000L : this.elapsedTime;
    }

    public long elapsedNanos() {
        return this.resolution == Resolution.NANOS ? this.elapsedTime : this.elapsedTime * 1000000L;
    }

    public long splitTime() {
        return Math.max(0L, this.currentTime() - this.startTime);
    }

    public String toString() {
        return this.resolution == Resolution.NANOS ? StopWatch.formatNanos(this.elapsedTime) : StopWatch.formatMillis(this.elapsedTime);
    }

    public static String formatMillis(long millis) {
        if (millis < 1000L) {
            return String.format("%dms", millis);
        }
        if (millis < 60000L) {
            return String.format("%ds %dms", millis / 1000L, millis % 1000L);
        }
        long seconds = millis / 1000L;
        return String.format("%dm %ds", seconds / 60L, seconds % 60L);
    }

    public static String formatNanos(long nanos) {
        if (nanos < 1000L) {
            return String.format("%dns", nanos);
        }
        if (nanos < 1000000L) {
            return String.format("%.3fus", Float.valueOf((float)nanos / 1000.0f));
        }
        if (nanos < 1000000000L) {
            long usecs = nanos / 1000L;
            return String.format("%.3fms", Float.valueOf((float)usecs / 1000.0f));
        }
        long millis = nanos / 1000000L;
        return String.format("%.3fs", Float.valueOf((float)millis / 1000.0f));
    }

    private long currentTime() {
        return this.resolution == Resolution.NANOS ? System.nanoTime() : System.currentTimeMillis();
    }

    public static enum Resolution {
        MILLIS,
        NANOS;

    }
}

