/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.beans.Transient;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ReflectionUtil {
    public static Class<?> classForName(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return Class.forName(name, true, contextClassLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return Class.forName(name);
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Failed to load class '%s'", name));
        }
    }

    public static boolean isClassAvailable(String name) {
        try {
            return ReflectionUtil.classForName(name) != null;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isGetter(Method method) {
        String methodName = method.getName();
        return (ReflectionUtil.isGetAccessor(methodName) || ReflectionUtil.isIsAccessor(methodName)) && !method.isBridge() && ReflectionUtil.arity(method) == 0 && !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isSetter(Method method) {
        String methodName = method.getName();
        return methodName.startsWith("set") && !method.isBridge() && methodName.length() > 3 && StringUtil.isAsciiAlphaUpper(methodName.charAt(3)) && ReflectionUtil.arity(method) == 1 && Void.TYPE.equals(method.getReturnType());
    }

    public static String getAttributeNameByGetter(Method getter) {
        if (!ReflectionUtil.isGetter(getter)) {
            throw new IllegalArgumentException("Passed method is not a getter!");
        }
        String name = getter.getName();
        if (name.startsWith("get")) {
            String p = name.substring(3);
            return String.valueOf(Character.toLowerCase(p.charAt(0))) + p.substring(1);
        }
        if (name.startsWith("is")) {
            String p = name.substring(2);
            return String.valueOf(Character.toLowerCase(p.charAt(0))) + p.substring(1);
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    public static Class<?> nearestSuperClass(Class<?> c1, Class<?> c2) {
        Class<?> s = c1;
        while (!s.isAssignableFrom(c2)) {
            s = s.getSuperclass();
        }
        return s;
    }

    public static Class<?> nearestSuperClass(Collection<Class<?>> classes) {
        return classes.stream().reduce(ReflectionUtil::nearestSuperClass).orElse(null);
    }

    public static Class<?> getGenericType(Class<?> clazz, int idx) {
        ParameterizedType parameterizedType;
        if (clazz.getGenericSuperclass() instanceof ParameterizedType && (parameterizedType = (ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments().length > idx) {
            Type rawType;
            Type type = parameterizedType.getActualTypeArguments()[idx];
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                return (Class)rawType;
            }
        }
        return null;
    }

    public static Class<?> getSuperclass(Class<?> type) {
        Class<?> parent = type.getSuperclass();
        if (parent == null || parent == Object.class) {
            return null;
        }
        return parent;
    }

    public static List<Class<?>> getAllDirectInterfaces(Class<?> type) {
        return Arrays.asList(type.getInterfaces());
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        ArrayList superclasses = new ArrayList();
        ReflectionUtil.getAllSuperclasses(ReflectionUtil.getSuperclass(clazz), superclasses);
        return superclasses;
    }

    private static void getAllSuperclasses(Class<?> clazz, List<Class<?>> superclasses) {
        if (clazz != null) {
            superclasses.add(clazz);
            ReflectionUtil.getAllSuperclasses(ReflectionUtil.getSuperclass(clazz), superclasses);
        }
    }

    public static List<Class<?>> getAllInterfaces(List<Class<?>> classes) {
        ArrayList interfaces = new ArrayList();
        classes.forEach(c -> ReflectionUtil.getAllInterfaces(c, interfaces));
        return interfaces;
    }

    private static void getAllInterfaces(Class<?> clazz, List<Class<?>> interfaces) {
        ReflectionUtil.getAllDirectInterfaces(clazz).forEach(c -> {
            interfaces.add((Class<?>)c);
            ReflectionUtil.getAllInterfaces(c, interfaces);
        });
    }

    public static List<Class<?>> distinct(List<Class<?>> classes) {
        HashSet visited = new HashSet();
        ArrayList distinct = new ArrayList();
        classes.forEach(c -> {
            if (!visited.contains(c)) {
                visited.add(c);
                distinct.add((Class<?>)c);
            }
        });
        return distinct;
    }

    public static boolean hasDefaultConstructor(Class<?> type) {
        try {
            return type.getConstructor(new Class[0]) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static Constructor<?> getDefaultConstructor(Class<?> type) {
        try {
            return type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static List<Constructor<?>> getPublicConstructors(Class<?> type, int numArgs) {
        ArrayList constructors = new ArrayList();
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (!Modifier.isPublic(c.getModifiers()) || c.getParameterTypes().length != numArgs) continue;
            constructors.add(c);
        }
        return constructors;
    }

    public static List<Method> getBeanGetterMethods(Class<?> type) {
        return ReflectionUtil.getAllPublicInstanceMethods(type, true).stream().filter(m -> ReflectionUtil.isBeanGetterMethod(m)).collect(Collectors.toList());
    }

    public static List<String> getBeanGetterProperties(Class<?> type) {
        return ReflectionUtil.getBeanGetterMethods(type).stream().map(m -> ReflectionUtil.getBeanPropertyName(m)).collect(Collectors.toList());
    }

    public static boolean isBeanGetterMethod(Method method) {
        if (!ReflectionUtil.isPublic(method)) {
            return false;
        }
        if (ReflectionUtil.isStatic(method)) {
            return false;
        }
        if (ReflectionUtil.isTransient(method)) {
            return false;
        }
        if (ReflectionUtil.arity(method) != 0) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("get") || name.startsWith("is");
    }

    public static List<Method> getBeanSetterMethods(Class<?> type) {
        return ReflectionUtil.getAllPublicInstanceMethods(type, true).stream().filter(m -> ReflectionUtil.isBeanSetterMethod(m)).collect(Collectors.toList());
    }

    public static List<String> getBeanSetterProperties(Class<?> type) {
        return ReflectionUtil.getBeanSetterMethods(type).stream().map(m -> ReflectionUtil.getBeanPropertyName(m)).collect(Collectors.toList());
    }

    public static boolean isBeanSetterMethod(Method method) {
        if (!ReflectionUtil.isPublic(method)) {
            return false;
        }
        if (ReflectionUtil.isStatic(method)) {
            return false;
        }
        if (ReflectionUtil.isTransient(method)) {
            return false;
        }
        if (ReflectionUtil.arity(method) != 1) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("set");
    }

    public static String getBeanPropertyName(Method method) {
        if (!ReflectionUtil.isBeanGetterMethod(method)) {
            throw new IllegalArgumentException("The passed method is not a bean property accessor");
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            String p = name.substring(3);
            return String.valueOf(Character.toLowerCase(p.charAt(0))) + p.substring(1);
        }
        if (name.startsWith("is")) {
            String p = name.substring(2);
            return String.valueOf(Character.toLowerCase(p.charAt(0))) + p.substring(1);
        }
        return null;
    }

    public static Method getBeanGetterMethod(Class<?> clazz, String propertyName) {
        return ReflectionUtil.getBeanGetterMethods(clazz).stream().filter(m -> ReflectionUtil.getBeanPropertyName(m).equals(propertyName)).findFirst().orElse(null);
    }

    public static Method getBeanSetterMethod(Class<?> clazz, String propertyName) {
        return ReflectionUtil.getBeanSetterMethods(clazz).stream().filter(m -> ReflectionUtil.getBeanPropertyName(m).equals(propertyName)).findFirst().orElse(null);
    }

    public static Field getPublicStaticField(Class<?> clazz, String name) {
        return Arrays.stream(clazz.getFields()).filter(f -> f.getName().equals(name)).filter(f -> ReflectionUtil.isPublic(f)).filter(f -> ReflectionUtil.isStatic(f)).findFirst().orElse(null);
    }

    public static Field getPublicInstanceField(Class<?> clazz, String name) {
        return Arrays.stream(clazz.getFields()).filter(f -> f.getName().equals(name)).filter(f -> ReflectionUtil.isPublic(f)).filter(f -> !ReflectionUtil.isStatic(f)).findFirst().orElse(null);
    }

    public static int arity(Constructor<?> constructor) {
        return constructor.getParameters().length;
    }

    public static int arity(Method method) {
        return method.getParameters().length;
    }

    public static boolean hasVarArgs(Method method) {
        return method.isVarArgs();
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isDeprecated(Method method) {
        return method.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isTransient(Method method) {
        return method.isAnnotationPresent(Transient.class);
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isPublic(Field field) {
        return Modifier.isPublic(field.getModifiers());
    }

    public static List<Method> getAllPublicInstanceMethods(Class<?> clazz, boolean includeInheritedClasses) {
        return ReflectionUtil.getAllPublicMethods(clazz, null, null, true, true, false, true, true);
    }

    public static List<Method> getAllPublicInstanceMethods(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return ReflectionUtil.getAllPublicMethods(clazz, methodName, arity, true, true, false, true, true);
    }

    public static List<Method> getAllPublicStaticMethods(Class<?> clazz, boolean includeInheritedClasses) {
        return ReflectionUtil.getAllPublicMethods(clazz, null, null, true, false, true, true, true);
    }

    public static List<Method> getAllPublicStaticMethods(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return ReflectionUtil.getAllPublicMethods(clazz, methodName, arity, true, false, true, true, true);
    }

    public static List<Method> getAllPublicMethods(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses, boolean addInstanceMethods, boolean addStaticMethods, boolean addTransientMethods, boolean addDeprecatedMethods) {
        Method[] methods = includeInheritedClasses ? clazz.getMethods() : clazz.getDeclaredMethods();
        return Arrays.stream(methods).filter(m -> methodName == null || methodName.equals(m.getName())).filter(m -> ReflectionUtil.isPublic(m)).filter(m -> !m.isBridge()).filter(m -> addInstanceMethods && addStaticMethods || addInstanceMethods && !ReflectionUtil.isStatic(m) || addStaticMethods && ReflectionUtil.isStatic(m)).filter(m -> addTransientMethods || !ReflectionUtil.isTransient(m)).filter(m -> addDeprecatedMethods || !ReflectionUtil.isDeprecated(m)).filter(m -> arity == null || arity == ReflectionUtil.arity(m)).collect(Collectors.toList());
    }

    private static boolean isGetAccessor(String methodName) {
        return methodName.startsWith("get") && methodName.length() > 3 && StringUtil.isAsciiAlphaUpper(methodName.charAt(3));
    }

    private static boolean isIsAccessor(String methodName) {
        return methodName.startsWith("is") && methodName.length() > 2 && StringUtil.isAsciiAlphaUpper(methodName.charAt(2));
    }
}

