/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.nanojson;

import java.math.BigDecimal;

public class JsonLazyNumber
extends Number {
    private String value;
    private boolean isDouble;

    public JsonLazyNumber(String number, boolean isDoubleValue) {
        this.value = number;
        this.isDouble = isDoubleValue;
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.value);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public int intValue() {
        return this.isDouble ? (int)Double.parseDouble(this.value) : Integer.parseInt(this.value);
    }

    @Override
    public long longValue() {
        return this.isDouble ? (long)Double.parseDouble(this.value) : Long.parseLong(this.value);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public boolean isDouble() {
        return this.isDouble;
    }

    private Object writeReplace() {
        return new BigDecimal(this.value);
    }
}

