/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class CapturingPrintStream
extends PrintStream {
    public static final int DEFAULT_LIMIT = 0xA00000;
    private final String encoding;
    private final LimitedByteArrayOutputStream boas;

    private CapturingPrintStream(String encoding, LimitedByteArrayOutputStream boas) throws UnsupportedEncodingException {
        super((OutputStream)boas, true, encoding);
        this.encoding = encoding;
        this.boas = boas;
    }

    public static CapturingPrintStream create() {
        return CapturingPrintStream.create(Charset.defaultCharset().name(), 0xA00000);
    }

    public static CapturingPrintStream create(int limit) {
        return CapturingPrintStream.create(Charset.defaultCharset().name(), limit);
    }

    public static CapturingPrintStream create(String encoding) {
        return CapturingPrintStream.create(encoding, 0xA00000);
    }

    public static CapturingPrintStream create(String encoding, int limit) {
        try {
            return new CapturingPrintStream(encoding, new LimitedByteArrayOutputStream(limit));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding: " + encoding, ex);
        }
    }

    public void reset() {
        this.boas.reset();
    }

    public boolean isEmpty() {
        return this.boas.size() == 0;
    }

    public String getOutput() {
        try {
            return this.boas.toString(this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding: " + this.encoding, ex);
        }
    }

    public byte[] getOutputAsBytes() {
        return this.boas.toByteArray();
    }

    private static class LimitedByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final int limit;
        private int count = 0;

        public LimitedByteArrayOutputStream(int limit) {
            this.limit = limit;
        }

        @Override
        public synchronized void write(int b) {
            this.validateGrowth(1);
            super.write(b);
            ++this.count;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            this.validateGrowth(len);
            super.write(b, off, len);
            this.count += len;
        }

        @Override
        public synchronized void writeTo(OutputStream out) throws IOException {
            super.writeTo(out);
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.count = 0;
        }

        @Override
        public synchronized byte[] toByteArray() {
            return super.toByteArray();
        }

        @Override
        public synchronized int size() {
            return this.count;
        }

        @Override
        public synchronized String toString() {
            return super.toString();
        }

        @Override
        public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
            return super.toString(charsetName);
        }

        private void validateGrowth(int len) {
            if (this.count + len > this.limit) {
                throw new SecurityException(String.format("CapturingPrintStream exceeded the limit of %d bytes", this.limit));
            }
        }
    }
}

