/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.pdf.HtmlColor;
import com.github.jlangch.venice.pdf.PdfRenderer;
import com.github.jlangch.venice.pdf.PdfWatermark;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class PdfFunctions {
    public static VncFunction pdf_render = new VncFunction("pdf/render", VncFunction.meta().arglists("(pdf/render xhtml & options)").doc("Renders a PDF.\n\nOptions: \n  :base-url url        - a base url. E.g.: \"classpath:/\"\n  :resources resmap    - a resource map for dynamic resources\n").examples("(pdf/render xhtm :base-url \"classpath:/\")", "(pdf/render xhtm \n            :base-url \"classpath:/\"\n            :resources {\"/chart_1.png\" (chart-create :2018) \n                        \"/chart_2.png\" (chart-create :2019) })").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("pdf/render", args, 1);
            VncString xhtml = Coerce.toVncString(args.first());
            VncHashMap options = VncHashMap.ofAll(args.slice(1));
            VncVal baseUrl = ((VncMap)options).get(new VncKeyword("base-url"));
            VncVal resources = ((VncMap)options).get(new VncKeyword("resources"));
            VncLong dotsPerPixel = PdfFunctions.getVncLongOption("dots-per-pixel", options, 20L);
            VncDouble dotsPerPoint = PdfFunctions.getVncDoubleOption("dots-per-point", options, 26.66666603088379);
            return new VncByteBuffer(PdfRenderer.render(xhtml.getValue(), baseUrl == Constants.Nil ? null : Coerce.toVncString(baseUrl).getValue(), resources == Constants.Nil ? null : PdfFunctions.mapResources(Coerce.toVncMap(resources)), Coerce.toVncLong(dotsPerPixel).getValue().intValue(), Coerce.toVncDouble(dotsPerPoint).getValue().floatValue()));
        }
    };
    public static VncFunction pdf_watermark = new VncFunction("pdf/watermark", VncFunction.meta().arglists("(pdf/watermark pdf options-map)", "(pdf/watermark pdf & options)").doc("Adds a watermark text to the pages of a PDF. The passed PDF pdf is a bytebuf. Returns the new PDF as a bytebuf.\n\nOptions: \n  :text s              - watermark text (string), defaults to \"WATERMARK\" \n  :font-size n         - font size in pt (double), defaults to 24.0 \n  :font-char-spacing n - font character spacing (double), defaults to 0.0 \n  :color s             - font color (HTML color string), defaults to #000000 \n  :opacity n           - opacity 0.0 ... 1.0 (double), defaults to 0.4 \n  :angle n             - angle 0.0 ... 360.0 (double), defaults to 45.0 \n  :over-content b      - print text over the content (boolean), defaults to true \n  :skip-top-pages n    - the number of top pages to skip (long), defaults to 0 \n  :skip-bottom-pages n - the number of bottom pages to skip (long), defaults to 0").examples("(pdf/watermark pdf :text \"CONFIDENTIAL\" :font-size 64 :font-char-spacing 10.0)", "(let [watermark { :text \"CONFIDENTIAL\"      \n                  :font-size 64               \n                  :font-char-spacing 10.0 } ] \n   (pdf/watermark pdf watermark))                ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("pdf/watermark", args, 2);
            VncVal pdf = args.first();
            VncMap options = Types.isVncMap(args.second()) ? Coerce.toVncMap(args.second()) : VncHashMap.ofAll(args.slice(1));
            VncVal text = options.get(new VncKeyword("text", new VncString("WATERMARK")));
            VncDouble fontSize = PdfFunctions.getVncDoubleOption("font-size", options, 24.0);
            VncDouble fontCharSpacing = PdfFunctions.getVncDoubleOption("font-char-spacing", options, 0.0);
            VncVal color = options.get(new VncKeyword("color", new VncString("#000000")));
            VncDouble opacity = PdfFunctions.getVncDoubleOption("opacity", options, 0.4);
            VncDouble angle = PdfFunctions.getVncDoubleOption("angle", options, 45.0);
            VncConstant overContent = PdfFunctions.getBooleanOption("over-content", options, true);
            VncLong skipTopPages = PdfFunctions.getVncLongOption("skip-top-pages", options, 0L);
            VncLong skipBottomPages = PdfFunctions.getVncLongOption("skip-bottom-pages", options, 0L);
            ByteBuffer pdf_ = Coerce.toVncByteBuffer(pdf).getValue();
            String text_ = Coerce.toVncString(text).getValue();
            float fontSize_ = Coerce.toVncDouble(fontSize).getValue().floatValue();
            float fontCharSpacing_ = Coerce.toVncDouble(fontCharSpacing).getValue().floatValue();
            Color color_ = HtmlColor.getColor(Coerce.toVncString(color).getValue());
            float opacity_ = Coerce.toVncDouble(opacity).getValue().floatValue();
            float angle_ = Coerce.toVncDouble(angle).getValue().floatValue();
            boolean overContent_ = Coerce.toVncBoolean(overContent) == Constants.True;
            int skipTopPages_ = Coerce.toVncLong(skipTopPages).getValue().intValue();
            int skipBottomPages_ = Coerce.toVncLong(skipBottomPages).getValue().intValue();
            if (StringUtil.isBlank(text_)) {
                return pdf;
            }
            return new VncByteBuffer(new PdfWatermark().addWatermarkText(pdf_, text_, fontSize_, fontCharSpacing_, color_, opacity_, angle_, overContent_, skipTopPages_, skipBottomPages_));
        }
    };
    public static VncFunction pdf_available_Q = new VncFunction("pdf/available?", VncFunction.meta().arglists("(pdf/available?)").doc("Checks if the 3rd party libraries required for generating PDFs are available.").examples("(pdf/available?)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pdf/available?", args, 0);
            if (!ReflectionAccessor.classExists("com.lowagie.text.Anchor")) {
                return Constants.False;
            }
            if (!ReflectionAccessor.classExists("org.xhtmlrenderer.DefaultCSSMarker")) {
                return Constants.False;
            }
            if (!ReflectionAccessor.classExists("org.xhtmlrenderer.pdf.AbstractFormField")) {
                return Constants.False;
            }
            return Constants.True;
        }
    };
    public static VncFunction pdf_merge = new VncFunction("pdf/merge", VncFunction.meta().arglists("pdf/merge pdfs").doc("Merge multiple PDFs into a single PDF.").examples("(pdf/merge pdf1 pdf2)", "(pdf/merge pdf1 pdf2 pdf3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("pdf/merge", args, 1);
            List<VncVal> pdfs = args.getList();
            if (pdfs.isEmpty()) {
                throw new VncException("pdf/merge: A PDF list must not be empty");
            }
            if (pdfs.size() == 1) {
                return pdfs.get(0);
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                Document document = new Document();
                PdfCopy copy = new PdfCopy(document, (OutputStream)os);
                document.open();
                for (VncVal val : pdfs) {
                    if (val == Constants.Nil) continue;
                    ByteBuffer pdf = Coerce.toVncByteBuffer(val).getValue();
                    PdfReader reader = new PdfReader(pdf.array());
                    for (int ii = 1; ii <= reader.getNumberOfPages(); ++ii) {
                        copy.addPage(copy.getImportedPage(reader, ii));
                    }
                    copy.freeReader(reader);
                    reader.close();
                }
                document.close();
                copy.close();
                return new VncByteBuffer(os.toByteArray());
            }
            catch (Exception ex) {
                throw new VncException(String.format("pdf/merge: Failed to merge %d PDFs", pdfs.size()), ex);
            }
        }
    };
    public static VncFunction pdf_copy = new VncFunction("pdf/copy", VncFunction.meta().arglists("pdf/copy pdf & page-nr").doc("Copies pages from a PDF to a new PDF.").examples("; copy the first and second page \n(pdf/copy pdf :1 :2)", "; copy the last and second last page \n(pdf/copy pdf :-1 :-2)", "; copy the pages 1, 2, 6-10, and 12 \n(pdf/copy pdf :1 :2 :6-10 :12)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("pdf/copy", args, 1);
            ByteBuffer pdf = Coerce.toVncByteBuffer(args.first()).getValue();
            ArrayList<List<Integer>> pages = new ArrayList<List<Integer>>();
            for (VncVal p : args.rest().getList()) {
                String spec = Coerce.toVncKeyword(p).getValue();
                if (spec.matches("^[0-9]+$")) {
                    pages.add(Arrays.asList(Integer.parseInt(spec)));
                    continue;
                }
                if (spec.matches("^-[0-9]+$")) {
                    pages.add(Arrays.asList(Integer.parseInt(spec)));
                    continue;
                }
                if (spec.matches("^[0-9]+-[0-9]+$")) {
                    String[] range = spec.split("-");
                    int start = Integer.parseInt(range[0]);
                    int end = Integer.parseInt(range[1]);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int ii = start; ii <= end; ++ii) {
                        arrayList.add(ii);
                    }
                    pages.add(arrayList);
                    continue;
                }
                throw new VncException("pdf/copy: Invalid page specifier " + spec);
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                Document document = new Document();
                PdfCopy copy = new PdfCopy(document, (OutputStream)os);
                document.open();
                PdfReader reader = new PdfReader(pdf.array());
                int numPages = reader.getNumberOfPages();
                for (List list : pages) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int p = (Integer)iterator.next();
                        int page = p < 0 ? numPages + p + 1 : p;
                        if (page <= 0 || page > numPages) continue;
                        copy.addPage(copy.getImportedPage(reader, page));
                    }
                }
                copy.freeReader(reader);
                reader.close();
                document.close();
                copy.close();
                return new VncByteBuffer(os.toByteArray());
            }
            catch (Exception ex) {
                throw new VncException("pdf/copy: Failed to copy PDFs", ex);
            }
        }
    };
    public static VncFunction pdf_pages = new VncFunction("pdf/pages", VncFunction.meta().arglists("pdf/pages pdf").doc("Returns the number of pages of a PDF.").examples("(pdf/pages pdf)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pdf/pages", args, 1);
            ByteBuffer pdf = Coerce.toVncByteBuffer(args.first()).getValue();
            try {
                PdfReader reader = new PdfReader(pdf.array());
                int pages = reader.getNumberOfPages();
                reader.close();
                return new VncLong(pages);
            }
            catch (Exception ex) {
                throw new VncException("pdf/pages: Failed to count the PDF's pages", ex);
            }
        }
    };
    public static VncFunction pdf_text_to_pdf = new VncFunction("pdf/text-to-pdf", VncFunction.meta().arglists("pdf/text-to-pdf text & options").doc("Creates a PDF from simple text. The tool process line-feeds '\\n' and form-feeds. To start a new page just insert a form-feed marker \"<form-feed>\".\n\nOptions: \n  :font-size n      - font size in pt (double), defaults to 9.0\n  :font-weight n    - font weight (0...1000) (long), defaults to 200\n  :font-monospace b - monospaced font (true/false) (boolean), defaults to false").examples("(->> (pdf/text-to-pdf \"Lorem Ipsum...\")   \n     (io/spit \"text.pdf\"))                  ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("pdf/text-to-pdf", args, 1);
            try {
                String text = Coerce.toVncString(args.first()).getValue();
                VncHashMap options = VncHashMap.ofAll(args.slice(1));
                VncDouble fontSize = PdfFunctions.getVncDoubleOption("font-size", options, 9.0);
                VncLong fontWeight = PdfFunctions.getVncLongOption("font-weight", options, 200L);
                VncConstant fontMonoSpace = PdfFunctions.getBooleanOption("font-monospace", options, false);
                List pages = PdfFunctions.splitIntoPages(text).stream().map(p -> PdfFunctions.splitIntoLines(p)).collect(Collectors.toList());
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("pages", pages);
                data.put("fontSize", fontSize.getValue().toString());
                data.put("fontWeight", fontWeight.getValue().toString());
                data.put("fontFamiliy", fontMonoSpace == Constants.True ? "Courier" : "Helvetica, Sans-Serif");
                String template = PdfFunctions.loadText2PdfTemplate();
                String xhtml = (String)PdfFunctions.runAsync(() -> PdfFunctions.evaluateTemplate(template, data));
                return new VncByteBuffer(PdfRenderer.render(xhtml));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to render text PDF", ex);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(pdf_available_Q).add(pdf_render).add(pdf_watermark).add(pdf_merge).add(pdf_copy).add(pdf_pages).add(pdf_text_to_pdf).toMap();

    private static Map<String, ByteBuffer> mapResources(VncMap resourceMap) {
        HashMap<String, ByteBuffer> resources = new HashMap<String, ByteBuffer>();
        for (VncMapEntry entry : resourceMap.entries()) {
            resources.put(Coerce.toVncString(entry.getKey()).getValue(), Coerce.toVncByteBuffer(entry.getValue()).getValue());
        }
        return resources;
    }

    private static String loadText2PdfTemplate() {
        return new ClassPathResource("com/github/jlangch/venice/templates/text-2-pdf.kira").getResourceAsString();
    }

    private static String evaluateTemplate(String template, Map<String, Object> data) {
        String script = "(do                                           \n   (load-module :kira)                        \n   (kira/eval template [\"${\" \"}$\"] data))   ";
        return (String)new Venice().eval("(do                                           \n   (load-module :kira)                        \n   (kira/eval template [\"${\" \"}$\"] data))   ", Parameters.of("template", template, "data", data));
    }

    private static <T> T runAsync(Callable<T> callable) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            T t = executor.submit(callable).get();
            return t;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static List<String> splitIntoPages(String text) {
        ArrayList<String> pages = new ArrayList<String>();
        if (text != null && !text.isEmpty()) {
            int lastPos = 0;
            while (lastPos < text.length()) {
                int pos = text.indexOf("<form-feed>", lastPos);
                if (pos < 0) {
                    pages.add(text.substring(lastPos));
                    break;
                }
                pages.add(text.substring(lastPos, pos));
                lastPos = pos + "<form-feed>".length();
            }
        }
        return pages;
    }

    private static List<String> splitIntoLines(String text) {
        return StringUtil.splitIntoLines(text).stream().map(s -> StringUtil.isBlank(s) ? "\u2002" : s).map(s -> StringUtil.replaceLeadingSpaces(s, '\u00a0')).collect(Collectors.toList());
    }

    private static VncDouble getVncDoubleOption(String optName, VncMap options, double defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), new VncDouble(defaultVal));
        if (Types.isVncLong(val)) {
            return new VncDouble(((VncLong)val).getValue().doubleValue());
        }
        if (Types.isVncInteger(val)) {
            return new VncDouble(((VncInteger)val).getValue().doubleValue());
        }
        if (Types.isVncDouble(val)) {
            return (VncDouble)val;
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val));
    }

    private static VncLong getVncLongOption(String optName, VncMap options, long defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), new VncLong(defaultVal));
        if (Types.isVncLong(val)) {
            return (VncLong)val;
        }
        if (Types.isVncInteger(val)) {
            return new VncLong(((VncInteger)val).getValue().longValue());
        }
        if (Types.isVncDouble(val)) {
            return new VncLong(((VncDouble)val).getValue().longValue());
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val));
    }

    private static VncConstant getBooleanOption(String optName, VncMap options, boolean defaultVal) {
        VncVal val = options.get(new VncKeyword(optName), defaultVal ? Constants.True : Constants.False);
        if (val == Constants.True) {
            return Constants.True;
        }
        if (val == Constants.False) {
            return Constants.False;
        }
        throw new VncException("Invalid '" + optName + "' option type " + Types.getType(val));
    }
}

