/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class VncJavaList
extends VncSequence
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final List<Object> value;

    public VncJavaList() {
        this(null, null);
    }

    public VncJavaList(VncVal meta) {
        this(null, meta);
    }

    public VncJavaList(List<Object> val) {
        this(val, null);
    }

    public VncJavaList(List<Object> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncList empty() {
        return new VncList(this.getMeta());
    }

    @Override
    public VncList withVariadicValues(VncVal ... replaceVals) {
        return VncList.of(replaceVals);
    }

    @Override
    public VncList withValues(List<? extends VncVal> vals) {
        return new VncList(vals, this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> vals, VncVal meta) {
        return new VncList(vals, meta);
    }

    @Override
    public VncJavaList withMeta(VncVal meta) {
        return new VncJavaList(this.value, meta);
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept(JavaInteropUtil.convertToVncVal(v)));
    }

    @Override
    public List<VncVal> getList() {
        return this.value.stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException("nth: index out of range");
        }
        return JavaInteropUtil.convertToVncVal(this.value.get(idx));
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.nth(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.nthOrDefault(0, Constants.Nil);
    }

    @Override
    public VncVal second() {
        return this.nthOrDefault(1, Constants.Nil);
    }

    @Override
    public VncVal third() {
        return this.nthOrDefault(2, Constants.Nil);
    }

    @Override
    public VncVal fourth() {
        return this.nthOrDefault(3, Constants.Nil);
    }

    @Override
    public VncVal last() {
        return this.nthOrDefault(this.value.size() - 1, Constants.Nil);
    }

    @Override
    public VncList rest() {
        if (this.isEmpty()) {
            return new VncList();
        }
        return new VncList(this.value.subList(1, this.value.size()).stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList()));
    }

    @Override
    public VncList slice(int start, int end) {
        return new VncList(this.value.subList(start, end).stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList()));
    }

    @Override
    public VncList slice(int start) {
        return this.slice(start, this.value.size());
    }

    @Override
    public VncJavaList setAt(int idx, VncVal val) {
        this.value.set(idx, val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaList removeAt(int idx) {
        this.value.remove(idx);
        return this;
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.getList(), this.getMeta());
    }

    @Override
    public VncJavaList addAtStart(VncVal val) {
        this.value.add(0, val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaList addAllAtStart(VncSequence list) {
        List<VncVal> items = list.getList();
        for (int ii = 0; ii < items.size(); ++ii) {
            this.value.add(0, items.get(ii).convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncJavaList addAtEnd(VncVal val) {
        this.value.add(val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaList addAllAtEnd(VncSequence list) {
        List<VncVal> items = list.getList();
        for (int ii = 0; ii < items.size(); ++ii) {
            this.value.add(items.get(ii).convertToJavaObject());
        }
        return this;
    }

    @Override
    public int typeRank() {
        return 202;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJavaList(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncJavaList)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncJavaList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaList other = (VncJavaList)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(" + Printer.join(this.getList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.getList(), " ", print_readably) + ")";
    }
}

