/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class VncTinyList
extends VncList {
    private static final long serialVersionUID = -1848883965231344442L;
    private final int len;
    private final VncVal first;
    private final VncVal second;
    private final VncVal third;

    public VncTinyList() {
        this((VncVal)null);
    }

    public VncTinyList(VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.len = 0;
        this.first = null;
        this.second = null;
        this.third = null;
    }

    public VncTinyList(VncVal first, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.len = 1;
        this.first = first;
        this.second = null;
        this.third = null;
    }

    public VncTinyList(VncVal first, VncVal second, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.len = 2;
        this.first = first;
        this.second = second;
        this.third = null;
    }

    public VncTinyList(VncVal first, VncVal second, VncVal third, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.len = 3;
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static VncList of(VncVal ... mvs) {
        switch (mvs.length) {
            case 0: {
                return new VncTinyList();
            }
            case 1: {
                return new VncTinyList(mvs[0], null);
            }
            case 2: {
                return new VncTinyList(mvs[0], mvs[1], null);
            }
            case 3: {
                return new VncTinyList(mvs[0], mvs[1], mvs[2], null);
            }
        }
        return VncList.of(mvs);
    }

    private static VncList ofList(List<? extends VncVal> list, VncVal meta) {
        switch (list.size()) {
            case 0: {
                return new VncTinyList(meta);
            }
            case 1: {
                return new VncTinyList(list.get(0), meta);
            }
            case 2: {
                return new VncTinyList(list.get(0), list.get(1), meta);
            }
            case 3: {
                return new VncTinyList(list.get(0), list.get(1), list.get(2), meta);
            }
        }
        return new VncList(list, meta);
    }

    @Override
    public VncList empty() {
        return new VncTinyList(this.getMeta());
    }

    @Override
    public VncList withVariadicValues(VncVal ... replaceVals) {
        return VncTinyList.of(replaceVals);
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals) {
        return VncTinyList.ofList(replaceVals, this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return VncTinyList.ofList(replaceVals, meta);
    }

    @Override
    public VncList withMeta(VncVal meta) {
        switch (this.len) {
            case 0: {
                return new VncTinyList(meta);
            }
            case 1: {
                return new VncTinyList(this.first, meta);
            }
            case 2: {
                return new VncTinyList(this.first, this.second, meta);
            }
            case 3: {
                return new VncTinyList(this.first, this.second, this.third, meta);
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.getList().forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public List<VncVal> getList() {
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        switch (this.len) {
            case 0: {
                break;
            }
            case 1: {
                list.add(this.first);
                break;
            }
            case 2: {
                list.add(this.first);
                list.add(this.second);
                break;
            }
            case 3: {
                list.add(this.first);
                list.add(this.second);
                list.add(this.third);
                break;
            }
            default: {
                throw new IllegalStateException("List length out of range");
            }
        }
        return list;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.len) {
            throw new VncException(String.format("nth: index %d out of range for a list of size %d. %s", idx, this.len, this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.first)));
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        if (idx >= 0 && idx < this.size()) {
            switch (idx) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
                case 2: {
                    return this.third;
                }
            }
            return defaultVal == null ? Constants.Nil : defaultVal;
        }
        return defaultVal;
    }

    @Override
    public VncVal first() {
        return this.len >= 1 ? this.first : Constants.Nil;
    }

    @Override
    public VncVal second() {
        return this.len >= 2 ? this.second : Constants.Nil;
    }

    @Override
    public VncVal third() {
        return this.len >= 3 ? this.third : Constants.Nil;
    }

    @Override
    public VncVal last() {
        switch (this.len) {
            case 0: {
                return Constants.Nil;
            }
            case 1: {
                return this.first;
            }
            case 2: {
                return this.second;
            }
            case 3: {
                return this.third;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList rest() {
        switch (this.len) {
            case 0: {
                return new VncTinyList(this.getMeta());
            }
            case 1: {
                return new VncTinyList(this.getMeta());
            }
            case 2: {
                return new VncTinyList(this.second, this.getMeta());
            }
            case 3: {
                return new VncTinyList(this.second, this.third, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList slice(int start, int end) {
        return VncTinyList.ofList(this.getList().subList(start, end), this.getMeta());
    }

    @Override
    public VncList slice(int start) {
        return VncTinyList.ofList(this.getList().subList(start, this.len), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.getList(), this.getMeta());
    }

    @Override
    public VncList addAtStart(VncVal val) {
        List<VncVal> vals = this.getList();
        vals.add(0, val);
        return VncTinyList.ofList(vals, this.getMeta());
    }

    @Override
    public VncList addAllAtStart(VncSequence list) {
        ArrayList<VncVal> vals = new ArrayList<VncVal>(list.getList());
        Collections.reverse(vals);
        vals.addAll(this.getList());
        return VncTinyList.ofList(vals, this.getMeta());
    }

    @Override
    public VncList addAtEnd(VncVal val) {
        List<VncVal> vals = this.getList();
        vals.add(val);
        return VncTinyList.ofList(vals, this.getMeta());
    }

    @Override
    public VncList addAllAtEnd(VncSequence list) {
        List<VncVal> vals = this.getList();
        vals.addAll(list.getList());
        return VncTinyList.ofList(vals, this.getMeta());
    }

    @Override
    public VncList setAt(int idx, VncVal val) {
        List<VncVal> vals = this.getList();
        vals.set(idx, val);
        return VncTinyList.ofList(vals, this.getMeta());
    }

    @Override
    public VncList removeAt(int idx) {
        List<VncVal> vals = this.getList();
        vals.remove(idx);
        return VncTinyList.ofList(vals, this.getMeta());
    }

    @Override
    public int typeRank() {
        return 200;
    }

    @Override
    public Object convertToJavaObject() {
        return this.getList().stream().map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncList(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncTinyList)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncTinyList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + this.len;
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + (this.third == null ? 0 : this.third.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncTinyList other = (VncTinyList)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.len != other.len) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        return !(this.third == null ? other.third != null : !this.third.equals(other.third));
    }

    @Override
    public String toString() {
        return "(" + Printer.join(this.getList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.getList(), " ", print_readably) + ")";
    }
}

