/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionTypes {
    public static boolean isBaseType(Class<?> type) {
        return ReflectionTypes.isStringType(type) || ReflectionTypes.isCharType(type) || ReflectionTypes.isBooleanType(type) || ReflectionTypes.isByteType(type) || ReflectionTypes.isIntegerType(type) || ReflectionTypes.isFloatType(type);
    }

    public static boolean isEnumType(Class<?> type) {
        return type.isEnum();
    }

    public static boolean isArrayType(Class<?> type) {
        return type.isArray();
    }

    public static boolean isStringType(Class<?> type) {
        return String.class == type;
    }

    public static boolean isCharType(Class<?> type) {
        return ReflectionTypes.isPrimitiveCharType(type) || ReflectionTypes.isObjectCharType(type);
    }

    public static boolean isPrimitiveCharType(Class<?> type) {
        return type == Character.TYPE;
    }

    public static boolean isObjectCharType(Class<?> type) {
        return type == Character.class;
    }

    public static boolean isByteType(Class<?> type) {
        return ReflectionTypes.isPrimitiveByteType(type) || ReflectionTypes.isObjectByteType(type);
    }

    public static boolean isPrimitiveByteType(Class<?> type) {
        return type == Byte.TYPE;
    }

    public static boolean isObjectByteType(Class<?> type) {
        return type == Byte.class;
    }

    public static boolean isDateType(Class<?> type) {
        return type == Date.class;
    }

    public static boolean isBigIntegerType(Class<?> type) {
        return type == BigInteger.class;
    }

    public static boolean isBigDecimalType(Class<?> type) {
        return type == BigDecimal.class;
    }

    public static boolean isNumberType(Class<?> type) {
        return ReflectionTypes.isIntegerType(type) || ReflectionTypes.isFloatType(type);
    }

    public static boolean isIntegerType(Class<?> type) {
        return ReflectionTypes.isPrimitiveIntegerType(type) || ReflectionTypes.isObjectIntegerType(type);
    }

    public static boolean isBooleanType(Class<?> type) {
        return ReflectionTypes.isPrimitiveBooleanType(type) || ReflectionTypes.isObjectBooleanType(type);
    }

    public static boolean isPrimitiveBooleanType(Class<?> type) {
        return type == Boolean.TYPE;
    }

    public static boolean isObjectBooleanType(Class<?> type) {
        return type == Boolean.class;
    }

    public static boolean isPrimitiveIntegerType(Class<?> type) {
        return type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE;
    }

    public static boolean isObjectIntegerType(Class<?> type) {
        return type == Short.class || type == Integer.class || type == Long.class || type == BigInteger.class;
    }

    public static boolean isFloatType(Class<?> type) {
        return ReflectionTypes.isPrimitiveFloatType(type) || ReflectionTypes.isObjectFloatType(type);
    }

    public static boolean isPrimitiveFloatType(Class<?> type) {
        return type == Float.TYPE || type == Double.TYPE;
    }

    public static boolean isObjectFloatType(Class<?> type) {
        return type == Float.class || type == Double.class || type == BigDecimal.class;
    }

    public static boolean isAbstractType(Class<?> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static List<String> enumValues(Class<? extends Enum<?>> clazz) {
        ArrayList<String> values = new ArrayList<String>();
        for (Enum<?> e : clazz.getEnumConstants()) {
            values.add(e.name());
        }
        return values;
    }

    public static boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static boolean isList(Class<?> type) {
        return List.class.isAssignableFrom(type);
    }

    public static boolean isList(ParameterizedType type) {
        return ReflectionTypes.isList((Class)type.getRawType());
    }

    public static boolean isSet(Class<?> type) {
        return Set.class.isAssignableFrom(type);
    }

    public static boolean isSet(ParameterizedType type) {
        return ReflectionTypes.isSet((Class)type.getRawType());
    }

    public static boolean isListOrSet(Class<?> type) {
        return ReflectionTypes.isList(type) || ReflectionTypes.isSet(type);
    }

    public static boolean isListOrSet(ParameterizedType type) {
        return ReflectionTypes.isList(type) || ReflectionTypes.isSet(type);
    }

    public static boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static boolean isMap(ParameterizedType type) {
        return ReflectionTypes.isMap((Class)type.getRawType());
    }

    public static boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static Type[] getParameterizedTypeArguments(Type type) {
        if (!ReflectionTypes.isParameterizedType(type)) {
            throw new RuntimeException("Not a ParameterizedType");
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public static boolean isParameterizedTypeWithArgumentTypes(Type type, Class<?> argType1, Class<?> argType2) {
        if (!ReflectionTypes.isParameterizedType(type)) {
            return false;
        }
        Type[] elementTypes = ReflectionTypes.getParameterizedTypeArguments(type);
        if (elementTypes.length != 2) {
            return false;
        }
        for (int ii = 0; ii < elementTypes.length; ++ii) {
            if (!ReflectionTypes.isParameterizedType(elementTypes[ii])) continue;
            return false;
        }
        return argType1 == (Class)elementTypes[0] && argType2 == (Class)elementTypes[1];
    }

    public static List<String> extractGenericTypes(Type type) {
        if (!ReflectionTypes.isParameterizedType(type)) {
            throw new IllegalArgumentException("Not a parameterized type");
        }
        ArrayList<String> genericTypes = new ArrayList<String>();
        Type[] actualArguments = ((ParameterizedType)type).getActualTypeArguments();
        for (int ii = 0; ii < actualArguments.length; ++ii) {
            Type actType = actualArguments[ii];
            if (actType instanceof ParameterizedType) {
                genericTypes.addAll(ReflectionTypes.extractGenericTypes((ParameterizedType)actType));
                continue;
            }
            String stdType = actType.toString();
            if (stdType.startsWith("class ")) {
                genericTypes.add(stdType.substring("class ".length()));
                continue;
            }
            if (!stdType.startsWith("interface ")) continue;
            genericTypes.add(stdType.substring("interface ".length()));
        }
        return genericTypes;
    }
}

