/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.LoadPath;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.repl.REPL;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.FileUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class Launcher {
    public static void main(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        AcceptAllInterceptor interceptor = new AcceptAllInterceptor();
        JavaInterop.register(interceptor);
        List<String> loadPaths = LoadPath.parseFromString(cli.switchValue("-loadpath"));
        try {
            if (cli.switchPresent("-file")) {
                VeniceInterpreter venice = new VeniceInterpreter(interceptor, loadPaths);
                Env env = Launcher.createEnv(venice, cli);
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-file"));
                String script = new String(FileUtil.load(new File(file)));
                System.out.println(venice.PRINT(venice.RE(script, new File(file).getName(), env)));
            } else if (cli.switchPresent("-script")) {
                VeniceInterpreter venice = new VeniceInterpreter(interceptor, loadPaths);
                Env env = Launcher.createEnv(venice, cli);
                String script = cli.switchValue("-script");
                System.out.println(venice.PRINT(venice.RE(script, "script", env)));
            } else if (cli.switchPresent("-repl")) {
                new REPL(interceptor, loadPaths).run(args);
            } else {
                new REPL(interceptor, loadPaths).run(args);
            }
            System.exit(0);
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static Env createEnv(VeniceInterpreter venice, CommandLineArgs cli) {
        return venice.createEnv().setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList())).setStdoutPrintStream(new PrintStream(System.out, true));
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s == null ? null : (s.endsWith(".venice") ? s : s + ".venice");
    }
}

