/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.JavaValueException;
import com.github.jlangch.venice.PreCompiled;
import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.LoadPath;
import com.github.jlangch.venice.impl.SandboxedCallable;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.functions.ConcurrencyFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.util.NullOutputStream;
import com.github.jlangch.venice.util.Timer;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Venice {
    private static final AtomicLong timeoutThreadPoolCounter = new AtomicLong(0L);
    private static final ExecutorService executor = Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("venice-timeout-pool-%d", timeoutThreadPoolCounter, true));
    private final IInterceptor interceptor;
    private final List<String> loadPaths;
    private final MeterRegistry meterRegistry = new MeterRegistry(false);
    private final AtomicReference<Env> precompiledEnv = new AtomicReference<Object>(null);
    private final PrintStream stdout = new PrintStream(System.out, true);

    public Venice() {
        this(null, null);
    }

    public Venice(IInterceptor interceptor) {
        this(interceptor, null);
    }

    public Venice(IInterceptor interceptor, List<String> loadPaths) {
        this.interceptor = interceptor == null ? new AcceptAllInterceptor() : interceptor;
        this.loadPaths = LoadPath.sanitize(loadPaths);
    }

    public PreCompiled precompile(String scriptName, String script) {
        if (StringUtil.isBlank(scriptName)) {
            throw new IllegalArgumentException("A 'scriptName' must not be blank");
        }
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        long nanos = System.nanoTime();
        VeniceInterpreter venice = new VeniceInterpreter(new MeterRegistry(false), this.interceptor, this.loadPaths);
        PreCompiled pc = new PreCompiled(scriptName, venice.READ(script, scriptName));
        this.meterRegistry.record("venice.precompile", System.nanoTime() - nanos);
        return pc;
    }

    public Object eval(PreCompiled precompiled) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        return this.eval(precompiled, null);
    }

    public Object eval(PreCompiled precompiled, Map<String, Object> params) {
        if (precompiled == null) {
            throw new IllegalArgumentException("A 'precompiled' script must not be null");
        }
        this.meterRegistry.disable();
        long nanos = System.nanoTime();
        return this.runWithSandbox(() -> {
            ThreadLocalMap.clear();
            VeniceInterpreter venice = new VeniceInterpreter(this.meterRegistry, this.interceptor, this.loadPaths);
            Env env = this.addParams(this.getPrecompiledEnv(), params);
            venice.initNS();
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("venice.setup", System.nanoTime() - nanos);
            }
            VncVal result = venice.EVAL((VncVal)precompiled.getPrecompiled(), env);
            Object jResult = result.convertToJavaObject();
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("venice.total", System.nanoTime() - nanos);
            }
            return jResult;
        });
    }

    public Object eval(String script) {
        return this.eval(null, script, null);
    }

    public Object eval(String scriptName, String script) {
        return this.eval(scriptName, script, null);
    }

    public Object eval(String script, Map<String, Object> params) {
        return this.eval(null, script, params);
    }

    public Object eval(String scriptName, String script, Map<String, Object> params) {
        if (StringUtil.isBlank(script)) {
            throw new IllegalArgumentException("A 'script' must not be blank");
        }
        long nanos = System.nanoTime();
        return this.runWithSandbox(() -> {
            ThreadLocalMap.clear();
            VeniceInterpreter venice = new VeniceInterpreter(this.meterRegistry, this.interceptor, this.loadPaths);
            Env env = this.createEnv(venice, params);
            this.meterRegistry.reset();
            this.meterRegistry.record("venice.setup", System.nanoTime() - nanos);
            VncVal result = venice.RE(script, scriptName, env);
            Object jResult = result.convertToJavaObject();
            this.meterRegistry.record("venice.total", System.nanoTime() - nanos);
            return jResult;
        });
    }

    public static String getVersion() {
        return "1.7.10";
    }

    public void enableJavaInteropReflectionCache(boolean enable) {
        ReflectionAccessor.enableCache(enable);
    }

    public boolean isJavaInteropReflectionCacheEnabled() {
        return ReflectionAccessor.isCacheEnabled();
    }

    public void enableTimer() {
        this.meterRegistry.enable();
    }

    public void disableTimer() {
        this.meterRegistry.disable();
    }

    public void resetTimer() {
        this.meterRegistry.reset();
    }

    public Collection<Timer> getTimerData() {
        return this.meterRegistry.getTimerData();
    }

    public String getTimerDataFormatted(String title) {
        return this.meterRegistry.getTimerDataFormatted(title);
    }

    private Env createEnv(VeniceInterpreter venice, Map<String, Object> params) {
        return this.addParams(venice.createEnv(), params);
    }

    private Env addParams(Env env, Map<String, Object> params) {
        boolean stdoutAdded = false;
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                if (key.equals("*out*")) {
                    env.setStdoutPrintStream(this.buildStdOutPrintStream(val));
                    stdoutAdded = true;
                    continue;
                }
                env.setGlobal(new Var(new VncSymbol(key), JavaInteropUtil.convertToVncVal(val)));
            }
        }
        if (!stdoutAdded) {
            env.setStdoutPrintStream(this.stdout);
        }
        return env;
    }

    private PrintStream buildStdOutPrintStream(Object val) {
        if (val == null) {
            return new PrintStream(new NullOutputStream());
        }
        if (val instanceof PrintStream) {
            return (PrintStream)val;
        }
        if (val instanceof OutputStream) {
            return new PrintStream((OutputStream)val, true);
        }
        throw new VncException(String.format("The *out* parameter value (%s) must be either null or an instance of PrintStream or OutputStream", val.getClass().getSimpleName()));
    }

    private Object runWithSandbox(Callable<Object> callable) {
        try {
            if (this.interceptor.getMaxFutureThreadPoolSize() != null) {
                ConcurrencyFunctions.setMaximumThreadPoolSize(this.interceptor.getMaxFutureThreadPoolSize());
            }
            if (this.interceptor.getMaxExecutionTimeSeconds() == null) {
                return new SandboxedCallable<Object>(this.interceptor, callable).call();
            }
            return this.runWithTimeout(new SandboxedCallable<Object>(this.interceptor, callable), this.interceptor.getMaxExecutionTimeSeconds());
        }
        catch (ValueException ex) {
            throw new JavaValueException(ex.getValue().convertToJavaObject());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private Object runWithTimeout(Callable<Object> callable, int timeoutSeconds) throws Exception {
        try {
            Future<Object> future = executor.submit(callable);
            return future.get(this.interceptor.getMaxExecutionTimeSeconds().intValue(), TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new SecurityException("Venice Sandbox: The sandbox exceeded the max execution time");
        }
    }

    private Env getPrecompiledEnv() {
        Env env = this.precompiledEnv.get();
        if (env == null) {
            env = new VeniceInterpreter().createEnv().setStdoutPrintStream(null);
            this.precompiledEnv.set(env);
        }
        return env.copyGlobalToPrecompiledSymbols();
    }
}

