/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.GenSym;
import com.github.jlangch.venice.impl.types.VncSymbol;
import java.util.HashMap;
import java.util.Map;

public class AutoGenSym {
    private boolean insideSyntaxQuote;
    private final Map<VncSymbol, VncSymbol> autogenSymMap = new HashMap<VncSymbol, VncSymbol>();

    public void enterSyntaxQuote() {
        this.insideSyntaxQuote = true;
        this.autogenSymMap.clear();
    }

    public void leaveSyntaxQuote() {
        this.insideSyntaxQuote = false;
        this.autogenSymMap.clear();
    }

    public boolean isWithinSyntaxQuote() {
        return this.insideSyntaxQuote;
    }

    public boolean isAutoGenSymbol(VncSymbol sym) {
        String name = sym.getName();
        return name.length() > 1 && name.endsWith("#");
    }

    public VncSymbol lookup(VncSymbol sym) {
        return this.isAutoGenSymbol(sym) ? this.autogenSymMap.computeIfAbsent(sym, s -> this.genAutoSym((VncSymbol)s)) : sym;
    }

    private VncSymbol genAutoSym(VncSymbol sym) {
        return GenSym.generateAutoSym(this.stripTrailingHash(sym.getName()));
    }

    private String stripTrailingHash(String s) {
        return s.substring(0, s.length() - 1);
    }
}

