/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;

public class ModuleFunctions {
    public static VncFunction loadModule = new VncFunction("*load-module", VncFunction.meta().arglists("(*load-module name)").doc("Loads a Venice extension module.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("*load-module", args, 1);
            try {
                String name = Coerce.toVncString(CoreFunctions.name.apply(args)).getValue();
                IInterceptor interceptor = JavaInterop.getInterceptor();
                interceptor.validateLoadModule(name);
                return new VncString(ModuleLoader.loadModule(name));
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice module", ex);
            }
        }
    };
    public static VncFunction loadClasspathFile = new VncFunction("*load-classpath-file", VncFunction.meta().arglists("(*load-classpath-file name)").doc("Loads a Venice file from the classpath.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("*load-classpath-file", args, 1);
            try {
                String file = ModuleFunctions.suffixWithVeniceFileExt(ModuleFunctions.name(args.first()));
                if (file != null) {
                    String res = ModuleLoader.loadClasspathFile(file);
                    return res == null ? Constants.Nil : new VncString(res);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice classpath file", ex);
            }
        }
    };
    public static VncFunction loadFile = new VncFunction("*load-file", VncFunction.meta().arglists("(*load-file file load-paths)").doc("Loads a Venice file.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("*load-file", args, 1, 2);
            try {
                String f = ModuleFunctions.suffixWithVeniceFileExt(ModuleFunctions.name(args.first()));
                if (f != null) {
                    VncList loadPaths;
                    File file = new File(f);
                    VncList vncList = loadPaths = args.size() == 2 && Types.isVncList(args.second()) ? (VncList)args.second() : new VncList();
                    if (file != null) {
                        if (loadPaths.isEmpty()) {
                            VncVal code = ModuleFunctions.load(file);
                            if (code != Constants.Nil) {
                                return code;
                            }
                        } else {
                            if (file.isAbsolute()) {
                                throw new VncException("Failed to load Venice file '" + file + "'. Absolute files cannot be used with a load-path!");
                            }
                            for (VncVal p : loadPaths.getList()) {
                                VncVal code;
                                File dir;
                                File fl;
                                if (p == Constants.Nil || !(fl = new File(dir = new File(ModuleFunctions.name(p)).getAbsoluteFile(), file.getPath())).isFile() || !fl.getCanonicalPath().startsWith(dir.getCanonicalPath()) || (code = ModuleFunctions.load(new File(dir, file.getPath()))) == Constants.Nil) continue;
                                return code;
                            }
                        }
                        throw new VncException("Failed to load Venice file '" + file + "'. File not found!");
                    }
                }
                return null;
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice file", ex);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(loadModule).add(loadFile).add(loadClasspathFile).toMap();

    private static VncVal load(File file) {
        try {
            byte[] data = Files.readAllBytes(file.toPath());
            return new VncString(new String(data, "utf-8"));
        }
        catch (Exception ex) {
            return Constants.Nil;
        }
    }

    private static String name(VncVal val) {
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        if (Types.isVncKeyword(val)) {
            return ((VncKeyword)val).getValue();
        }
        if (Types.isVncSymbol(val)) {
            return ((VncSymbol)val).getName();
        }
        return null;
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s == null ? null : (s.endsWith(".venice") ? s : s + ".venice");
    }
}

