/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.Tuple3;
import java.util.List;
import java.util.stream.Collectors;

public class VncMultiArityFunction
extends VncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private final List<Tuple3<VncFunction, Integer, Boolean>> functions;

    public VncMultiArityFunction(String name, List<VncFunction> functions) {
        super(name);
        if (functions == null || functions.isEmpty()) {
            throw new VncException("A multi-arity function must have at least one function");
        }
        this.functions = functions.stream().map(fn -> new Tuple3<VncFunction, Integer, Boolean>((VncFunction)fn, VncMultiArityFunction.countFixedArgs(fn.getParams()), VncMultiArityFunction.hasRemaingsArgs(fn.getParams()))).collect(Collectors.toList());
    }

    @Override
    public VncMultiArityFunction withMeta(VncVal meta) {
        super.withMeta(meta);
        return this;
    }

    @Override
    public VncVal apply(VncList params) {
        VncFunction fn = this.findFunction(params.size());
        if (fn == null) {
            throw new VncException("No matching multi-arity function");
        }
        return fn.apply(params);
    }

    @Override
    public int typeRank() {
        return 101;
    }

    private VncFunction findFunction(int arity) {
        int fixedArgs = -1;
        VncFunction fn = null;
        for (Tuple3<VncFunction, Integer, Boolean> f : this.functions) {
            if (!((Boolean)f._3).booleanValue()) {
                if (!((Integer)f._2).equals(arity)) continue;
                return (VncFunction)f._1;
            }
            if (arity < (Integer)f._2 || (Integer)f._2 <= fixedArgs) continue;
            fixedArgs = (Integer)f._2;
            fn = (VncFunction)f._1;
        }
        return fn;
    }

    private static int countFixedArgs(VncVector params) {
        int fixedArgs = 0;
        for (VncVal p : params.getList()) {
            if (VncMultiArityFunction.isElisionSymbol(p)) break;
            ++fixedArgs;
        }
        return fixedArgs;
    }

    private static boolean hasRemaingsArgs(VncVector params) {
        for (VncVal p : params.getList()) {
            if (!VncMultiArityFunction.isElisionSymbol(p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isElisionSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("&");
    }
}

